#!/usr/bin/perl
#  Copyright 2001-2017 Leslie Richardson
#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

%lex = ( 'Main' => 'Main',
	 'Fees' => 'Fees',
	 'Add' => 'Add',
	 'Error' => 'Error',
	 'Title' => 'Title',
	 'Author' => 'Author',
	 'Textbook' => 'Textbook',
	 'Record(s) Stored' => 'Record(s) Stored',
	 'Contact' => 'Contact',
	 'Copy' => 'Copy',
	 'Code' => 'Code',
	 'Continue' => 'Continue',

	 );

use CGI;
use DBI;

my $self = 'tb_copyadd.pl';
my $maxcopy = 30; # number of copies to enter at one time.

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Add} $lex{Textbook} $lex{Copy}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href=\"$homepage\">$lex{Main}</a> |\n};
print qq{<a href=\"$feespage\">$lex{Fees}</a> ]\n};

print qq{<h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    setCopy();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    writeRecord();
}


#----------------
sub showStartPage {
#----------------

    # Load textbook titles
    my $sth = $dbh->prepare("select id, title, author, pubdate from book_title");
    $sth->execute;

    my %books;
    while ( my ( $id, $title, $author, $pubdate ) = $sth->fetchrow ) {
	$books{"$title - $author ($pubdate)"} = $id;
    }

    # form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    # Title of Books
    print qq{<tr><td class="bra">$lex{Title}</td><td class="la">\n};
    print qq{<select name="id"><option></option>\n};
    foreach my $key ( sort keys %books ) {
	print qq{<option value="$books{$key}">$key</option>};
    }
    print qq{</select></td></tr>\n};
    
    print qq{<tr><td class="bra">Number of Copies</td><td class="la">\n};
    print qq{<input type="text" size="4" name="copynumber"></td></tr>\n};

    print qq{<tr><td colspan="2" style="text-align:center;">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table>\n};
    print qq{</form></body></html>\n};

} # end of showStartPage



#----------
sub setCopy {  # enter copy information (identifier code)
#----------

    # foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }

    # Get Book Info
    my $sth = $dbh->prepare("select * from book_title where id = ?");
    $sth->execute( $arr{id} );
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # start form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="titleid" value="$arr{id}">\n};

    # Show Book Info
    print qq{<h3>$lex{Title}: $r{title} - $r{author} ($r{pubdate})</h3>\n};

    # Start Table
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    print qq{<tr><th>$lex{Copy}</th><th>Barcode/Identifier</th></tr>\n};

    # Show Copy Info
    for my $i ( 1 .. $arr{copynumber} ) {
	print qq{<tr><td class="la">$i</td><td class="la">\n};
	print qq{<input type="text" name="$i" size="10"></td></tr>\n};
    }

    print qq{<tr><td colspan="2" style="text-align:center;">\n};
    print qq{<input type="submit" value="$title"></td></tr>\n};

    print qq{</table>\n};

    print qq{<h3>Barcode/Identifier must be unique across ALL school texts</h3>\n};
    
    print qq{</form></body></html>\n};

} # end of setCopy



#--------------
sub writeRecord {
#--------------

    #foreach my $key ( sort keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }
    
    my $titleid = $arr{titleid};
    delete $arr{titleid};

    my $sth = $dbh->prepare("insert into book_copy ( titleid, barcode ) values( ?,? )");

    foreach my $key ( sort keys %arr ) {
	if ( $arr{$key} ) { # if we have a code value
	    $sth->execute( $titleid, $arr{$key} );
	    if ( $DBI::errstr ) { print "$DBI::errstr;<br>\n"; }
	}
    } 


    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Stored'}</h3>\n};

    } else {
	print qq{<h3>$lex{Error}:$DBI::errstr<br>\n};
	print qq{$lex{Contact} $adminname <a href="mailto:$adminemail">$adminemail</a></h3>\n};
    }

    print qq{<p>[ <a href="$homepage">$lex{Main}</a> | \n};
    print qq{<a href="$feespage">$lex{Fees}</a> | \n};
    print qq{<a href="$self">$title</a> ]\n};

    print qq{</p></body></html>\n};

    exit;

}
