#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Subject' => 'Subject',
	   'Title' => 'Title',
	   'Author' => 'Author',
	   'Publishing Date' => 'Publishing Date',
	   'Cost' => 'Cost',
	   'Bar Code' => 'Bar Code',
	   'Textbook' => 'Textbook',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'Delete' => 'Delete',
	   'Error' => 'Error',
	   'Date' => 'Date',
	   'Copy' => 'Copy',
	   'Count' => 'Count',
	   'Record(s) Deleted' => 'Record(s) Deleted',
	   'Out' => 'Out',

	   );

use DBI;
use CGI;

my $self = 'tb_copydel.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Delete} $lex{Textbook} $lex{Copy}";

print "$doctype\n<html><head><title>$title</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head>\n";

print "<body style=\"padding:1.5em;\">\n";
print "[ <a href=\"$homepage\">$lex{Main}</a> |\n";
print " <a href=\"$feespage\">$lex{Fees}</a> ]\n";
print "<h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    confirmDelete();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    deleteRecord();
}


#----------------
sub showStartPage {
#----------------

    # select values from textbook title table.
    $sth = $dbh->prepare("select id, title, author, pubdate, description
      from book_title order by title, author");
    $sth->execute;
    if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\">\n";

    print "<tr><th>$lex{Title}</th><th>$lex{Author}</th>";
    print "<th>$lex{Date}</th><th>$lex{Count}</th>\n";
    print "<th>$lex{Delete}</th></tr>\n";

    $sth1 = $dbh->prepare("select count(*) from book_copy where titleid = ?");
    
    while ( my ( $id, $title, $author, $pubdate ) = $sth->fetchrow ) {

	# Get book count
	$sth1->execute( $id );
	if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	print "<tr><td class=\"la\">$title</td><td class=\"la\">$author</td>\n";
	print "<td class=\"la\">$pubdate</td><td class=\"la\">$count</td>\n";

	# Delete Button
	print "<td>";
	if ( $count ) {
	    print qq{<form action="$self" method="post">\n};
	    print qq{<input type="hidden" name="id" value="$id">\n};
	    print qq{<input type="hidden" name="page" value="1">\n};
	    print qq{<input type="submit" value="$lex{Delete}"></form>\n};
	}
	print "</td></tr>\n";

    }

    print "</table></body></html>\n";

}


#----------------
sub confirmDelete {
#----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Load Title Information
    my $sth = $dbh->prepare("select * from book_title where id = ?");
    $sth->execute( $arr{id} );
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr }
    my $ref = $sth->fetchrow_hashref;
    print "<h3>$ref->{title} - $ref->{author} ($ref->{pubdate})</h3>\n";


    # Load Copy Information
    $sth = $dbh->prepare("select id, barcode from book_copy where titleid = ?");
    $sth->execute( $arr{id} );
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr }

    my $sth1 = $dbh->prepare("select count(*) from book_signout 
      where returndate is NULL and copyid = ?");


    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";
    print "<input type=\"hidden\" name=\"titleid\" value=\"$arr{id}\">\n";

    print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\">\n";
    print "<tr><th>$lex{Copy}</th><th>$lex{Delete}</th></tr>\n";


    while ( my ( $id, $code ) = $sth->fetchrow ) {

	$sth1->execute( $id );
	if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr }
	my $count = $sth1->fetchrow; # signed out book, can't delete

	print "<tr><td class=\"la\">$code</td><td class=\"cn\">\n";
	if ( not $count ) {
	    print "<input type=\"checkbox\" name=\"$id\" value=\"1\">";
	} else {
	    print $lex{Out};
	}
	print "</td></tr>\n";
    }
    
    print "<tr><td colspan=\"2\" style=\"text-align:center;\">\n";
    print "<input type=\"submit\" value=\"$lex{Delete}\">\n";
    print "</td></tr>\n";

    print "</table></form>\n";
    print "</center></body></html>\n";

    exit;

}


#---------------
sub deleteRecord {
#---------------

    foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $titleid = $arr{titleid};
    delete $arr{titleid};

    my $sth = $dbh->prepare("delete from book_copy where id = ?");

    foreach my $key ( keys %arr ) {

	 # Delete the record
	 $sth->execute( $key );
	 if ( $DBI::errstr ) { print "$DBI::errstr<br>\n"; }

    }

    if ( not $DBI::errstr ) {
	print "<h3>$lex{'Record(s) Deleted'}</h3>\n";

    } else {
	print "<h3>$lex{Error} $DBI::errstr<br>$lex{Contact} $adminname</h3>\n";
    }

    print "<p>[ <a href=\"$self\">$lex{Delete} $lex{Copy}</a>\n";
    print "| <a href=\"$homepage\">$lex{Main}</a> | <a href=\"$feespage\">$lex{Fees}</a> ]</p>\n";

    print "</center></body></html>\n";

    exit;

}
