#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Export Translation' => 'Export Translation',
	   'Eoy' => 'Eoy',
	   'Translation' => 'Translation',
	   'All Phrases' => 'All Phrases',
	   'No Translation' => 'No Translation',
	   'Only Phrases with No Translation' => 'Only Phrases with No Translation',
	   'Continue' => 'Continue',
	   'You should &quot;right click&quot; on this and save the file.' =>
	     'You should &quot;right click&quot; on this and save the file.',
	   'Download File' => 'Download File',

	   );

my $self = 'xlatExportPO.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
print "$doctype\n<html><head><title>". $lex{'Export Translation'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";
print "<center><h1>". $lex{'Export Translation'}. "</h1></center>\n";

if ( not $arr{page} ) {
    showStartPage();
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    exportTranslation();
} 


#--------------------
sub exportTranslation {
#--------------------

    #foreach my $key (keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    
    # Create po file.
    my $pofile = "export$$.po";

    # Open PO file for writing.
    unless (open (FH,">$pofile")) {
	print $lex{Error}. " $!<br>\n";
	die $lex{Error}. " $!\n";
    }

    my %phrases = ();
    my $sth = $dbh->prepare("select phrase from xlat_phrase order by phrase");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $phrase = $sth->fetchrow ) {
	$phrases{$phrase} = 1;
    }

    #foreach my $key ( sort keys %phrases ) { print "K:$key  V:$phrases{$key}<br>\n"; }

    my $sth1 = $dbh->prepare("select translation, phrase from xlat_lang where phrase = ?");

    foreach my $phrase ( sort keys %phrases ) {
	my $trans;
	if ( $arr{mode} eq 'all' ) {

	    # Now find an existing translation value, if any.
	    $sth1->execute( $phrase );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    while ( my ( $testtrans, $testphrase ) = $sth1->fetchrow ) {
		if ( $phrase eq $testphrase ) {
		    $trans = $testtrans;
		    last;
		}
	    }
		
	} elsif ( $arr{mode} eq 'selnotrans' ) { 

	    # Now find an existing translation value, if any.
	    $sth1->execute( $phrase );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    while ( my ( $testtrans, $testphrase ) = $sth1->fetchrow ) {
		if ( $phrase eq $testphrase ) {
		    $trans = $testtrans;
		    last;
		}
	    }
	    
	    if ( $trans ) { next; }
	}  

	$phrase = q{"}. $phrase. q{"};
	$trans = q{"}. $trans. q{"};
	print FH "#:$file \nmsgid $phrase\nmsgstr $trans\n\n";
    
    }

    close FH;

    # Now allow for download...
    system("mv $pofile $downloaddir");

    print "<center><p>[ <a href=\"$webdownloaddir/$pofile\">";
    print $lex{'Download File'}. "</a> ]</p>\n<p>";
    print $lex{'You should &quot;right click&quot; on this and save the file.'}. "</p>\n";
    print "</center></body></html>\n";

    exit;

}


#----------------
sub showStartPage {
#----------------

    print "<center><table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";
    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    print "<tr><td align=\"right\">". $lex{'All Phrases'}. " + ". $lex{'Translation'};
    print "</td>\n<td><input type=\"radio\" name=\"mode\" value=\"all\">";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">". $lex{'All Phrases'}. " + ". $lex{'No Translation'};
    print "</td>\n<td><input type=\"radio\" name=\"mode\" value=\"allnotrans\">";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">". $lex{'Only Phrases with No Translation'};
    print "</td>\n<td><input type=\"radio\" name=\"mode\" value=\"selnotrans\">";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">";
    print "<input type=\"submit\" value=\"". $lex{Continue}. "\"></td><td></td></tr>\n";
    print "</form></table></body></html>\n";

    exit;

}
