#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View Phrase' => 'View Phrase',
	   'Main' => 'Main',
	   'Error' => 'Error',
	   'Phrase' => 'Phrase',
	   'Count' => 'Count',
	   'Click Button of Choice' => 'Click Button of Choice',
	   'Eoy' => 'Eoy',
	   'deleted' => 'deleted',
	   'Delete' => 'Delete',
	   'Summary View' => 'Summary View',
	   'Full View' => 'Full View',


	   );

my $self = 'xlatPhraseView.pl';
my $maxrecwidth = 4;

use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset);
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# print top of Page
print "$doctype\n<html><head><title>". $lex{'View Phrase'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";

print "<form action=\"$self\" method=\"post\" style=\"display:inline;\">\n";
print "<input type=\"hidden\" name=\"fullflag\" value=\"0\">\n";
print "<input type=\"submit\" value=\"". $lex{'Summary View'}. "\"></form>\n";

print "<form action=\"$self\" method=\"post\" style=\"display:inline;\">\n";
print "<input type=\"hidden\" name=\"fullflag\" value=\"1\">\n";
print "<input type=\"submit\" value=\"". $lex{'Full View'}. "\"></form>\n";

if ( $arr{id} ) {
    deletePhrase( $arr{id} );
    delete $arr{id};
}


# Print Translation List
print "<center><h1>". $lex{'View Phrase'}. "</h1>\n";
print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">\n";

if ( not defined $arr{fullflag} ) {
    print $lex{'Click Button of Choice'}. "\n";
    print "</body></html>\n";
    die;
}


my %phrases = ();
my $sth = $dbh->prepare("select phrase from xlat_phrase order by phrase"); 
$sth->execute;
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr;}
while ( my $phrase = $sth->fetchrow ) {
    if ( $phrases{$phrase} ) { 
	$phrases{$phrase}++;
    } else {
	$phrases{$phrase} = 1;
    }
}

#print "</center><p align=\"left\"\n";
#foreach my $key ( sort keys %phrases ) { print "K:$key V:$phrases{$key}<br>\n"; }
#print "</p>\n";

print '<tr><th>'. $lex{Phrase}. '</th><th>'. $lex{Count}. "</th></tr>\n";
my $sth1 = $dbh->prepare("select area, file, phrase from xlat_phrase where phrase = ?"); 

foreach my $phrase ( sort {lc $a cmp lc $b} keys %phrases ) {

    print "<tr><td>";

    my $pcount = $phrases{$phrase};

    # Delete Button
#    print "<form action=\"$self\" method=\"post\" style=\"display:inline;\">\n";
#    print "<input type=\"hidden\" name=\"fullflag\" value=\"$arr{fullflag}\">\n";
#    print "<input type=\"hidden\" name=\"id\" value=\"$id\">\n";
#    print "<input type=\"submit\" value=\"". $lex{Delete}. "\"></form>\n";

    my $trphrase = $phrase;
    $trphrase =~ s/</&lt;/g;
    $trphrase =~ s/>/&gt;/g;
    print "<b>$trphrase</b></td>";

    if ( $arr{fullflag} ){

	$sth1->execute( $phrase );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	print "<td>\n";
	my $count = 1;
	while ( my ( $area, $file, $testphrase ) = $sth1->fetchrow ) {
	    if ( $phrase eq $testphrase ) {
		print "$file ($area ) | \n";
		if ( $count % 3 == 0 ) { print "<br>\n"; }
		$count++;
	    }
	}
	print "</td></tr>\n";
    } else {
	print "<td>$pcount</td></tr>\n";
    }

}

print "</table></center></body></html>\n";


#---------------
sub deletePhrase {
#---------------

    my $id = shift;

    my $sth = $dbh->prepare("select phrase from xlat_phrase where id = ?"); 
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $phrase = $sth->fetchrow;

    $phrase =~ s/</&lt;/g;
    $phrase =~ s/>/&gt;/g;

    my $sth = $dbh->prepare("delete from xlat_phrase where id = ?"); 
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr;}
    
    print "<div style=\"border: 1px solid gray;padding:0.5em;\">". $lex{Phrase};
    print " <b>$phrase</b> ". $lex{deleted}. "</div>\n";

}
