# subjects to check for credits in 10,11,12.

=head

4049 ELA A 11
4050 ELA B 11
4271 Science 11
4318 Social Studies 11
4306 History 10
4329 Native Studies 11 (LMD)
4439 Math 11(2010)

Modified Down
4102 ELA A 11
4103 ELA B 11



6049 ELA 21
6266 Env Science 21
6267 Phys Science 21
6265 Health Science 21 (2016)
6318 Social Studies 21
6439 Math 21
6329 Native Studies 21

8102 ELA A 31
8103 ELA B 31
8306 History 30: Canadian Studies
8318 Social Studies 31
8329 Native Studies 31
=cut


# This is the latest updated for SK curriculum
#----------------
sub checkCredit10 { # check grade 10 completion list; return any errors (missing requirements)
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my ($provnum, $graderef, $dbh, $studnum) = @_; # passed provincial number, dbh
    # studnum only supplied for the preplancoursemaster.pl, to get students passing current courses.

    # reference passed in above
    my %saskedgrade = %$graderef;

    # Load their completed courses
    my $sth = $dbh->prepare("select courseid from sasked_completedcourses 
			    where provnum = $provnum and creditsearned > 0.1");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my %completed;
    while ( my $courseid = $sth->fetchrow ) {
	$completed{$courseid} = 1;
    }

    if ( $studnum ) {  # only called by preplancoursemaster.pl
	# Load courses in progress, and passing.

	my $sth = $dbh->prepare("select subjcode, a1 from eval where studnum = ?");
	$sth->execute( $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
	while ( my ($subjcode, $a1) = $sth->fetchrow ) {
	    $subjcode =~ s/-.*//g;
	    if ( $a1 >= 50 ) {  # assume they will complete; # and not $completed{$subjcode} ) {
		$completed{$subjcode} = 1;
	    }
	}
    }

    my @incomplete; # return text based codes
    my @ignore; # skip for electives
    
    
    # Go through the completion requirements;

    # 1. ELA A 10 (4017) / Mod 4102 / ELA B10 (4018) / Mod 4103 / NEW ELA 10 4124
    my $elapass;
    foreach my $code ( qw(4017 4102 4018 4103 4124)) {
	if ( $completed{$code} ) { # code is "course code"
	    $elapass = 1;
	    push @ignore, $code;
	}
    }
	
    #if ( not $completed{4017} and not $completed{4102} and
    # not $completed{4018} and not $completed{4103} and not $completed{4124} ) {  # they only need one now
    if ( not $elapass ) {
	push @incomplete, 'ELA 10';
    }

    

    # 2. Science 10 (4214) / 4271
    my $scipass;
    foreach my $cc ( qw(4214 4271)) {
	if ( $completed{$cc} ) { # cc is "course code"
	    $scipass = 1;
	    push @ignore, $cc;	    
	} 
    }
	
    #if ( not $completed{4214} and not $completed{4271} ) {
    if ( not $scipass ) {
	push @incomplete, 'Science 10';
    }

    
    # 3. A Math (4424 (Foundations), or 4423 (Workplace)) / 4439
    my $mathpass;
    foreach my $cc ( qw(4424 4423 4439)) {
	if ( $completed{$cc} ) { # cc is "course code"
	    $mathpass = 1;
	    push @ignore, $cc;	    
	}
    }
	
    if ( not $mathpass ) {
	push @incomplete, '10 Math';
    }


    # 4. A Social Science SS10 (4307), Hist10 (4306), Native Stud 10 (4309)
    #    OR SS11(4318) OR NatStud 4329
    my $socpass;
    foreach my $cc ( qw(4307 4306 4309 4318 4329)) {
	if ( $completed{$cc} ) { # cc is "course code"
	    $socpass = 1;
	    push @ignore, $cc;
	}
    }

    if ( not $socpass ) {
	push @incomplete, '10 Social';
    }

    
    # 5. 4 or more electives at 10 level or higher.
    my %ignore = map { $_ => 1 } @ignore;
    my @electives;
    foreach my $courseid ( keys %completed ) { 
	my $grade = $saskedgrade{$courseid};
	if ( $grade < 10 ) { next; } # lower grade level
	if ( $ignore{$courseid} ) { next; } # these don't count, done above.

	push @electives, $courseid;
    }

    if ( @electives < 4 ) { # error
	push @incomplete, '10 Electives';
    }

    return @incomplete;

} # end of checkCredit10



#----------------
sub checkCredit11 { # check grade 11 completion list; return any errors (missing requirements)
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my ($provnum, $graderef, $dbh) = @_; # passed provincial number, dbh

    # reference passed in above
    my %saskedgrade = %$graderef;

    
    # Load their completed courses
    my $sth = $dbh->prepare("select courseid from sasked_completedcourses where 
			    provnum = $provnum and creditsearned > 0.1");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my %completed;
#    print qq{<b>Credit 11:$provnum</b><br>\n};
    while ( my $courseid = $sth->fetchrow ) {
#	print "$saskedname{$courseid} ($courseid)/ ";
	$completed{$courseid} = 1;
    }


    my @incomplete; # return text based codes
    my %ignore; # codes to ignore (since credit already given)

    # Go through the completion requirements;

    # 1. ELA 20 (6017) / ELA 21 (6102)
    if ( not $completed{6017} and not $completed{6102} ) {
	push @incomplete, 'ELA 20';
    } else {
	$ignore{6017} = 1;
	$ignore{6102} = 1;
    }

    # 2. Sciences ( Enviro 6246, Physical 6247, Health 6245, Computer
    # 6702 ) (#physics 20 (6213) and chem 20 (6212) no longer allowed
    # Modified: Env 21 6266, Phys 21 6267, Hlth 21 6265
    
    my $incompleteflag = 1; # assume incomplete unless we find a completed course;
    foreach my $cid ( qw(6245 6246 6247 6702 6212 6213 6265 6266 6267)) {  
	if ( $completed{$cid} ) { 
	    $incompleteflag = 0; 
	    $ignore{$cid} = 1; # add this course to the ignore list, 
	         # since we get a credit for this, can't be elective.
	}
    }
    if ( $incompleteflag ) {
	push @incomplete, '11 Science';
    }


    # 3. A Math ( 6423 Workplace, 6425 Foundations, 6426 Pre-Calculus, 6439 Math 21 )
    my $incompleteflag = 1; # assume incomplete unless we find a completed course;
    foreach my $cid (qw(6423 6425 6426 6439)) {
	if ( $completed{$cid} ) { 
	    $incompleteflag = 0; 
	    $ignore{$cid} = 1; # add this course to the ignore list, 
	       # since we get a credit for this, can't be elective.
	}
    }
    if ( $incompleteflag ) {
	push @incomplete, '11 Math';
    }


    # 4. A Social Science (big list) (modified: Social 6318, Nat St 21 6329)
    my $incompleteflag = 1; # assume incomplete unless we find a completed course;
    foreach my $cid ( qw(6306 6309 6307 2140 2150 6340 8306 8321 8307 8339 3140 3150 8340 4318 6318 6329)) {
	if ( $completed{$cid} ) { 
	    $incompleteflag = 0;
	    $ignore{$cid} = 1; # add this course to the ignore list, can't be elective.
	}
    }
    if ( $incompleteflag ) {
	push @incomplete, '11 Social';
    }


    # 5. 3 more electives at 11 level or higher.
    # Loop over completed courses
    my @electives;
    foreach my $courseid ( keys %completed ) { 
	my $grade = $saskedgrade{$courseid};
	# print "Course:$courseid Grade:$grade<br>\n";

	if ( $ignore{$courseid} ) { next; } # these don't count, done above.
	if ( $grade < 11 ) { next; } # lower grade level
	push @electives, $courseid;
    }

    if ( @electives < 3 ) { # error
	push @incomplete, '11 Electives';
    }

    return @incomplete;


} # end of checkCredit11


#----------------
sub checkCredit12 { # check grade 12 completion list; return any errors (missing requirements)
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my ($provnum, $graderef, $dbh) = @_; # passed provincial number, dbh

    # reference passed in above
    my %saskedgrade = %$graderef;

    
    # Load their completed courses
    my $sth = $dbh->prepare("select courseid from sasked_completedcourses 
       where provnum = $provnum and creditsearned > 0.1");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my %completed;
#    print qq{<b>Credit 11:$provnum</b><br>\n};
    while ( my $courseid = $sth->fetchrow ) {
#	print "$saskedname{$courseid} ($courseid)/ ";
	$completed{$courseid} = 1;
    }


    my @incomplete; # return text based codes
    my %ignore; # codes to ignore (since credit already given)


    # Go through the completion requirements;

    # 1. ELA A30 (8017) / ELA 31 (8102) / ELA B 30 (8018) / ELA B 31 8103
    if ( not $completed{8017} and not $completed{8102} ) {
	push @incomplete, 'ELA A30';
    } else {
	$ignore{8017};
	$ignore{8102};
    }

    # 2. ELA B 30 / ELA B 31 8103
    if ( not $completed{8018} and not $completed{8103} ) {
	push @incomplete, 'ELA B30';
    } else {
	$ignore{8018};
	$ignore{8103};
    }


    # 3. A Social Science
    my ($cdnflag, $g10flag, $g1112flag); 
    # flags to show if done both gr 10 credit and 11/12 credit for these other SS courses.
    
    foreach my $cid ( qw(8306 8321 8307 8318 8329)) { # Modified SocSt 31 8318, NatSt 31, 8329
	if ( $completed{$cid} ) { 
	    $cdnflag = 1;
	    $ignore{$cid} = 1; # add this course to the ignore list, since we get a credit for this.
	}
    }

    # Now check the rest
    foreach my $cid ( qw(4306 4307 4309 6306 6307 6309 2140 2150 6340 8339 3140 3150 8340 6318 )) {
	# Note: 6318 is a grade 11 modified social course, just added.
	if ( $completed{$cid} ) { 
	    # if ( $saskedgrade{$cid} == 10 ) { $g10flag = 1; }
	    if ( $saskedgrade{$cid} == 11 or $saskedgrade{$cid} == 12 ) { $g1112flag = 1; }
	    $ignore{$cid} = 1;
	}
    }

    if ( not $cdnflag or  not $g1112flag ) { # removed grade 10 flag: not $g10flag or
	push @incomplete, '12 Social';
    }


    # 4. Electives: 6 more electives at 11 level or higher.
    # Loop over completed courses
    my @electives;
    foreach my $courseid ( keys %completed ) {
	my $grade = $saskedgrade{$courseid};

	if ( $ignore{$courseid} ) { next; } # these don't count, done above.
	if ( $grade < 11 ) { next; } # lower grade level
	push @electives, $courseid;
    }

    if ( @electives < 6 ) { # error
	push @incomplete, '12 Electives';
    }

    return @incomplete;

} # end of checkCredit12



#---------------------
sub checkCreditAdult12 { # check Adult 12 Program (code 46 was 09) completion list; 
#---------------------   # return any errors (missing requirements)

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my ($provnum, $graderef, $dbh) = @_; # passed provincial number, grade map, dbh

    # reference passed in above
    my %saskedgrade = %$graderef;
    # Simply the saskedgrade{coursecode} = grade #(the grade level course is for)
    # Simply an efficiency hash loaded by the calling program, only once.

    
    # Load their completed courses; they have a credit.
    my $sth = $dbh->prepare("select courseid from sasked_completedcourses 
       where provnum = $provnum and creditsearned > 0.1");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my %completed;
#    print qq{<b>Credit 11:$provnum</b><br>\n};
    while ( my $courseid = $sth->fetchrow ) {
	if ( $saskedgrade{$courseid} < 11 ) { next; } # skip grade 10 courses.
#	print "$saskedname{$courseid} ($courseid)/ ";
	$completed{$courseid} = 1;
    }


    my @incomplete; # returns text based codes
    my %ignore; # codes to ignore (since credit already given)


    # Go through the completion requirements;

    # 1. ELA A30 / ELA 31 (8102)
    if ( not $completed{8017} and not $completed{8102} ) {
	push @incomplete, 'ELA A30';
    } else {
	$ignore{8017};
	$ignore{8102};
    }


    # 2. ELA B 30 / ELA B 31 8103
    if ( not $completed{8018} and not $completed{8103} ) {
	push @incomplete, 'ELA B30';
    } else {
	$ignore{8018};
	$ignore{8103};
    }


    # 3. Social Science 30 (History, Native Studies, Social Studies)
    my @temp;
    foreach my $cid ( qw(8306 8321 8307 8318 8329 8310)) { 
	# Modified SocSt 31 - 8318, NatSt 31 - 8329, History 31 - 8310
	# store completed courses; prefer any grade 11 course; leave 12's for electives
	if ( $completed{$cid} ) {
	    push @temp, $cid;
	}
    }
    # Check grade for each completed course; take an 11. If no 11's, take the first one in array
    foreach my $cid ( @temp ) {
	if ( $saskedgrade{$cid} == 11 ) {
	    $socialFlag = 1;
	    $ignore{$cid} = 1; # add this course to the ignore list, since we get a credit for this.
	    last; # only need one to fulfill requirement, others may be 12 electives.
	}
    }
    if ( not $socialFlag and @temp ) { # pull from the array if no 11 courses found.
	my $cid = pop @temp;
	$socialFlag = 1;
	$ignore{$cid} = 1;
    }

    if ( not $socialFlag ) {
	push @incomplete, '12 Social';
    }

    

    # 4. A Science at 11/12 level.
    my $scienceFlag;
    my @temp;
    foreach my $cid ( qw(6245 6246 6247 6702 8251 8255 8256 8257 8702  6265 6266 6267)) { 
	# 11 Health, Enviro Physical CompSci, then 12 Earth Bio30 Chem30 Phys30 CompSci30
	# Modified Down 21 courses: Env 6266, Health 6265, Physical 6267
	if ( $completed{$cid} ) {
	    push @temp, $cid;
	}
    }
    # Check grade for each completed course; take an 11. If no 11's, take the first one in array
    foreach my $cid ( @temp ) {
	if ( $saskedgrade{$cid} == 11 ) {
	    $scienceFlag = 1;
	    $ignore{$cid} = 1; # add this course to the ignore list, since we get a credit for this.
	    last; # only need one to fulfill requirement, others may be 12 electives.
	}
    }
    if ( not $scienceFlag and @temp ) { # pull from the array if no 11 courses found.
	my $cid = pop @temp;
	$scienceFlag = 1;
	$ignore{$cid} = 1;
    }

    if ( not $scienceFlag ) {
	push @incomplete, '11/12 Science';
    }


    # 5. A Math at 11/12 level.
    my $mathFlag;
    my @temp;
    foreach my $cid ( qw(8425 8426 8423 6425 6426 6423 6439 )) {
	# 12: Foundations, Precalc,Workplace 11:Foundations, Precalc, Workplace
	# 11 Modified Down: Math 21 6439
	if ( $completed{$cid} ) {
	    push @temp, $cid;
	}
    }
    # Check grade for each completed course; take an 11. If no 11's, take the first one in array
    foreach my $cid ( @temp ) {
	if ( $saskedgrade{$cid} == 11 ) {
	    $mathFlag = 1;
	    $ignore{$cid} = 1; # add this course to the ignore list, since we get a credit for this.
	    last; # only need one to fulfill requirement, others may be 12 electives.
	}
    }
    if ( not $mathFlag and @temp ) { # pull from the array if no 11 courses found.
	my $cid = pop @temp;
	$mathFlag = 1;
	$ignore{$cid} = 1;
    }

    if ( not $mathFlag ) {
	push @incomplete, '11/12 Math';
    }


    # 4. Electives: 2 more electives at 11 level or higher.
    # Loop over completed courses
    my @electives;
    foreach my $courseid ( keys %completed ) {
	my $grade = $saskedgrade{$courseid};

	if ( $ignore{$courseid} ) { next; } # these don't count, done above.
	push @electives, $courseid;
    }

    if ( @electives < 2 ) { # error
	push @incomplete, '12 Electives';
    }

    return @incomplete;


} # end of checkCreditAdult12


1;
