# libmeta.pl  Copyright Leslie Richardson, 2008-2012
#  Part of Open Admin for Schools,  Licensed under the GPL.

#-----------------
sub metaInputField {  # return HTML for data entry
#-----------------

    my ( $table, $field, $fv, $DBH, $fieldhdr ) = @_; 
    # passed table, field, field value, Handle, header (for muli-record edit ) 
    
    $tableref = $table;  # needed because no entries in meta for prereg or studentwd..
    if ($table eq 'studentwd' or $table eq 'prereg'){ $tableref = 'student';} 

    if ( $DBH ) { # if passed filehandle, use it.
	$dbh = $DBH;
    }

    # Find the record in the meta table
    my $sth = $dbh->prepare("select id, arrayidx, size, defaultvalue, 
     formtype, viewsize from meta where tableid = ? and fieldid = ?");
    $sth->execute( $tableref, $field);
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr;}
    
    my ($id, $index, $size, $default, $formtype, $viewsize) = $sth->fetchrow;
    if ( not $id ){ 
	print "<br><b>Error: missing value for Table: $table ";
        print "Field: $field</b><br>\n";
	exit;
    }


    # populate @defaults if needed.
    my @defaults = (); # used for select_tblval type.

    if ( lc($formtype) eq 'select_tblval' ) { # get 'select' vals from other records.

	my $sth = $dbh->prepare("select distinct $field from $table order by $field"); 
	$sth->execute; 
	if ($DBI::errstr){print	$DBI::errstr; die $DBI::errstr;} 
	while ( my $val = $sth->fetchrow ) { push @defaults, $val; }

    }

    if ( $fieldhdr ) { # for multi-record editing.
	$field = $fieldhdr. ':'. $field;
    }


    # Go through all form types.
    if ( lc($formtype) eq 'text' ){ # text input box

	my $rv = qq{<input type="text" name="$field" };
	if ( not $size ){ $size = 255; }
	if ( not defined $fv ) { $fv = $default; }
	$rv .= qq{size="$viewsize" maxlength="$size" value="$fv">\n};
	return $rv;

    } elsif ( lc($formtype) eq 'select' ){ # submit element

	my $rv = qq{<select name="$field"><option value="$fv">$fv</option>};
	$default =~ s/\s*$//; # remove trailing space.
	my @defaults = split /\s+/,$default;

	foreach my $df ( @defaults ){
	    if ($df =~ m/\~.*/) { next; }
	    if ($df eq $fv){ next; }
	    $df =~ s/_/ /g;  # replace underscores with spaces
	    $rv .= "<option>$df</option>";
	}
	$rv .= qq{<option value=""></option></select>\n}; # now include blank; 
	# above needed in edit mode when removing a value (reset to blank)
	return $rv;

    } elsif ( lc($formtype) eq 'select_tblval' ){ # select values already in table

	my $rv = qq{<select name="$field">};
	if ( $fv ){ $rv .= "<option>$fv</option>";}
	foreach my $df ( @defaults ) {
	    if ( $df eq $fv ){ next; }
	    $rv .= qq{<option>$df</option>};
	}
	$rv .= qq{<option value=""></option></select>\n}; # now include blank; 
	return $rv;

    } elsif ( lc($formtype) eq 'selecthash' ){ # get select vals from hash in default.

	$default =~ s/\s*$//; # remove trailing space.
	my %defaults = split /\s+/,$default;
	if ( not $defaults{$fv} ) { 
	    $defaults{$fv} = $fv;
	} # in case of only having code value
	$defaults{$fv} =~ s/_/ /g;  # replace underscores with spaces

	my $rv = qq{<select name="$field"><option value="$fv">$defaults{$fv}</option>\n};
	foreach my $key ( sort keys %defaults ){
	    if ($key eq $fv){ next; } # skip current value

	    my $df = $defaults{$key};
	    if ($df =~ m/\~.*/) { next; }
	    $df =~ s/_/ /g;  # replace underscores with spaces
	    $rv .= qq{<option value="$key">$df</option>};
	}
	$rv .= qq{<option value=""></option></select>\n}; # include blank

	return $rv;

    } elsif ( lc($formtype) eq 'textarea' ){ # textarea element

	$viewsize =~ s/\s//g; # strip any space.
	my ($rows, $cols);
	my ($row,$col) = split /x/,$viewsize;
	if ($row){ $rows = qq{rows="$row"}; }
	if ($col){ $cols = qq{cols="$col"}; }
	return qq{<textarea name="$field" $rows $cols>$fv</textarea>};

    } elsif ( lc($formtype) eq 'checkbox' ){ # checkbox element

	my $chk;
	if ( lc($fv) ne 'n' and $fv ){ # if not 'No' and it has a defined value...
	    $chk = 'checked="checked"';
	}
	my $rv = qq{<input type="checkbox" name="$field" };
	$rv .= qq{value="1" $chk>\n}; # change to 1 for yes, 0 for no.
	return $rv;

    } elsif ( lc($formtype) eq 'readonly' ){ # readonly (display only)

	# return a value to display only
	return $fv;

    } else { # unknown form element
	print "Error: Unknown form element type: $formtype for ";
	print "table: $table field: $field. ";
	print "We can handle text, textarea, checkbox, and select only!<br>\n";
	die;
    }

} # End of metaFieldInput


1;
