#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Dual Run Script:  cgi and tcgi, pcgi

%lex = ('Error' => 'Error',
	'No Record(s) Found' => 'No Record(s) Found',
	'Always On Top' => 'Always On Top',

);

use DBI;
use CGI;
use Cwd;
use Time::JulianDay;


# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

# foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

my $mode = $arr{mode};  # main mode for index.shtml display
delete $arr{mode};
my $mainmode;
if ( $mode eq 'main' ) { $mainmode = 1; }


my $desc = 'desc'; # descending sort
if ( $mainmode ) { $desc = ''; }  # displays on main page in normal order with oldest at the top.


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Set Style for Display Elements
if ( not $mainmode ) {
    print qq{<style>
 .annce { font-weight:bold;font-size:130%;
  font-family:Arial, Helvetica, sans-serif;}

 .anncetop { font-weight:bold;font-size:130%;
  font-family:Arial, Helvetica, sans-serif;
  background-color:#CCF; };
  </style>\n};
    
} else { # main mode
    print qq{<style>
 .annce { font-weight:bold;font-size:90%;
  font-family:Arial, Helvetica, sans-serif;}

 .anncetop { font-weight:bold;font-size:90%;
  font-family:Arial, Helvetica, sans-serif;
  background-color:#CCF; };
  </style>\n};
}
 
   

# Close window script.
print qq{<script>function closeWin(){ window.close(); }</script>\n};


my $select; # select for views depending on site, values passed.
my %announcements; # holds data structure.

if ( $arr{id} ) {
    $arr{id} =~ s/\D//g; # strip any non-numeric values
    my $sth = $dbh->prepare("select * from announce where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $dataref = $sth->fetchrow_hashref;
    my $id = $arr{id};

    $announcements{$id} = { $dataref };

} elsif ( $arr{sdate} ) { # starting date passed
    $arr{date} =~ s/\D//g; # strip any non-numeric values
    my $sth = $dbh->prepare("select * from announce 
      where to_days(adate) >= to_days('$arr{sdate}') order by adate $desc ");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $dref = $sth->fetchrow_hashref ) {
	print $dref, "<br>\n";
	my $id = $dref->{id};
	$announcements{$id} = { $dref };
    }

} else { # view all

    my $mode = getcwd();
    if ( $mode =~ m/tcgi|pcgi/ ){ # we are in parent or teacher
	print qq{<div style="padding:0.4em;">};
	print qq{<input type="button" value="Close" onclick="closeWin()"></div>\n};
    }

    if ( getcwd() =~ /tcgi/ ){ # we are in tcgi (teacher)
	$select = "atype = 'teacher' or atype = 'both'";
    } elsif ( getcwd() =~ /pcgi/ ){ # we are in pcgi (parent)
	$select = "atype = 'parent' or atype = 'both'";
    }

    # Top of Page Announcements
    my $topselect = "where topstay = 1";
    if ( $mainmode ) { $topselect = ''; } # no stay at top
    if ( $select ) {
	$topselect .= " and ($select)";
    }

    my $sth = $dbh->prepare("select * from announce $topselect order by adate desc");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my %topstay;
    my $first = 1;

    while ( my $ref = $sth->fetchrow_hashref ) {
	my $id = $ref->{id};
	$topstay{$ref->{id}} = 1; # holds records already displayed.
	my $date = fmtdate( $ref->{adate} );

	print qq{<div class="annce">};
	if ( not $mainmode ) {
	    print qq{<span style="color:red;">*</span> };
	}
	print qq{$ref->{atopic} - $ref->{author} - $date</div>\n};
	print qq{<div>$ref->{adesc}</div><hr>\n};
	$first = 0;
    }


    # Rest of Page Announcements
    if ( $select ) { $select = 'where '. $select; } # put in 'where'

    $sth = $dbh->prepare("select * from announce $select order by adate $desc");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    while ( my $ref = $sth->fetchrow_hashref ) {

	if ( $topstay{ $ref->{id} } ) { next; } # skip if already displayed on top.
	my $date = fmtdate( $ref->{adate} );

	print qq{<div class="annce">};
	print qq{$ref->{atopic} - $ref->{author} - $date</div>\n};
	print qq{<div>$ref->{adesc}</div><hr>\n};
	$first = 0;
    }

    if ( $first ) {
#	print qq{<div style="font-weight:bold;font-size:80%;">$lex{'No Record(s) Found'}</div>\n};
    }

}

#use Data::Dumper;
#print Dumper %announcements;

# print qq{<div>[<span style="color:red;">*</span> = $lex{'Always On Top'}]</div>\n};

my $mode = getcwd();
if ( $mode =~ m/tcgi|pcgi/ ){ # we are in parent or teacher
    print qq{<div style="padding:0.4em;">};
    print qq{<input type="button" value="Close" onclick="closeWin()"></div>\n};
} else { # separate page
    print qq{</body></html>\n};
}



#--------------------
sub showAnnouncements {
#--------------------

    my $ref = shift; # passed announcments ref

    # doesn't matter what key is, it is sorted on that key
    foreach my $key ( sort keys %$ref ) {

	my %rec = %{ $ref->{$key} };

	print qq{<div class="annce">};
	print qq{$rec{adate} &ndash; $rerec{atopic}</div>\n};
	print qq{<div>$rec{adesc}</div><hr>\n};
    }

    return;
}


#----------
sub fmtdate {
#----------

    my $date = shift;
    my ($yr, $mo, $da) = split(/-/, $date);

    my $month = $month[$mo];

    my $jd = julian_day( $yr, $mo,$da );
    my $dow = day_of_week( $jd ) + 1;
    my $day = $dow[$dow];

    my $rv = qq{$day, $month $da, $yr};

    return $rv;

}
