#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Edit an existing accident record

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Edit' => 'Edit',
	   'Name' => 'Name',
	   'Update' => 'Update',
	   'Injury' => 'Injury',
	   'Accident' => 'Accident',
	   'Record Updated' => 'Record Updated',
	   'Edit not allowed' => 'Edit not allowed',
	   'Scores' => 'Scores',
	   'Date' => 'Date',
	   'Close' => 'Close',
	   'Location' => 'Location',
	   'Time' => 'Time',
	   'Action' => 'Action',
	   'Taken' => 'Taken',

	   );

use DBI;
use CGI;
use Cwd;


my $self = 'accEdit.pl';


# Configuration Settings -----------------------
my $allow_author = 1; # allow author to edit
my $allow_accident = 1; # allow user with math access code to edit
#-----------------------------------------------

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my @time = localtime(time);
my $year = $time[5] + 1900;
my $month = $time[4] + 1;
my $currdate = "$year-$month-$time[3]";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}


# Get current dir so know what CSS to display and shift settings.
if ( getcwd() !~ /tcgi/ ) { # we are in cgi
    $tchcss = $css;
    $tchpage = $homepage;
    $tchdownloaddir = $downloaddir;
    $tchwebdownloaddir = $webdownloaddir;
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Check for access code
my $sth = $dbh->prepare("select field_value from staff_multi 
  where field_name = 'access' and userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

my $accessWR;
while ( my $val = $sth->fetchrow ) {
    if ( uc $val eq 'INJ' ) { $accessinjr = 1; }
    print qq{VAL:$val ACCESS:$accessWR<br>\n};
}


# Page Header
my $title = "$lex{Edit} Injury/Accident Records";
print qq{$doctype\n<html><head><title>$title</title>};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

if ( not $arr{page} ) { # date widget
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    editAccident();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    writeAccident();
}


#---------------
sub editAccident {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # id is passed.

    my $id = $arr{id};
    delete $arr{id};

    
    # Print Form Heading
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="id" value="$id">\n};


    # Get Accident Record
    my $sth = $dbh->prepare("select * from accident where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;
	
    my $studnum = $r{studnum};

=head	
	# Access Controls
	my $failflag;
	if ( not $allow_author and not $allow_cma ) { $failflag = 1; } # nobody edits
	elsif ( $allow_author and $r{tauthor} ne $userid ) { $failflag = 1; } # not author
	
	if ( $allow_cma and $accesscma ) { $failflag = 0; }
	# allow override of author failure for catalyst.

	if ( $failflag ) {
	    print qq{<h3>$lex{'Edit not allowed'}</h3>\n};
	    print qq{</body></html>\n};
	    exit;
	}
=cut
	
    # Get Student Record
    my $sth1 = $dbh->prepare("select * from student where studnum = ?");
    $sth1->execute( $studnum );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth1->fetchrow_hashref; #
    my %s = %$ref;

    # Print Table Header and Heading values
    print qq{<table cellpadding="3" cellspacing="0" border="0" style="border:1px solid gray;padding:0.2em;">\n};

    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Update}"></td></tr>\n};
    
    # Name
    print qq{<tr><td class="bra">$lex{Name}</td>};
    print qq{<td class="la">$s{firstname} $s{lastname}</td></tr>\n};

    # Injury Accident 
    print qq{<tr><td class="bra">$lex{Injury}/<br>$lex{Accident}</td>};
    print qq{<td class="la"><textarea rows="3" cols="60" name="injury">$r{injury}</textarea></tr></tr>\n};

    
    # Date
    print qq{<tr><td class="bra">$lex{Date}</td>};
    print qq{<td><input type="text" name="date" id="date" style="width:10ch;" };
    print qq{value="$r{date}">\n};
    print qq{<button type="reset" id="start_trigger">...</button>\n};
    print qq{</td></tr>\n};
    
    # Time
    print qq{<tr><td class="bra">$lex{Time}</td>};
    print qq{<td class="la"><input type="text" name="time" value="$r{time}"></tr></tr>\n};
    
    # Location
    print qq{<tr><td class="bra">$lex{Location}</td>};
    print qq{<td class="la"><input type="text" name="location" value="$r{location}"></tr></tr>\n};
    

    # Action Taken
    print qq{<tr><td class="bra">$lex{Action}/<br>$lex{Taken}</td>};
    print qq{<td class="la"><textarea rows="3" cols="60" name="action">$r{action}</textarea></tr></tr>\n};

    # Update
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Update}"></td></tr>\n};

    print qq{</table></form>\n};

    print qq{<script type="text/javascript">\n};

    print qq{Calendar.setup({
        inputField     :    "date", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    });};

    print qq{</script>\n};
    print qq{</body></html>\n};

    exit;

}


#-------------
sub writeAccident {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = $arr{id};
    delete $arr{id};

    my $first = 1;
    
    foreach my $field ( sort keys %arr ) {

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="0" };
	    print qq{style="border:1px solid gray;padding:0.2em;">\n};
	    print qq{<tr><th>Field</th><th>New Value</th></tr>\n};
	    $first = 0;
	}
	    

	if ( $field eq 'date' ) { # check validity
	    my $err = checkDate( $arr{$field} );
	    if ( $err == 1 ) {
		print qq{<h4>$lex{Error}: Date Outside School Year: $arr{$key}. Skipping</h4>\n};
		next;
	
	    } elsif ( $err ) {
		print qq{<h4>Date Error: $err. Skipping</h4>\n};
		next;
	    }
	}

	
	my $sth = $dbh->prepare("update accident set $field = ? where id = ?");  
	$sth->execute( $arr{$field}, $id );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	print qq{<tr><td class="bra">$field</td><td>$arr{$field}</td></tr>\n};

    }

    print qq{</table>\n};

    print qq{<h3>Record Updated</h3>\n};
    
    print qq{<div><b>Note:</b> Reload main view page to see updates</div>\n};

    print qq{<p><form><input type="hidden" name="none">\n};
    print qq{<input type="button" value="$lex{Close} this Tab" };
    print qq{onClick="parent.close()"></form></p>};

    print qq{</body></html>\n};
    
    exit;
}



#------------
sub checkDate {
#------------

    use Time::JulianDay;
    
    my $date = shift;

    my ($y,$m,$d) = split('-',$date);
    
    if ( not $d ) { return 255; }  # wrong format.
    if ( $m > 12 or $m < 1 ) { return 255; }
    if ( $d > 31 or $d < 1 ) { return 255; }

    my $datejd = julian_day( $y, $m, $d );

    my $startjd = julian_day( split('-', $schoolstart ));
    my $endjd = julian_day( split('-', $schoolend ));
    
#    print qq{DATE:$date - $datejd Start:$schoolstart - $startjd  End:$schoolend - $endjd<br>\n};

    if ( $datejd > $endjd  or $datejd < $startjd ) {
	return 1; # different code for date outside of current year;
    }
    
    return 0;

}
