#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

# View AAA / ATTPlus records in attitude/academic table


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Student' => 'Student',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',

	   );

use DBI;
use CGI;
use Cwd;

my $self = 'atpView.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print "$lex{Error}: $self: $@<br>\n";
    die "$lex{Error}: $self: $@\n";
}


# Get current dir so know what CSS to display and shift settings.
if ( getcwd() !~ /tcgi/ ) { # we are in cgi
    $tchcss = $css;
    $tchpage = $homepage;
    $tchdownloaddir = $downloaddir;
    $tchwebdownloaddir = $webdownloaddir;
}


my $q = new CGI;
print $q->header( -charset, $charset);
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = qq{View AttPlus Records};
print qq{$doctype\n<html><head><title>$title</title>\n}; 
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showGroups();
}


#----------------
sub showStartPage {
#----------------

    # Count Records in Each Table by Year-Month
    foreach my $table ( 'atp_academic', 'atp_attitude' ) {

	my $first = 1;
	my $sth1 = $dbh->prepare("select count(*) from $table where yrmo = ?"); 
    
	my $sth = $dbh->prepare("select distinct yrmo from $table order by yrmo"); 
	$sth->execute;
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

	my ($dud,$tname) = split('_', $table); # split table name apart
	$tname = ucfirst($tname);
	
	while ( my $yrmo = $sth->fetchrow ) {

	    my ($y,$m) = split('-', $yrmo);
	    
	    $sth1->execute($yrmo);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my $count = $sth1->fetchrow;

	    if ( $first ) {
		print qq{<table cellpadding="3" cellspacing="0" border="1" };
		print qq{style="margin:0.5em;float:left;">\n};
		print qq{<caption style="font-weight:bold;">$tname</caption>\n};
		print qq{<tr><th>Month</th><th>#Records</th><th>More</th></tr>\n};
		$first = 0;
	    }

	    print qq{<tr><td>$month[$m] $y</td><td class="cn">$count</td>};

	    # Start Form
	    print qq{<td>\n};
	    print qq{<form action="$self" method="post"> \n};
	    print qq{<input type="hidden" name="page" value="1">\n};
	    print qq{<input type="hidden" name="yrmo" value="$yrmo">\n};
	    print qq{<input type="submit" value="View" value="1">\n};
	    print qq{</form>\n};
	    print qq{</td></tr>\n};
	}
	
	print qq{</table>\n};
	
    } # end of both tables;

    print qq{</body></html>\n};

    exit;

} # end of showStartPage



#---------------
sub showGroups {  # show homeroom/grade groups
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed year-month

    my $yrmo = $arr{yrmo};
    my ($y,$m) = split('-', $yrmo);

    print qq{<h3>$month[$m] $y</h3>\n};

    
    foreach my $table ( 'atp_academic', 'atp_attitude' ) {

	my $sth1 = $dbh->prepare("select grade,homeroom from studentall where studnum = ?");
	
	# get all students in this table for this month
	my (%grades, %homerooms);
	my $sth = $dbh->prepare("select studnum from $table where yrmo = ?");
	$sth->execute($yrmo);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	while ( my $studnum = $sth->fetchrow ) {
	    
	    $sth1->execute($studnum);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my ($gr,$hr) = $sth1->fetchrow;
	    
#	    print qq{GR:$gr HR:$hr<br>\n};
	    $grades{$gr}++;
	    $homerooms{$hr}++
	    
	}

#	print qq{GRADES:}, %grades,"<br>\n";
	
	my ($dud,$tname) = split('_', $table); # split table name apart
	$tname = ucfirst($tname);

	foreach my $type ('grade', 'homeroom' ) {

	    my $temphead = ucfirst($type);
	    if ( $type eq 'grade' ) {
		$bgcolor = 'red';
	    } else { $bgcolor = 'blue'; }

	    print qq{<table cellpadding="3" cellspacing="0" border="1" };
	    print qq{style="margin:0.5em;float:left;">\n};
	    print qq{<caption style="font-weight:bold;">$tname</caption>\n};
	    print qq{<tr><th style="background-color:$bgcolor">$temphead</th><th>#Records</th></tr>\n};
	    $first = 0;


	    if ( $type eq 'grade' ) {
		# print the grade values
		foreach my $grade ( sort {$a <=> $b} keys %grades ) {
		    print qq{<tr><td>$grade</td><td>$grades{$grade}</td></tr>\n};
		}
		
	    } else { # homerooms
		
		foreach my $homeroom ( sort {$a <=> $b} keys %homerooms ) {
		    print qq{<tr><td>$homeroom</td><td>$homerooms{$homeroom}</td></tr>\n};
		}
	    }
	
	    print qq{</table>\n};
		
	}
	print qq{<div style="clear:left;"></div>\n};
    }
	
	
    print qq{</body></html>\n};

    exit;

} # end of showAccident
