#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Student' => 'Student',
	   'Student(s)' => 'Student(s)',
	   'Edit' => 'Edit',
	   'Add' => 'Add',
	   'Delete' => 'Delete',
	   'Category' => 'Category',
	   'New' => 'New',
	   'Description' => 'Description',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Contact Log' => 'Contact Log',
	   'Error' => 'Error',
	   'or' => 'or',
	   'Please Log In' => 'Please Log In',
	   'Save' => 'Save',
	   'Date' => 'Date',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Student Group' => 'Student Group',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Or' => 'Or',
	   'Last,First/Last/Initials/Studnum' => 'Last,First/Last/Initials/Studnum',
	   'Next Page' => 'Next Page',
	   'Check' => 'Check',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Mode' => 'Mode',
	   'Not Found' => 'Not Found',
	   'New' => 'New',
	   'No Record(s) Found' => 'No Record(s) Found',
	   'More' => 'More',
	   'Record(s)' => 'Record(s)',
	   'Deleted' => 'Deleted',

	   );

my $self = 'ctView.pl';

use DBI;
use CGI;


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get Current Date
my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
my $currdate = "$year-$month-$day";

my $userid = $ENV{'REMOTE_USER'};

# Get User Name
my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my ( $lastname, $firstname ) = $sth->fetchrow;


# Print Page Header
my $title = "View $lex{'Contact Log'}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};


print qq{$chartype\n</head><body>\n};

print qq{<div>[ <a href="$tchpage">$lex{Main}</a> ] $firstname $lastname</div>\n};
print qq{<h1>$lex{'Contact Log'}</h1>\n};

showMyContacts();


#-----------------
sub showMyContacts {
#-----------------

    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth2 = $dbh->prepare("select count(*) from studentwd where studnum = ?");
    
    my (%student,%sort,%studname);
    my $sth = $dbh->prepare("select * from contactlog where author = ?");
    $sth->execute($userid);
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	my $date = $r{date};
	my $id = $r{id};
	my $studnum = $r{studnum};
	
	# Get Student Name
	$sth1->execute( $r{studnum});
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ($ln,$fn) = $sth1->fetchrow;
	$studname{$r{studnum}} = qq{<b>$ln</b>, $fn};

	$sort{"$ln$fn$r{studnum}"} = $studnum;
	$student{$studnum}{$date}{$id} = $ref;
    }

    my $first = 1;
    foreach my $key ( sort keys %sort ) {
	my $studnum = $sort{$key};
	
	if ( $first ) {
	    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
	    print qq{<tr><th>Name</th><th>Action</th><th>Date</th>};
	    print qq{<th>Category</th><th>Description</th></tr>\n};
	    $first = 0;
	}

	# Loop over this students records by date;
	foreach my $date ( sort keys %{ $student{$studnum}} ) {
	    foreach my $id ( keys %{ $student{$studnum}{$date} } ) {
		my %r = %{ $student{$studnum}{$date}{$id} };
		print qq{<tr><td>$studname{$studnum}</td>};
		print qq{<td class="cn"><form action="./ctEdit.pl" method="post" target="_blank">\n};
		print qq{<input type="hidden" name="page" value="3">\n};
		print qq{<input type="hidden" name="$id" value="1">\n}; # pass record id as name
		print qq{<input type="submit" value="Edit"></form></td>\n};
		print qq{<td>$r{cdate}</td><td>$r{category}</td>};
		print qq{<td>$r{description}</td></tr>\n};
	    }
	}
    }

    if ( not $first ) {
	print qq{</table>\n};
    } else {
	print qq{<h3>No Records Found</h3>\n};
    }
    
    print qq{</body></html>\n};
    
    exit;

}
