#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# confTeacherPeriods.pl - configure the period times for each teacher
# for their homeroom. Stored in the periods filed in their staff
# record.


my %lex = ('Eoy' => 'Eoy',
	   'Periods' => 'Periods',
	   'Error' => 'Error',
	   'Set' => 'Set',
	   'Tracks' => 'Tracks',
	   'Number of' => 'Number of',
	   'Terms' => 'Terms',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Continue' => 'Continue',
	   'Grades' => 'Grades',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Term Block' => 'Term Block',
	   'Term' => 'Term',
	   'Start' => 'Start',
	   'End' => 'End',
	   'Default' => 'Default',
	   'Track' => 'Track',
	   'Main' => 'Main',
	   'Description' => 'Description',
	   'Map' => 'Map',
	   'Desc' => 'Desc',
	   'File' => 'File',
	   'Updated' => 'Updated',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Save' => 'Save',
	   'Illegal' => 'Illegal',
	   'later than' => 'later than',
	   'Date' => 'Date',
	   'Sequence' => 'Sequence',
	   'Duplicate' => 'Duplicate',
	   'Missing' => 'Missing',
	   'Outside' => 'Outside',

	   'Period' => 'Period',
	   'Times' => 'Times',
	   'Timetable' => 'Timetable',
	   'for' => 'for',
	   'Values' => 'Values',

	   'Starting Time' => 'Starting Time',
	   'Ending Time' => 'Ending Time',
	   'Grade' => 'Grade',
	   'Group' => 'Group',
	   'Update' => 'Update',
	   'Edit' => 'Edit',
	   'Add' => 'Add',
	   'New' => 'New',
	   'Delete' => 'Delete',
	   'Deleted' => 'Deleted',
	   'Record Updated' => 'Record Updated',
	   'Length' => 'Length',
	   
	   );

my $self = 'confTeacherPeriods.pl';

my $defaultEtcPath = '../../etc';

use DBI;
use CGI;
use Data::Dumper;
use Time::JulianDay;

$Data::Dumper::Purity = 1;
$Data::Dumper::Indent = 0;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

# Set Path to etc directory 
if ( not $g_EtcPath ) {
    $g_EtcPath = $defaultEtcPath;
}


my $q = CGI->new;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $userid = $ENV{REMOTE_USER};

# override the userid
#$userid = 'kristab';


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = qq{$lex{Set} Custom $lex{Period} $lex{Times} - for Your Homeroom};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};



if ( $arr{page} == 1 ) { # load jQuery libs for setPeriods

    print qq{<link rel="stylesheet" href="$g_JqueryUiCss">\n};
    
    print qq{<link rel="stylesheet" href="/js/jquery.ui.timepicker.css" type="text/css">\n};

    print qq{<script type="text/javascript" src="$g_jquery_url">};
    print qq{</script>\n};

    print qq{<script type="text/javascript" src="$g_jquery_ui_url">};
    print qq{</script>\n};

    print qq{<script type="text/javascript" src="/js/jquery.ui.timepicker.js">};
    print qq{</script>\n};

}

    
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | <a href="$eoypage">$lex{Eoy}</a> |\n};
print qq{<a href="$self">$lex{Start}</a> ]\n};

print qq{<h1>$title</h1>\n};


#foreach my $key ( keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    setPeriods();
    
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    writeRecords();
    
} elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    deletePeriods();
}


#----------------
sub deletePeriods {
#----------------

    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    exit;

    my $sth = $dbh->prepare("update staff set dbkperiods = NULL where userid = ?"); 
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
 
    print qq{<h3>Periods Removed</h3>\n};

    
    print qq{<h3>[ <a href="$self">$lex{Start}</a> ]</h3>\n};
    print qq{</body></html>\n};

    exit;
    
} # end of deletePeriods



#----------------
sub showStartPage {
#----------------

    # Load current periods values, if any.
    # load staff record for this user and get periods field, then eval it.
    my $sth = $dbh->prepare("select dbkperiods from staff where userid = ?");
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $periods = $sth->fetchrow;
#    print "PERIODS:$periods<br>\n";
    
    eval $periods;
    if ( $@ ) {
	print $lex{Error}. " for Teacher Periods: $@<br>\n";
	exit;
    }

    
# Test Data    
#    foreach my $period ( sort keys %periods ) {
#	foreach my $key ( sort keys %{ $periods{$period} } ) {
#	    print "P:$period Time:$key - $periods{$period}{$key}<br>\n";
#	}
#    }

    if ($periods) { 
    
	print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em;">};
	print qq{<tr><th>$lex{Period}</th><th>$lex{Times}</th><th>$lex{Length}</th></tr>\n};

    
	foreach my $period ( sort keys %periods ) {
	    my %r = %{ $periods{$period} };
	    
	    my $stime = conv24to12( $r{s} ); # start = s
	    my $etime = conv24to12( $r{e} ); # end = e
	    
	    my ($shr,$smin) = split(':', $r{s} );
	    $smin = $shr * 60 + $smin;

	    my ($ehr,$emin) = split(':', $r{e} );
	    $emin = $ehr * 60 + $emin;

	    my $length = $emin - $smin;
	    
	    print qq{<tr><td class="cn">$period</td><td class="la">$stime - $etime</td>};
	    print qq{<td class="cn">$length</td></tr>\n};
	
	}

	print qq{</table>\n};
    
	# Edit these periods
	print qq{<form action="$self" method="post" style="margin:0 1em;">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="submit" value="$lex{Edit}"></form>\n};

	# Delete this Period Group
#	print qq{<form action="$self" method="post" style="display:inline;">\n};
#	print qq{<input type="hidden" name="page" value="3">\n};
#	print qq{<input type="hidden" name="id" value="$id">\n};
#	print qq{<input type="submit" value="$lex{Delete}"></form>\n};
	
	# print qq{<div style="clear:left;"></div>\n};

    } else {
	print qq{<h3 style="margin:1em;">No Period Times Defined</h3>\n};
    }
    
    
    # Update Period Numbers (larger/smaller);
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<table style="float:left;border:1px solid black;padding:0.4em;margin:1em;">\n};
    print qq{<tr><td>\n};
    print qq{<input type="submit" value="Set/Change Homeroom Periods">\n};
    print qq{$lex{Timetable} $lex{Periods}\n};
    print qq{<select name="newperiods"><option value=""></option>\n};
    foreach my $per (1..15) {
	print qq{<option>$per</option>\n};
    }

    print qq{\n</select> (More/Less)</td></tr></table></form>\n};
    print qq{</body></html>\n};

    exit;

} # end of showStartPage



#-------------
sub setPeriods {
#-------------

    # print qq{<div>Set Periods</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $newperiods = $arr{newperiods};
    delete $arr{newperiods};
    
    
    # load staff record for this user and get periods field, then eval it.
    my $sth = $dbh->prepare("select dbkperiods from staff where userid = ?");
    $sth->execute( $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $periods = $sth->fetchrow;
#    print "PERIODS:$periods<br>\n";
    
    eval $periods;
    if ( $@ ) {
	print $lex{Error}. " for Teacher Periods: $@<br>\n";
	exit;
    }

#    foreach my $period ( sort keys %r ) {
#	print qq{Per:$period S:$r{$period}{s} E:$r{$period}{e}<br>\n};
#    }

    # Convert to 12 hour clock.
    foreach my $period ( sort keys %periods ) {
	$periods{$period}{s} = conv24to12( $periods{$period}{s} );
	$periods{$period}{e} = conv24to12( $periods{$period}{e} );
    }

    if ( $periods < 0 or $periods > 15 ) {
	print qq{<h3>$lex{Error} - $lex{Periods}:$periods</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    # Form / Table Start
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n}; # to write 

    
    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em;">\n};
    print qq{<tr><th>$lex{Period}</th><th>$lex{'Starting Time'}</th>};
    print qq{<th>$lex{'Ending Time'}</th></tr>\n}; 

    my $maxperiods = keys %periods;
    if ( $maxperiods != $newperiods and $newperiods ) {
	$maxperiods = $newperiods;
    }

#    foreach my $period ( sort keys %periods ) {
    foreach my $period ( 1..$maxperiods ) {
	my %r = %{ $periods{$period} };
	# print "R:", %r, "<br>\n";
	
	print qq{<tr><td class="bcn">$lex{Period} $period</td>\n};
	print qq{<td class="la"><input type="text" size="8" id="S$period" name="s:$period" value="$r{s}" };
	print qq{value="$r{$period}{'s'}">\n};
	print qq{<script type="text/javascript">
	    \$(document).ready(function() {
		\$('#S$period').timepicker({showPeriod:true, onHourShow:OnHourShowCallback});
	    });
	    function OnHourShowCallback(hour) {
               if ((hour > 17 ) || (hour < 7 )) {
                   return false;
               }
               return true;
	    }
        </script></td>\n};

    	print qq{<td class="la"><input type="text" size="8" id="E$period" name="e:$period" value="$r{e}"};
	print qq{value="$r{$period}{'e'}">\n};
	print qq{<script type="text/javascript">
	    \$(document).ready(function() {
		\$('#E$period').timepicker({showPeriod:true, onHourShow:OnHourShowCallback});
	    });
	    function OnHourShowCallback(hour) {
               if ((hour > 17 ) || (hour < 7 )) {
                   return false;
               }
               return true;
	    }
        </script></td>\n};
	print qq{</tr>\n};

    }


    print qq{<tr><td colspan="3" class="la">};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table></form>\n};

    print qq{</body></html>\n};

    
    exit;

}


#---------------
sub writeRecords {
#---------------

    # print qq{Write:<br>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }


    my (%periods,%check);
    foreach my $key ( keys %arr ) {

	my $time = conv12to24( $arr{$key} );
	my ($type, $per) = split(':', $key);  # type is start 's' or end 'e'.
	$periods{$per}{$type} = $time;
#	print qq{Time:$time<br>\n};
	
	my ($h,$m) = split(':', $time);
	my $minutes = $h * 60 + $m;
	if ( not $minutes ) { next; } # not checking blanks.
	my $idx = $per;
	if ( $type eq 'e' ) { # add on .5
	    $idx += 0.5;
	}
	$check{$idx} = $minutes; # these will be total minutes from start of the day.
    }

    
=head    
    # Display values for periods
    foreach my $period ( sort keys %periods ) {
	foreach my $type ( sort keys %{ $periods{$period} } ) {
	    print qq{Period:$period Type:$type Val:$periods{$period}{$type}<br>\n};
	}
    }
=cut

    
    # Check values for length, sequence, and overlap.
    my ($curr, $prev);
    foreach my $key ( sort {$a <=> $b} keys %check ) {
	$prev = $curr;
	$curr = $key;

	if ( $prev ) { # not at first;
	    if ( $check{$curr} < $check{$prev}  ) { # error;
		my ($currerr, $preverr );
		$currerr = "Start";
		if ( $curr =~ m/\./ ) { # is it a decimal value, if so, an end time
		    $currerr = "End";
		    $curr =~ s/\..+//g;
		}
		$currerr = "Period $curr ". $currerr;

		$preverr = "Start";
		if ( $prev =~ m/\./ ) { # is it a decimal value, if so, an end time
		    $preverr = "End";
		    $prev =~ s/\..+//g;
		}
		$preverr = "Period $prev ". $preverr;

		print qq{<h3>$lex{Error}: $currerr < $preverr</h3>\n};
		print qq{</body></html>\n};
		exit;
	    }
	}
	
#	print qq{K:$key V:$check{$key}<br>\n};
    }

    # Now get period lengths.
    my %lengths; # of periods in minutes.
    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em;">};
    print qq{<tr><th>$lex{Period}</th><th>$lex{Times}</th><th>$lex{Length}</th></tr>\n};

    foreach my $period ( sort {$a <=> $b} keys %periods ) {
	my ($shr,$smin) = split(':', $periods{$period}{'s'} );
	$smin = $shr * 60 + $smin;

	my ($ehr,$emin) = split(':', $periods{$period}{'e'} );
	$emin = $ehr * 60 + $emin;

	my $length = $emin - $smin;
	$lengths{$period} = $length;

	if ( not $length ) { next; }
	
	print qq{<tr><td class="cn">$period</td>};
	print qq{<td class="la">$periods{$period}{s} - $periods{$period}{e}</td>};
	print qq{<td class="cn">$length</td></tr>\n};
    }
    
    print qq{</table>\n};

    # we now have %periods{ period }{s or e} = val;
    

    my $PeriodTimeEnc = setScalar('*periods', \%periods);
#    print qq{PeriodTime: $PeriodTimeEnc<br>\n};

   
    # Save the records into staff table dbkperiods field for this user;
    my $sth = $dbh->prepare("update staff set dbkperiods = ? where userid = ?");
    $sth->execute( $PeriodTimeEnc, $userid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>Period Times Stored</h3>\n};

    print qq{<h3>[ <a href="$self">$lex{Start}</a> ]</h3>\n};
    
    print qq{</body></html>\n};

    exit;
}


#------------
sub setScalar {
#------------

    my ($dataname, $datavalue) = @_;

    my $name_ref = [ ];
    my $value_ref = [ ];
    push @$name_ref, $dataname;
    push @$value_ref, $datavalue;
    my $d = Data::Dumper->new( $value_ref, $name_ref );
    return $d->Dump;

}


#-------------
sub conv12to24 {
#-------------

    my $time = shift;
    if ( not $time ) { return }

    $time =~ s/(AM|PM|am|pm|\s+)//g; # strip am/pm or spaces
    # $ampm = $1; 
    # $ampm = uc $ampm; # uppercase value
#    print "12to24: $time<br>\n";
    
    # we don't care if it's got AM/PM values. We will go with hour
    # values. If It is 12 or greater it is PM othersie it's an AM
    # value. If < 7 we just add on 12. This will only work from 7am
    # on. Should be safe.
    
    my ($hr, $min) = split(':', $time);
    #    if ( $ampm eq 'PM' and $hr < 12 ) {
    if ( $hr < 7 ) { # ie. 1 to 6
	$hr += 12;
    }

    if ( $hr > 24 or $hr < 0  or  $min < 0 or $min > 60 ) {
	print qq{<h3>$lex{Error}: $time</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    return qq{$hr:$min};

}



#-------------
sub conv24to12 {
#-------------

    my $time = shift;
    if ( not $time ) { return }
    $time =~ s/\s+|am|pm|AM|PM//; # just in case.
    my ($hr, $min) = split(':', $time);
    my $ampm = 'AM';
    if ( $hr == 12 ) { $ampm = 'PM'; }
    if ( $hr == 0 ) { $hr = 12; };

    if ( $hr > 12 ) { 
	$hr -= 12;
	$ampm = 'PM';
    }

    return qq{$hr:$min $ampm};

}

