#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Daybook Viewer - View Daybook Entries by Date and/or Subject.

my %lex = ('Main' => 'Main',
	   'View Daybook' => 'View Daybook',
	   'Id' => 'Id',
	   'UserId' => 'UserId',
	   'Date' => 'Date',
	   'Subjsec' => 'Subjsec',
	   'Per' => 'Per',
	   'Topic' => 'Topic',
	   'Note' => 'Note',
	   'Hwrk' => 'Hwrk',
	   'HwDate' => 'HwDate',
	   'Category' => 'Category',
	   'No Records Found' => 'No Records Found',
	   'Delete' => 'Delete',
	   'View' => 'View',
	   'Error' => 'Error',

	   );

my $self = 'dayview.pl';

use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

my $title = $lex{'View Daybook'};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$tchcss" type="text/css">
$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{$lex{Date} <input type="text" size="10" name="date" value="$arr{date}">\n};
print qq{<input type="submit" value="$lex{'View'}">\n};
print qq{</form></body></html>\n};

if ( $arr{deleteflag} ) {
    delete $arr{deleteflag};
    deleteRecords();
}

print qq{<h1>$lex{Date}</b> $arr{date}</h1>\n};

my $sth = $dbh->prepare("select * from dbkdata where date = ? order by period");
$sth->execute( $arr{date} );
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

my $sth1 = $dbh->prepare("select description from subject where subjsec = ?");

$rows = $sth->rows;
if ($rows < 1){
    print qq{<h1>$header</h1>\n};
    print qq{<b>$lex{'No Records Found'}</b></body></html>\n};
    exit;
}

print qq{<h1>$title</h1>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="deleteflag" value="1">\n};
print qq{<input type="hidden" name="date" value="$arr{date}">\n};

print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
print qq{<caption>$header</caption>\n};
print qq{<tr><th>$lex{Id}</th><th>$lex{UserId}</th>\n};
print qq{<th>$lex{Subjsec}</th><th>$lex{Per}</th><th>$lex{Topic}</th><th>$lex{Note}</th>\n};
print qq{<th>$lex{Category}</th><th>$lex{Delete}</th></tr>\n};

while (my ($id, $userid, $date, $subjsec, $period, $topic, $notes, $hwrk, $hwdate, $category) = $sth->fetchrow){

    $sth1->execute($subjsec);
    my $description = $sth1->fetchrow;

    print qq{<tr><td>$id</td><td>$userid</td><td>$description ($subjsec)</td><td>$period</td><td>$topic</td>\n};
    print qq{<td>$notes</td>};
    print qq{<td>$category</td><td><input type="checkbox" name="$id" value="1"></td></tr>\n};

}

print qq{</table>\n};
print qq{<input type="submit" value="$lex{Delete}">\n};
print qq{</form>\n};

print qq{</body></html>\n};


#----------------
sub deleteRecords {
#----------------

    my $sth = $dbh->prepare("delete from dbkdata where id = ?");

    foreach my $key ( keys %arr) {

	if ($key eq $arr{date} ) { next; } # skip date field;

	#print qq{K:$key V:$arr{$key}<br>\n};
	$sth->execute($key);
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    }


}
