#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Discipline Records' => 'Discipline Records',
	   'View' => 'View',
	   'Main' => 'Main',
	   'Discipline' => 'Discipline',
	   'Description' => 'Description',
	   'Action' => 'Action',
	   'Error' => 'Error',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Continue' => 'Continue',
	   'Show Withdrawn' => 'Show Withdrawn',
	   'Select by' => 'Select by',
	   'Student' => 'Student',
	   'Count' => 'Count',
	   'OR' => 'OR',
	   'Author' => 'Author',
	   'Date' => 'Date',
	   'Not Found' => 'Not Found',
	   'Students' => 'Students',
	   'Location' => 'Location',
	   'Infraction' => 'Infraction',
	   'Comment' => 'Comment',
	   'Edit' => 'Edit',
	   'Time' => 'Time',
	   'Event' => 'Event',
	   'or' => 'or',
	   'Update' => 'Update',
	   'Yes' => 'Yes',
	   'Delete' => 'Delete',
	   'Deleted' => 'Deleted',
	   'Actions' => 'Actions',
	   'Add' => 'Add',
	   'Last,First/Last/Initials/Studnum' => 'Last,First/Last/Initials/Studnum',
	   'Search' => 'Search for Student',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Select' => 'Select',
	   'Save' => 'Save',
	   'Comments' => 'Comments',
	   'Current' => 'Current',
	   
	  );

use DBI;
use CGI;
use Cwd;

my $self = 'discView.pl';

# Get current dir so know what path for config files.
my $configpath;
my $teachermode;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $teachermode = 1;
    $configpath = '..'; # go back one to get to etc.
} else {
    $configpath = '../..'; # go back two to get to etc.
}

# only load passwords and users
eval require "$configpath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Load Configuration Variables;
#my $sth = $dbh->prepare("select id, datavalue from conf_system where filename = 'admin'");
#$sth->execute;
#if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
#while (	my ($id, $datavalue) = $sth->fetchrow ) {
#    eval $datavalue;
#    if ( $@ ) {
#	print "$lex{Error}: $@<br>\n";
#	die "$lex{Error}: $@\n";
#    }
#}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


# Teachermode
if ( $teachermode ) { # running on teacher site
    $css = $tchcss;
    $homepage = $tchpage;
    $downloaddir = $tchdownloaddir;
    $webdownloaddir = $tchwebdownloaddir;
}

# Get userid and user name
my $userid = $ENV{'REMOTE_USER'};
my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
$sth->execute( $userid );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ($ln,$fn) = $sth->fetchrow;
if ( not $ln) { $ln = $userid; }
my $username = qq{$fn $ln};


my $title = qq{$lex{View} $lex{'Discipline Records'}};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( $arr{page} == 2 ) { # show records script.

    my $path = '..';
    if ( $teachermode ) {
	$path = '.';
    }
    
    print qq{<script type="text/javascript">\n};
    print "function showstudent(studnum) { \n";
    print " winName=window.open(\"$path/studview.pl?student=\" + studnum + \"&page=1\",\n";
    print "'View Student','height=500,width=600,screenX=100,screenY=100,scrollbars=yes');";
    print " winName.focus(); }\n";
    print "</script>\n";

}



if ( $arr{page} == 3 or $arr{page} == 7) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> \n};
if ( not $teachermode ) {
    print qq{| <a href="$discpage">$lex{Discipline}</a> \n};
}
print qq{ ] $username\n<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1) {
    delete $arr{page};
    selectStudents();

} elsif ( $arr{page} == 2) {
    delete $arr{page};
    showRecords();

    
} elsif ( $arr{page} == 3) {
    delete $arr{page};
    editEvent();
    
} elsif ( $arr{page} == 4) {
    delete $arr{page};
    updateEvent();

    
} elsif ( $arr{page} == 5) {
    delete $arr{page};
    confirmDeleteEvent();
    
} elsif ( $arr{page} == 6) {
    delete $arr{page};
    deleteEvent();

# Add Action    
} elsif ( $arr{page} == 7) {
    delete $arr{page};
    addActionForm();
    
} elsif ( $arr{page} == 8) {
    delete $arr{page};
    addActionWrite();

# Add Student    
} elsif ( $arr{page} == 9) {
    delete $arr{page};
    addStudentForm();
    
} elsif ( $arr{page} == 10) {
    delete $arr{page};
    addStudentSelect();
    
} elsif ( $arr{page} == 11) {
    delete $arr{page};
    addStudentWrite();


# Delete Student
} elsif ( $arr{page} == 12) {
    delete $arr{page};
    deleteStudentSelect();
    
} elsif ( $arr{page} == 13) {
    delete $arr{page};
    deleteStudentWrite();

# Edit Student Comment
} elsif ( $arr{page} == 14) {
    delete $arr{page};
    editStudentComment();
    
} elsif ( $arr{page} == 15) {
    delete $arr{page};
    updateStudentComment();

# Delete Student Comment
} elsif ( $arr{page} == 16) {
    delete $arr{page};
    deleteCommentSelect();
    
} elsif ( $arr{page} == 17) {
    delete $arr{page};
    deleteStudentComment();


# Delete Actions
} elsif ( $arr{page} == 18) {
    delete $arr{page};
    deleteActionSelect();
    
} elsif ( $arr{page} == 19) {
    delete $arr{page};
    deleteAction();
}



#---------------------
sub deleteStudentWrite {
#---------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # delete student and any actions in this event
    # passed eventid and student

    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Load student name
    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

        
    print qq{<h3>$lex{Delete} $lex{Student} & $lex{Actions} - $firstname $lastname</h3>\n};
    print qq{<p style="width:60ch;"><b>$r{infraction}</b><br>\n$r{description}</p>\n};

    
    # Delete the actions for this student for this event;
    my $sth = $dbh->prepare("delete from disc_action where studnum = ? and eventid = ?");
    $sth->execute( $arr{studnum}, $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    
    #  Delete the Ident record
    $sth = $dbh->prepare("delete from disc_ident where studnum = ? and eventid = ?");
    $sth->execute( $arr{studnum}, $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<p style="font-weight:bold;">$lex{Student} & $lex{Actions} $lex{Deleted}</p>\n};

    
    print qq{<form action="$self" method="post" style="display:inline;"> \n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    print qq{<input type="submit" value="$lex{View} $lex{Event}"></form>\n};

    print qq{<form action="$self" method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="$lex{Select} $lex{Students}"></form>\n};

    
    print qq{</body></html>\n};
    
    exit;
    
} # end of deleteStudentWrite



#----------------------
sub deleteStudentSelect {
#----------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid passed

    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %e = %$ref;

    print qq{<h3>Delete Student from this Event</h3>\n};
    
    print qq{<div><b>$lex{Infraction}:</b> $e{infraction}</div>\n};
    print qq{<div style="width:60ch;margin:1em 0;"><b>Description:</b> $e{description}</div>\n};

    
    $sth = $dbh->prepare("select studnum from disc_ident where eventid = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    $sth1 = $dbh->prepare("select lastname, firstname, grade, homeroom from studentall 
			  where studnum = ?");

    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="13">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

        
    my $first = 1;
    while ( my $studnum = $sth->fetchrow ) {

	# Get Student Name, grade, homeroom
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %r = %$ref;

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em;">\n};
	    print qq{<tr><th>$lex{Select} $lex{Student}</th><th>$lex{Grade}</th>};
	    print qq{<th>$lex{Homeroom}</th></tr>\n};
	    $first = 0;
	}
	
	print qq{<tr><td><input type="radio" name="studnum" value="$studnum">};
	print qq{<b>$r{lastname}</b>, $r{firstname}</td>};
	print qq{<td>$r{grade}</td><td>$r{homeroom}</td></tr>\n};

    }

    if ( $first ) {
	print qq{<p><b>$lex{Error}:$lex{'No Student(s) Found'}</b></p>\n};
	print qq{</body></html>\n};
	exit;

    } 

    print qq{</table><p></p>\n};

    
    # Submit
    print qq{<tr><td></td><td><input type="submit" value="$lex{Delete} $lex{Student}"></td></tr>\n};

    
    print qq{</table>\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

} # end of deleteStudentSelect



#------------------
sub addStudentWrite {
#------------------

    # Add a new ident and action record for this student
    
#    print qq{<div>addStudentWrite</div>\n};
#    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    
    # find passed actions to add, have a comma separated leading 'A';
    my @actions;
    foreach my $key ( keys %arr ) {
	my ($idx,$action) = split(':', $key);
	if ( $idx eq 'A' ) {
	    push @actions, $action;
	}
    }
    # we can leave this actions in the hash.

    
    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Load student name
    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

    
    print qq{<h3>$lex{Add} $lex{Student} & $lex{Actions} - $firstname $lastname</h3>\n};

    print qq{<p style="width:60ch;"><b>$r{infraction}</b><br>\n$r{description}</p>\n};

    # Insert the Ident key
    my $sth = $dbh->prepare("insert into disc_ident (studnum, eventid, private, demerit) 
			    values(?,?,?,?)");

    $sth->execute( $arr{studnum}, $arr{eventid}, $arr{private}, $arr{demerit} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    
    # Insert the actions; NOTE using same event date
    my $sth = $dbh->prepare("insert into disc_action (eventid, studnum, action, date)
			    values(?,?,?,?)");

    foreach my $action ( @actions ) {
	$sth->execute( $arr{eventid}, $arr{studnum}, $action, $r{date} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }

    my $actions = join(', ',@actions);
    
    print qq{<p><b>$lex{Student} & $lex{Actions} Added:</b> $actions</p>\n};
    
    print qq{<form action="$self" method="post" style="display:inline;"> \n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    print qq{<input type="submit" value="$lex{View} $lex{Event}"></form>\n};

    print qq{<form action="$self" method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="$lex{Select} $lex{Students}"></form>\n};

    
    print qq{</body></html>\n};
    
    exit;
    
}


#-------------------
sub addStudentSelect {
#-------------------

    # print qq{addStudentSelect<br>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid, student passed

    print qq{<h3>Add Student to this Event</h3>\n};

    my $student = $arr{student};

    my $fields = 'lastname, firstname, studnum, grade, homeroom';
    my $sth;

    # Setup the Search
    if ($student =~ /\d+/) {  # we have a student number
	$sth = $dbh->prepare("select $fields from student where studnum = ?");
	$sth->execute( $student );

    } else { # we have words hopefully with a comma

	my ( $lastname,$firstname ) = split(',', $student);
	$firstname =~ s/^\s*//;
	$lastname =~ s/^\s*//;
	if ( $lastname and $firstname ){ # both entered.
	    $sth = $dbh->prepare("select $fields from student 
               where lastname = ? and firstname = ?");
	    $sth->execute( $lastname, $firstname );

	} elsif ( $lastname and not $firstname ){ # only lastname (no comma)

	    if ( length($lastname) == 2 ){ # search by initials: fi, li.
		my $fi = substr($lastname,0,1). '%'; 
		my $li = substr($lastname,1,1). '%';
		$sth = $dbh->prepare("select $fields from student 
                  where lastname $sql{like} ? and firstname $sql{like} ?");
		$sth->execute( $li, $fi );

	    } else {
		$sth = $dbh->prepare("select $fields from student 
                 where lastname = ? order by firstname");
		$sth->execute( $lastname );
	    }
	} else { # print an error....
	    print qq{<p><b>$lex{Error}:$lex{'No Student(s) Found'}</b></p>\n};
	    print qq{</body></html>\n};
	    exit; 
	}

    } # Last Else

    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="11">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

    
    my $first = 1;
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<tr><th>$lex{Select} $lex{Student}</th><th>$lex{Grade}</th>};
	    print qq{<th>$lex{Homeroom}</th></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td><input type="radio" name="studnum" value="$r{studnum}">};
	print qq{<b>$r{lastname}</b>, $r{firstname}</td>};
	print qq{<td>$r{grade}</td><td>$r{homeroom}</td></tr>\n};

    }

    if ( $first ) {
	print qq{<p><b>$lex{Error}:$lex{'No Student(s) Found'}</b></p>\n};
	print qq{</body></html>\n};
	exit;
	
    } 

    print qq{</table><p></p>\n};


    # We have selected students to add.
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};


    
    # Rest of actions, etc. here.
    # Actions
    print qq{<tr><td class="bra">$lex{Actions}</td>};
    print qq{<td>};
    my $dcount = 1;
    foreach my $act ( sort @g_DiscAction ) {
	my $localchecked;
	if ( $actions{$act} ) { $localchecked = qq{checked="checked"}; }
	print qq{<input type="checkbox" name="A:$act" value="1" $localchecked>$act };
	if ( $dcount % 5 == 0 ) { print qq{</td></tr>\n<tr><td></td><td>}; }
	$dcount++;
    }
    print qq{</td></tr>\n};


    # Demerit
    print qq{<tr><td class="bra">Demerit</td>\n};
    print qq{<td><input type="text" style="width:4ch;" name="demerit"></td></tr>\n};

    # Private
    print qq{<tr><td class="bra">Private (to Admin)</td>\n};
    print qq{<td><input type="checkbox" name="private" value="Y"></td></tr>\n};

    # Submit
    print qq{<tr><td></td><td><input type="submit" value="$lex{Save}"></td></tr>\n};

    
    print qq{</table>\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

} # Add Student Select



#-----------------
sub addStudentForm {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid only passed
    
    print qq{<h3>Add Student to this Event</h3>\n};
    
    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="10">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

    # print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    print qq{<input type="text" name="student" size="30">\n};
    print qq{<input type="submit" value="$lex{Search}">};
    print qq{<div style="font-size:120%;font-weight:bold;">};
    print qq{$lex{'Last,First/Last/Initials/Studnum'}</div>\n};
    print qq{</form>\n};
    
    print qq{</body></html>\n};
    
    exit;

}
    



#----------------
sub addActionWrite {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid, studnum, plus comment date, and any actions (more than 1)  passed
    
    # find passed actions to add
    my @actions;
    foreach my $key ( keys %arr ) {
	my ($idx,$action) = split(':', $key);
	if ( $idx eq 'A' ) {
	    push @actions, $action;
	}
    }
    
    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Load student name
    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

    
    print qq{<h3>$lex{Add} $lex{Discipline} $lex{Actions} - $firstname $lastname</h3>\n};

    print qq{<p style="width:60ch;"><b>$r{infraction}</b><br>\n$r{description}</p>\n};

    # Insert the actions
    my $sth = $dbh->prepare("insert into disc_action (eventid, studnum, action, date)
       values(?,?,?,?)");

    foreach my $action ( @actions ) {
	$sth->execute( $arr{eventid}, $arr{studnum}, $action, $arr{date} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }

    print qq{<h3>$lex{Actions} Added:}, @actions, qq{</h3>\n};

    # Link back to this event.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

    print qq{<input type="submit" value="$lex{View} $lex{Student} Event">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};
    
    exit;
    
}


#----------------
sub addActionForm {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid, studnum passed
    
    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Load student name
    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

    print qq{<h3>$lex{Add} $lex{Discipline} $lex{Actions} - $firstname $lastname</h3>\n};

    print qq{<p style="width:60ch;"><b>$r{infraction}</b><br>\n$r{description}</p>\n};
    
    
    # Load any current student actions
    my $sth = $dbh->prepare("select * from disc_action where eventid = ? and studnum = ?");
    $sth->execute( $arr{eventid}, $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    
    my $first = 1;
    while ( my $sref = $sth->fetchrow_hashref ) {
	my %r = %$sref;

	if ( $first ) { # add table heading.
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<tr><th>$lex{Action}</th><th>$lex{Date}</th></tr>\n};
	    print qq{<caption style="font-size:120%;font-weight:bold;">};
	    print qq{$lex{Current} $lex{Actions}</caption>\n};
	    $first = 0;
	}
	
	print qq{<tr><td>$r{action}</td><td>$r{date}</td></tr>\n};
	
    }

    if ( $first ) {
	print qq{<h3>No Actions Found</h3>\n};
	
    } else {
	print qq{</table><p></p>\n};
    }

    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="8">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    print qq{<input type="hidden" name="studnum" value="$arr{studnum}">\n};


    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};


    # Date
    print qq{<tr><td class="bra">$lex{Date}</td>\n};
    print qq{<td><input type="text" name="date" id="date" size="10" value="$r{date}">\n};
    print qq{<button type="reset" id="start_trigger">...</button> yyyy-mm-dd\n};
    print qq{</td></tr>\n};

   
    # Actions
    print qq{<tr><td class="bra">$lex{Actions}</td>};
    print qq{<td>};
    my $dcount = 1;
    foreach my $act ( sort @g_DiscAction ) {
	print qq{<input type="checkbox" name="A:$act" value="1">$act \n};
	if ( $dcount % 5 == 0 ) { print qq{</td></tr>\n<tr><td></td><td>}; }
	$dcount++;
    }
    print qq{</td></tr>\n};

    print qq{<tr><td colspan="2" class="la">\n};
    print qq{<input type="submit" value="$lex{Add} $lex{Actions}"></td></tr>\n};

    print qq{</table></form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "date", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    });
   </script>\n};

    print qq{</body></html>\n};

    exit;


} # end of addActionForm

    


#---------------------
sub confirmDeleteEvent {
#---------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid passed

    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Load any student records and their names.
    my %students;
    my $sth = $dbh->prepare("select d.studnum, s.lastname, s.firstname 
			    from disc_ident d, studentall s 
			    where s.studnum = d.studnum and eventid = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $sref = $sth->fetchrow_hashref ) {
	my %r = %$sref;
	$students{$r{studnum}} = "<b>$r{lastname}</b>, $r{firstname}";
    }

    
    print qq{<h3>$lex{Delete} $lex{'Discipline Records'}</h3>\n};
    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="6">\n};  # pass eventid to delete
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};  # pass eventid to delete

    
    # Start Table
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><td class="bra">$lex{Date}</td><td>$r{date}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Infraction}</td><td>$r{infraction}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Description}</td><td>$r{description}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Students}</td><td>};
    foreach my $studnum ( keys %students ) {
	print qq{$students{$studnum}<br>\n};
    }
    print qq{</td></tr>\n};
    
    print qq{<tr><td colspan="2" class="cn">\n};
    print qq{<input type="submit" value="$lex{Yes}, $lex{Delete} $lex{Infraction}"></td></tr>\n};

    print qq{</table></form>\n};

    print qq{</body></html>\n};

    exit;

}


#--------------
sub deleteEvent {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid passed

    
    # delete actions
    my $sth = $dbh->prepare("delete from disc_action where eventid = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    # delete ident (ie. students)
    my $sth = $dbh->prepare("delete from disc_ident where eventid = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    # delete comments
    my $sth = $dbh->prepare("delete from disc_comment where eventid = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


    # delete the event itself.
    my $sth = $dbh->prepare("delete from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    
    
    print qq{<h3>$lex{Delete} $lex{'Discipline Records'}</h3>\n};
    
    print qq{<h4>$lex{'Discipline Records'} $lex{Deleted}</h4>\n};

    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{View} $lex{'Discipline Records'}">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};
    
    exit;
    

} # end of deleteEvent



#-----------------
sub selectStudents {
#-----------------

    my $studenttable = 'student';
    if ( $arr{showwithdrawn} ) {
	$studenttable = 'studentall';
    }

    my $checked;
    if ( $arr{checkall} ) {
	$checked = qq{checked="checked"};
    }
    delete $arr{checkall};

    my $pagebreak;
    if ( $arr{pagebreak} ) {
	$pagebreak = $arr{pagebreak};
    }
    delete $arr{pagebreak};
    
    
    my $skipblanks = $arr{skipblanks};
    delete $arr{skipblanks};

    
    my ($select, $selectval, $groupname);
    if ( $arr{grade} ) {
	$select = "where grade = ?";
	$selectval = $arr{grade};
	$groupname = $lex{Grade};

    } elsif ( $arr{homeroom} ) {
	$select = "where homeroom = ?";
	$selectval = $arr{homeroom};
	$groupname = $lex{Homeroom};

    } else {
	print qq{<h3>All Students Selected</h3>\n};
    }


    print qq{<h3>$groupname $selectval</h3>\n};


    # Loop through all students in this grade/homeroom
    my $sth = $dbh->prepare("select lastname, firstname, studnum, grade from $studenttable
			    $select order by lastname, firstname");
    if ( $selectval ){
	$sth->execute( $selectval );
    } else {
	$sth->execute; # all students
    }
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    
    # Check for discipline events
    my $sth1 = $dbh->prepare("select count(*) from disc_ident where studnum = ?");

    # Check for Withdrawn
    my $sth2 = $dbh->prepare("select count(*) from studentwd where studnum = ?");

    my $first = 1;

    # Student Loop
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

	
	# Check for discipline records
	$sth1->execute( $r{studnum} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $disccount = $sth1->fetchrow;
	if ( not $disccount and $skipblanks ) { next; }

	
	if ( $first ) {
	    # Start Form
	    print qq{<form action="$self" method="post">\n};
	    print qq{<input type="hidden" name="page" value="2">\n};
	    if ( $pagebreak ) {
		print qq{<input type="hidden" name="pagebreak" value="1">\n};
	    }
	    
	    print qq{<div style="margin:0 1em;"><input type="submit" value="$lex{Continue}"></div>\n};

	    # Start Table
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<caption style="color:red;">Red = Withdrawn</caption>\n};
	    print qq{<tr><th></th><th>$lex{Student}</th><th>Grade</th>};
	    print qq{<th>$lex{Discipline}<br>$lex{Count}</th></tr>\n};

	    $first = 0;
	}

	
	my $wd;
	if ( $arr{showwithdrawn} ) { # check if withdrawn
	    $sth2->execute( $r{studnum} );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    $wd = $sth2->fetchrow;
	}


	print qq{<tr>};
	if ( $disccount ) { 
	    print qq{<td><input type="checkbox" name="$r{studnum}" value="1" $checked></td>\n}; 
	} else { 
	    print qq{<td></td>\n}; 
	}

	my $name;
	if ( $wd ) {
	    $name = qq{<span style="color:red;"><b>$r{lastname}</b>, $r{firstname}</span>};
	} else {
	    $name = qq{<b>$r{lastname}</b>, $r{firstname}};
	}


	print qq{<td>$name ($r{studnum})</td><td class="cn">$r{grade}</td>};
	print qq{<td class="cn">$disccount</td></tr>\n};
			   
    }


    if ( $first ) { # no Students
	print qq{<h3>$lex{Students} $lex{'Not Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }
    

    print qq{</table>\n};
    print qq{<div style="margin:1em;"><input type="submit" value="$lex{Continue}"></div>\n};

    print qq{</form></body></html>\n};

    exit;

}


#----------------
sub showStartPage { # Entry Values for Custom Script
#----------------

    my (@homerooms, @grades, @schoolyears );
    # Get Homerooms
    my $sth = $dbh->prepare("select distinct homeroom from student 
      where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $hr = $sth->fetchrow ) {
	push @homerooms, $hr;
    }
    @homerooms = sort {$a <=> $b} @homerooms;

    # Get Grades
    $sth = $dbh->prepare("select distinct grade from student 
      where grade is not NULL and grade != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};


    # Select Grade
    print qq{<tr><td class="bra">$lex{'Select by'} $lex{Grade}</td>};
    print qq{<td><select name="grade"><option></option>\n};
    foreach my $gr ( @grades ) {
	print qq{<option>$gr</option>\n};
    }
    print qq{</select> Both Blank=All</td></tr>\n};

    # OR
    print qq{<tr><td colspan="2" style="text-align:center;">$lex{OR}</td></tr>\n};


    # Select Homeroom
    print qq{<tr><td class="bra">$lex{'Select by'} $lex{Homeroom}</td>};
    print qq{<td><select name="homeroom"><option></option>\n};
    foreach my $hr ( @homerooms ) {
	print qq{<option>$hr</option>\n};
    }
    print qq{</select> Both Blank=All</td></tr>\n};

    # Check next page
    print qq{<tr><td class="bra">Check Next Page (Students)</td>};
    print qq{<td><input type="checkbox" name="checkall" value="1"></td></tr>\n};

    
    # Check next page
    print qq{<tr><td class="bra">Page Breaks between Students</td>};
    print qq{<td><input type="checkbox" name="pagebreak" value="1"></td></tr>\n};
    
    
    # Withdrawn
    print qq{<tr><td class="bra">$lex{'Show Withdrawn'}</td>};
    print qq{<td><input type="checkbox" name="showwithdrawn" value="1"></td></tr>\n};


    # Show Students without Discpline Records
    print qq{<tr><td class="bra">Skip Students without Records</td>};
    print qq{<td><input type="checkbox" name="skipblanks" value="1" checked="checked"></td></tr>\n};


    # Continue
    print qq{<tr><td class="ra"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    print qq{</form></body></html>\n};

    exit;

}



#--------------
sub showRecords {
#--------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed: just a list of student numbers.

    if ( $arr{eventid} ) { # called by other functions, get the students for this event
	my $sth = $dbh->prepare("select studnum from disc_ident where eventid = ?");
	$sth->execute( $arr{eventid} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $studnum = $sth->fetchrow ) {
	    $arr{$studnum} = 1;
	}
	delete $arr{eventid};
    }

    my $pagebreak;
    if ( $arr{pagebreak} ) {
	$pagebreak = 1;
    }
    delete $arr{pagebreak};
    
    
    my $sth = $dbh->prepare("select i.*,e.* from disc_ident i, disc_event e 
			    where studnum = ? and e.id = i.eventid
			    order by e.date desc");
    # get full student record
    my $sth1 = $dbh->prepare("select * from studentall where studnum = ?");

    # get staff name
    my $sth2 = $dbh->prepare("select lastname, firstname from staff where userid = ?");

    # get action for this student, event
    my $sth3 = $dbh->prepare("select * from disc_action where studnum  = ? and eventid = ?");
    
    # find other students with this event
    my $sth4 = $dbh->prepare("select studnum from disc_ident where eventid = ?");

    # get student names.
    my $sth5 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

    # Get all comments for this event.
    my $sth6 = $dbh->prepare("select * from disc_comment where eventid = ?");

    
    my @students = keys %arr;
    my $students = join(',',@students);  # string of studnums for passing to next sub
    

    foreach my $studnum ( sort keys %arr ) {

	# Get the Name
	$sth1->execute($studnum);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $studref = $sth1->fetchrow_hashref;
	my %s = %$studref;
	my ($lastname, $firstname) = ($s{lastname}, $s{firstname});

	print qq{<div style="font-weight:bold;font-size:150%;">};
	print qq{$firstname $lastname ($studnum)</div>\n};

	if ( $s{par1_lastname} ) { # put in contact information - first parent 
	    print qq{<div style="font-weight:bold;font-size:120%;margin-bottom:1em;display:inline;">};
	    print qq{Parent/Guardian $s{par1_firstname} $s{par1_lastname}\n};
	    my @contacts;
	    if ( $s{hphone1} ) { push @contacts, qq{H:$s{hphone1}}; }
	    if ( $s{wphone1} ) { push @contacts, qq{W:$s{wphone1}}; }
	    if ( $s{cell1} ) { push @contacts, qq{C:$s{cell1}}; }
	    my $contacts = join(', ',@contacts);
	    print qq{$contacts</div>\n};
	}

	if ( $s{par2_lastname} ) { # put in contact information for second parent
	    print qq{ / <div style="font-weight:bold;font-size:120%;margin-bottom:1em;};
	    print qq{display:inline;">};
	    print qq{Parent/Guardian $s{par2_firstname} $s{par2_lastname}\n};
	    my @contacts;
	    if ( $s{hphone2} ) { push @contacts, qq{H:$s{hphone1}}; }
	    if ( $s{wphone2} ) { push @contacts, qq{W:$s{wphone1}}; }
	    if ( $s{cell2} ) { push @contacts, qq{C:$s{cell1}}; }
	    my $contacts = join(', ',@contacts);
	    print qq{$contacts</div>\n};
	}
	
	print qq{<div style="display:inline;">};
	print qq{[ <a href="javascript:showstudent($studnum)">View Student Info</a> ]</div>\n};

	
	# Table Heading
	print qq{<table border="1" cellpadding="3" cellspacing="0" style="margin-bottom:1em;">\n};
	print qq{<tr><th>$lex{Infraction} - $lex{Description}</th>};
	print qq{<th>$lex{Edit} $lex{Comments}/Demerits</th>};
	print qq{<th>$lex{Students} / $lex{Actions}</th></tr>\n};

	
	# Get the Discipline Records for this student
	$sth->execute($studnum);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;

	    #foreach my $key ( sort keys %r ) { print qq{K:$key V:$r{$key}<br>\n}; }
	    # print "<br>\n";
	    
	    if ( $teachermode and $r{private} ) { next; } # skip any private recs in teachermode

	    # remove the seconds from time.
	    my $time;
	    if ( $r{time} ) {
		my @time = split(':', $r{time});
		$time = qq{$time[0]:$time[1]};
	    }

	    # get author name.
	    my $author;
	    $sth2->execute( $r{author} );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lname, $fname ) = $sth2->fetchrow;
	    $author = "$fname $lname";
	    if ( not $lname ) { $author = $r{author}; } # if withdrawn, just use userid
	    if ( not $author ) { $author = 'No Author'; }


	    # Infraction and Description of Event
	    print qq{<tr><td style="vertical-align:top;width:25%;">};
	    print qq{<span style="font-weight:bold;font-size:120%;">$r{infraction}</span><br>\n};
	    print qq{$r{date} $time };

	    if ( $r{location} ) {
		print qq{/ $r{location}\n};
	    }
	    # Demerit, Detention, Suspension values
	    print qq{<br>\n};
	    if ( $r{demerit} ) {
		print qq{Demerit:$r{demerit}\n};
	    }
	    if ( $r{detention} ) {
               print qq{/ Detention:$r{detention}\n};
	    }
	    if ( $r{suspension} ) {
               print qq{/ Suspension:$r{suspension}\n};
	    }
	    
	    print qq{<br>\n<b>$author</b> - $r{description}<br>\n};

	    print qq{<form action="$self" method="post" style="display:inline;">\n};
	    print qq{<input type="hidden" name="page" value="3">\n};
	    print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
	    print qq{<input type="hidden" name="students" value="$students">\n};
	    print qq{<input type="submit" value="$lex{Edit}"></form>\n};

	    if ( not $teachermode ) {
		print qq{<form action="$self" method="post" style="display:inline;">\n};
		print qq{<input type="hidden" name="page" value="5">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="submit" value="$lex{Delete}"></form>\n};
	    }

	    print qq{</td>\n};

	    
	    # Center Column: Student Comments from staff
	    print qq{<td style="vertical-align:top;width:25%;">};
	    print qq{<b>Reload page (F5) if you have edited/added comments</b><hr>\n};

	    # my $sth6  is "select * from disc_comment where eventid = ?";
	    $sth6->execute( $r{id} );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    while ( my $cref = $sth6->fetchrow_hashref ) { # comment from disc_comment table
		my %c = %$cref; # id, eventid, studnum, author,comment,private

		# get student name
		$sth5->execute( $c{studnum} );
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		my ($ln, $fn ) = $sth5->fetchrow;

		# get author name
		$sth2->execute( $c{author} );
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		my ($staffln, $stafffn ) = $sth2->fetchrow;
		if ( not $staffln ) { $staffln = $c{author}; }

		print qq{<div><b>$fn $ln</b> $c{comment} <b>$stafffn $staffln</b>\n};
	    		
		print qq{<form action="./discComment.pl" method="post" };
		print qq{style="display:inline;" target="_blank">\n};
		print qq{<input type="hidden" name="page" value="3">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="hidden" name="studnum" value="$c{studnum}">\n};
		print qq{<input type="hidden" name="id" value="$c{id}">\n};
		print qq{<input type="submit" value="$lex{Edit}, new tab"></form>\n};

		print qq{</div><hr>\n};
		
	    }

	    # Select Comments to Delete
	    if ( not $teachermode ) {
		print qq{<form action="$self" method="post" style="display:inline;">\n};
		print qq{<input type="hidden" name="page" value="16">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="submit" value="$lex{Delete} $lex{Comments}"></form>\n};
	    }
	    
	    print qq{</td>\n}; # end of center section


	    
	    # Right Column - All Students  (involved with this event)
	    my @allstudents;
	    $sth4->execute( $r{eventid} );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    
	    print qq{<td style="vertical-align:top;">\n};
	    
	    while ( my $snum = $sth4->fetchrow ) {

		# Get Student Name
		$sth5->execute( $snum );
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		my ($ln, $fn ) = $sth5->fetchrow;

		print qq{<b>$ln</b>, $fn - };
		
		# Loop through all actions for this student for this event
		$sth3->execute( $snum, $r{eventid} );
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		
		my $first = 1;
		while ( my $aref = $sth3->fetchrow_hashref ) {
		    my %a = %$aref;
		    print qq{ $a{action}<br>};
		    $first = 0;
		} # end of action loop
		if ( $first ) { print qq{<b>No Actions</b>\n}; }
		
		
		# button to Add Action
		print qq{<form action="$self" method="post" style="display:inline;">\n};
		print qq{<input type="hidden" name="page" value="7">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="hidden" name="studnum" value="$snum">\n};
		print qq{<input type="submit" value="$lex{Add} $lex{Action}"></form>\n};
			
		print qq{<hr>\n};
		
	    } # end of this student loop

	    # Select Actions to Delete
	    if ( not $teachermode ) {
		print qq{<form action="$self" method="post" style="display:inline;">\n};
		print qq{<input type="hidden" name="page" value="18">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="submit" value="$lex{Delete} $lex{Actions}"></form>\n};
	    }

	    
	    # button to Add a Student to this event
	    print qq{<form action="$self" method="post" style="display:inline;">\n};
	    print qq{<input type="hidden" name="page" value="9">\n};
	    print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
	    print qq{<input type="submit" value="$lex{Add} $lex{Student}"></form>\n};

	    # button to Delete a Student from this event
	    if ( not $teachermode ) {
		print qq{<form action="$self" method="post" style="display:inline;">\n};
		print qq{<input type="hidden" name="page" value="12">\n};
		print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
		print qq{<input type="submit" value="$lex{Delete} $lex{Student}"></form>\n};
	    }

	    
	    print qq{</td></tr>\n};
	}

	print qq{</table>\n};

	if ( $pagebreak ) {
	    print qq{<div style="page-break-after:always;"></div>\n};
	}

    } # end of all students loop

    print qq{</body></html>\n};

    exit;

}



#------------
sub editEvent {  # edit an event record.
#------------

    # print qq{<div>Edit Event</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    
    # eventid, students (comma separated)  passed.

    # load this discipline event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    if ( $teachermode ) { # check author
	if ( $r{author} ne $userid ) { # deny access
	    print qq{<h3>The author is userid $r{author}. You are userid $userid.<br><br>\n};
	    print qq{Edit not allowed.</h3>\n};
	    print qq{</body></html>\n};
	    exit;
	}
    }
   

    # Load the Staff.
    my (%staff, @staff);
    $sth = $dbh->prepare("select lastname, firstname, userid from staff order by lastname, firstname");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my ($ln,$fn,$uid) = $sth->fetchrow ) {
	$staff{$uid} = "$ln, $fn";
	push @staff, $uid;
    }

    # Load the locations
    my @locations;
    $sth = $dbh->prepare("select distinct location from disc_event order by location");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $loc = $sth->fetchrow ) {
	push @locations, $loc;
    }

         
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="4">\n};  # call updateEvent
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    print qq{<input type="hidden" name="students" value="$arr{students}">\n};
    
    
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    print qq{<tr><th style="text-align:right;">$lex{Event}</th><th></th></tr>\n};

    
    # Author
    print qq{<tr><td class="bra">$lex{Author}</td>\n};
    if ( $teachermode ) { # display only one teacher.
	print qq{<td><select><option>$r{author}</option>\n};
	
    } else {
	if ( not $staff{ $r{author} } ) { $staff{ $r{author} } = $r{author}; }
        print qq{<td><select name="author"><option value="$r{author}">$staff{$r{author}}</option>\n};
	foreach my $userid ( @staff ) {
	    print qq{<option value="$userid">$staff{$userid} ($userid)</option>\n};
	}
    }
    print qq{</select></td></tr>\n\n};

    
    # Date
    print qq{<tr><td class="bra">$lex{Date}</td>\n};
    print qq{<td><input type="text" name="date" id="date" size="10" value="$r{date}">\n};
    print qq{<button type="reset" id="start_trigger">...</button> yyyy-mm-dd\n};
    print qq{</td></tr>\n};

    # Time
    print qq{<tr><td class="bra">$lex{Time}</td>\n};
    print qq{<td><input type="text" name="time" size="10" value="$r{time}"> HH:MM:SS};
    print qq{</td></tr>\n\n};

    # Location
    print qq{<tr><td class="bra">$lex{Location}</td>\n};
    print qq{<td><select name="location"><option>$r{location}</option>\n};
    foreach my $loc ( @locations ) {
	print qq{<option>$loc</option>\n};
    }
    print qq{</select>\n};

    # New Location
    print qq{$lex{or} <input type="text" name="newlocation" size="14">};
    print qq{</td></tr>\n\n};

    
    # Infraction.  Now loaded from conf system
    print qq{<tr><td class="bra">$lex{Infraction}</td>\n};
    print qq{<td><select name="infraction"><option>$r{infraction}</option>\n};
    foreach my $inf ( sort keys %g_DiscInfraction ) {
	print qq{<option>$inf</option>\n};
    }
    print qq{</select></td></tr>\n\n};

  
    # Description
    print qq{<tr><td class="bra">$lex{Description}</td>\n};
    print qq{<td><textarea name="description" rows="7" cols="100">$r{description}</textarea>};
    print qq{</td></tr>\n\n};

    
    # Update
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Update}"></td></tr>\n};
    

    print qq{</table></form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "date", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    });
    </script>\n};

    print qq{</body></html>\n};

    exit;

    
} # end of editEvent;



#------------
sub updateEvent {  # update an event record.
#------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Extract Eventid
    my $eventid = $arr{eventid};
    delete $arr{eventid};
    
    # Location update
    if ( $arr{newlocation} ) {
	$arr{location} = $arr{newlocation};
    }
    
    delete $arr{newlocation};

    my @students = split(',',$arr{students});
    delete $arr{students};

    
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # now add the record update info.
    foreach my $field ( sort keys %arr ) { 
	my $sth = $dbh->prepare("update disc_event set $field = ? where id = $eventid");
	$sth->execute( $arr{$field} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }
   
    print qq{<h3>Record Updated</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    foreach my $studnum ( @students ) {
        print qq{<input type="hidden" name="$studnum" value="1">\n};
    }
    print qq{<input type="submit" value="$lex{View} $lex{Student}">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

    
} # end of updateEvent;



#---------------------
sub editStudentComment {  # edit a comment record.
#---------------------

    # print qq{Edit Student Comment<br>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # load this disc_ident record
    my $sth = $dbh->prepare("select * from disc_ident where eventid = ? and studnum = ?");
    $sth->execute( $arr{eventid}, $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

       
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="15">\n};  # call updateStudentComment
    print qq{<input type="hidden" name="id" value="$r{id}">\n};
    print qq{<input type="hidden" name="eventid" value="$r{eventid}">\n};
        
    print qq{<table cellpadding="3" cellspacing="0" border="0" };
    print qq{style="border:2px solid gray;padding:0.3em;">\n};
    print qq{<caption style="font-weight:bold;text-align:left;">};
    print qq{Update Student Comment / Demerit</caption>\n};

    # Demerit
    print qq{<tr><td class="bra">Demerit</td>\n};
    print qq{<td><input type="text" size="5" name="demerit" value="$r{demerit}"></td></tr>\n};

   
    # Comment
    print qq{<tr><td class="bra">Student Comment</td>\n};
    print qq{<td><textarea name="comment" rows="7" cols="100">$r{comment}</textarea>};
    print qq{</td></tr>\n\n};

    
    # Update
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Update}"></td></tr>\n};
    
    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

} # end of editStudentComment



#-----------------------
sub updateStudentComment {  # update student comment and demerit
#-----------------------

    # print qq{<div>Update Student Comment</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("update disc_ident set comment = ?, demerit = ? where id = ?");
    $sth->execute( $arr{comment}, $arr{demerit}, $arr{id} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
   
    print qq{<h3>Record Updated</h3>\n};
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    

    print qq{<input type="submit" value="$lex{View} $lex{Student}">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;
    
} # end of updateStudentComment (and Demerit).



#----------------------
sub deleteCommentSelect {
#----------------------

    # print qq{<div>deleteCommentSelect</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid passed

    # load event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %e = %$ref;

    print qq{<h3>Delete Comment</h3>\n};
    print qq{<div style="width:60ch;"><b>$lex{Infraction}</b>: $e{infraction}<br>};
    print qq{<b>Event Description</b>: $e{description}</div>\n};

    
    $sth = $dbh->prepare("select * from disc_comment where eventid = ?");

    $sth1 = $dbh->prepare("select lastname, firstname, grade, homeroom from studentall 
			  where studnum = ?");

    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="17">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    
        
    my $first = 1;

    $sth->execute( $arr{eventid} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    while ( my $cref = $sth->fetchrow_hashref ) {
	my %c = %$cref; # comment record
	my $studnum = $c{studnum};
	my $commentid = $c{id};
	
	# Get Student Name, grade, homeroom
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %r = %$ref;

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em 0">\n};
	    print qq{<tr><th>$lex{Select} $lex{Student}</th><th>$lex{Grade}</th>};
	    print qq{<th title="Homeroom">HRm</th><th>$lex{Student} $lex{Comment}</td></tr>\n};
	    $first = 0;
	}
	
	print qq{<tr><td><input type="radio" name="commentid" value="$commentid">};
	print qq{<b>$r{lastname}</b>, $r{firstname} ($studnum)</td>};
	print qq{<td class="cn">$r{grade}</td><td class="cn">$r{homeroom}</td>};
	print qq{<td class="la" style="width:60ch;">$c{comment}</td></tr>\n};

    }

    if ( $first ) {
	print qq{<p><b>$lex{Error}:$lex{'No Student(s) Found'}</b></p>\n};
	print qq{</body></html>\n};
	exit;

    } 

    print qq{</table><p></p>\n};

    
    # Submit to call deleteStudentComment
    print qq{<tr><td></td><td><input type="submit" value="$lex{Delete} $lex{Comment}"></td></tr>\n};

    
    print qq{</table>\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

} # end of deleteCommentSelect


#-----------------------
sub deleteStudentComment {  # delete student comment
#-----------------------

    # print qq{<div>delete Student Comment</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed commentid and eventid (for link to student events)

    my $sth = $dbh->prepare("delete from disc_comment where id = ?");
    $sth->execute( $arr{commentid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
   
    print qq{<h3>Comment Record Deleted</h3>\n};
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

    print qq{<input type="submit" value="$lex{View} $lex{Student} Events">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;
    
} # end of deleteStudentComment



#---------------------
sub deleteActionSelect {
#---------------------

    # print qq{<div>deleteActionSelect</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # eventid passed

    # load event;
    my $sth = $dbh->prepare("select * from disc_event where id = ?");
    $sth->execute( $arr{eventid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %e = %$ref;

    print qq{<h3>Delete Action</h3>\n};
    print qq{<div style="width:60ch;"><b>$lex{Infraction}: $e{infraction}</b><br>};
    print qq{$e{description}</div>\n};

    
    $sth = $dbh->prepare("select * from disc_action where eventid = ?");

    $sth1 = $dbh->prepare("select lastname, firstname, grade, homeroom from studentall 
			  where studnum = ?");

    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="19">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};
    
        
    my $first = 1;

    $sth->execute( $arr{eventid} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    while ( my $aref = $sth->fetchrow_hashref ) {
	my %a = %$aref; # comment record
	my $studnum = $a{studnum};
	my $actionid = $a{id};
	
	# Get Student Name, grade, homeroom
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %r = %$ref;

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:1em 0">\n};
	    print qq{<tr><th>$lex{Select} $lex{Student}</th><th>$lex{Grade}</th>};
	    print qq{<th>HRm</th><th>$lex{Action}</td></tr>\n};
	    $first = 0;
	}
	
	print qq{<tr><td><input type="radio" name="actionid" value="$actionid">};
	print qq{<b>$r{lastname}</b>, $r{firstname} ($studnum)</td>};
	print qq{<td class="cn">$r{grade}</td><td class="cn">$r{homeroom}</td>};
	print qq{<td class="la" style="width:60ch;">$a{action} ($a{date})</td></tr>\n};

    }

    if ( $first ) {
	print qq{<p><b>$lex{Error}:$lex{'No Student(s) Found'}</b></p>\n};
	print qq{</body></html>\n};
	exit;
    } 

    print qq{</table><p></p>\n};

    
    # Submit to call deleteStudentComment
    print qq{<tr><td></td><td><input type="submit" value="$lex{Delete} $lex{Action}"></td></tr>\n};

    
    print qq{</table>\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

} # end of deleteActionSelect


#---------------
sub deleteAction {  # delete action
#---------------

    # print qq{<div>Delete Action</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed actionid and eventid (for link to student events)

    my $sth = $dbh->prepare("delete from disc_action where id = ?");
    $sth->execute( $arr{actionid} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
   
    print qq{<h3>Action Record Deleted</h3>\n};
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="eventid" value="$arr{eventid}">\n};

    print qq{<input type="submit" value="$lex{View} $lex{Student} Events">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;
    
} # end of deleteAction

