#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Maintenance Menu' => 'Maintenance Menu',
	   'GB Main' => 'GB Main',
	   'Main' => 'Main',
	   'Error' => 'Error',
	   'Adjust Student Sort Order' => 'Adjust Student Sort Order',
	   'Delete/Compress Assessment Items' => 'Delete/Compress Assessment Items',
	   'Clone Assessment Items' => 'Clone Assessment Items',
	   'Export' => 'Export',

	   );

use CGI;

# required to load the css values.
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset );

my $title = $lex{'Maintenance Menu'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{$chartype\n</head><body style="padding: 1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> |
<a href="gbmain.pl">$lex{'GB Main'}</a> ]\n};

print qq{<h1>$title</h1>\n};

print qq{<ul>\n};

print qq{<li> <a href="sortorder.pl" };
print qq{title="Adjust the Student Sorting Order for this subject">\n};
print qq{$lex{'Adjust Student Sort Order'}</a></li>\n};

print qq{<li> <a href="compress.pl" };
print qq{title="Delete/Compress Assessment Items (and Scores)">\n};
print qq{$lex{'Delete/Compress Assessment Items'}</a></li>\n};

print qq{<li> <a href="export.pl" };
print qq{title="$lex{'Export these grades to a CSV file'}">\n};
print qq{$lex{Export} to Spreadsheet</a></li>\n};


print qq{<li><a href="testclone.pl" };
print qq{title="$lex{'Clone Assessment Items'}">};
print qq{$lex{'Clone Assessment Items'}</a></li>\n};

print qq{</ul></body></html>\n};

