#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Reports' => 'Reports',
	   'Gradebook' => 'Gradebook',
	   'Main' => 'Main',
	   'Student' => 'Student',
	   'Report' => 'Report',
	   'Course' => 'Course',
	   'Blank Mark Sheets' => 'Blank Mark Sheets',
	   'Password' => 'Password',
	   'Error' => 'Error',

	   );

use DBI;
use CGI::Session;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " : $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

my $q = CGI->new;

my $userid = $ENV{'REMOTE_USER'};

print $q->header( -charset, $charset );

my $title = qq{$lex{Gradebook} $lex{Reports}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> |\n};
print qq{<a href="gbmain.pl">$lex{Gradebook}</a> ]\n};

print qq{<h1>$title</h1>\n};


# Table
print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

# Mark Sheet
print qq{<tr><td style="vertical-align:top;"><form action="rptMarkSheet.pl" method="post">\n};
print qq{<input type="submit" value="$lex{'Blank Mark Sheets'}"></form></td>\n};

print qq{<td style="width:60ch;">A <b>Mark Sheet to record your raw scores</b> for student tests/evaluations. It will be sorted in the same order as the gradebook with new students at the bottom (assuming you have changed the sorting order (maintenance menu)  in order not to mess up existing test score sheets). I would normally keep all these in a 3 ring binder. <b>Remember</b>: The gradebook does all the calculations from raw scores. You never need to make tests out of 100.\n};
print qq{</td></tr>\n\n};

# Course Report
print qq{<tr><td style="vertical-align:top;"><form action="rptCourse.pl" method="post">\n};
print qq{<input type="submit" value="$lex{Course} $lex{Report}"></form></td>\n};
print qq{<td style="width:60ch;">A report normally used for <b>Parent-Teacher interviews</b>. It shows all averages/scores for a student in all of your courses. It allows for one student per page so this can be passed to the parents. It also has options for attendance reporting as well. };
print qq{</td></tr>\n\n};

# Student Password Report
print qq{<tr><td style="vertical-align:top;"><form action="rptStudPwd.pl" method="post">\n};
print qq{<input type="submit" value="$lex{Password} $lex{Report}"></form>\n};
print qq{<td style="width:60ch;"><b>Print Student Passwords</b> and local student numbers for access on the parent/student site. This will allow parents and students to see their report card marks, attendance, discipline and gradebook marks (if allowed in course masters for each course)};
print qq{</td></tr>\n\n};

print qq{</table>\n};

print qq{</body></html>\n};
