#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Add injury/accident record 


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Save' => 'Save',
	   'Select' => 'Select',

	   );


use DBI;
use CGI;
use Cwd;

my $self = 'landAdd.pl';

my $q = new CGI;
my %arr = $q->Vars;

my @time = localtime(time);
my $year = $time[5] + 1900;
my $month = $time[4] + 1;
my $currdate = "$year-$month-$time[3]";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

# Get current dir so know what CSS to display and shift settings.
if ( getcwd() !~ /tcgi/ ) { # we are in cgi instead
    $tchcss = $css;
    $tchpage = $homepage;
    $tchdownloaddir = $downloaddir;
    $tchwebdownloaddir = $webdownloaddir;
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

my $userid = $ENV{'REMOTE_USER'};

print $q->header( -charset, $charset );


my $dir = getcwd();

# Page Header
my $title = qq{Add Land Based Education Record};
print qq{$doctype\n<html><head><title>$title</title>\n}; 
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}


print qq{$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();
   
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    writeRecord();
} 


#----------------
sub showStartPage {
#----------------

    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    # Start Table
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    # Date
    print qq{<tr><td class="bra">Date</td>\n};
    print qq{<td class="la"><input type="text" name="date" id="date" style="width:10ch;">};
    print qq{<button type="reset" id="start_trigger">...</button>\n};
    print qq{</td></tr>\n};
   
    # Grades
    print qq{<tr><td class="bra">Grades</td>\n};
    print qq{<td class="la"><input type="text" name="grades" style="width:8ch;"> involved</td></tr>\n};

    # Hours
    print qq{<tr><td class="bra"># Hours</td>\n};
    print qq{<td class="la"><input type="text" name="hours" style="width:8ch;"> for this date</td></tr>\n};

    # Description
    print qq{<tr><td class="bra">Description</td>\n};
    print qq{<td class="la">};
    print qq{<textarea name="description" cols="80" rows="4"></textarea>\n};
    print qq{</td></tr>\n};

    # Continue
    print qq{<tr><td></td><td><input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr></table>\n};


    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField  : "date",
        ifFormat    : "%Y-%m-%d",
        button      : "start_trigger",
        singleClick : false,
        step        : 1
    })};

    print qq{</script>\n};
    print qq{</body></html>\n};

    exit;


} # end of showStartPage

=head
#---------------
sub enterLBEvent {
#---------------

    print qq{Enter LBEvent<br>\n};
    foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    exit;
    
    # Print Form Heading
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="2">\n};

    # Save
    print qq{<div style="margin:0.3em;"><input type="submit" value="$lex{Save}"></div>\n};
    
    # Outer Table
    print qq{<table cellpadding="3" cellspacing="0" border="0" style="border:1px solid gray;padding:0.5em;">\n};

    
    # Date
    print qq{<tr><td>Date };
    print qq{<input type="text" name="date" id="date" style="width:10ch;">\n};
    print qq{<button type="reset" id="start_trigger">...</button>\n};
    print qq{(yyyy-mm-dd)</td></tr>\n};

    print qq{<tr><td>\n};
    
    
    # Get Student Record
    my $sth = $dbh->prepare("select * from studentall where studnum = ?");

    
    foreach my $studnum ( sort keys %arr ) {
	# print qq{SN:$studnum<br>\n};
	
	# Get student name and grade, 
	$sth->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth->fetchrow_hashref;
	my %r = %$ref;

	print qq{<h3>$r{firstname} $r{lastname}</h3>\n};
	
	# Print Table Header and Heading values
	print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

	# Injury
	print qq{<tr><td class="bra">Injury</td>};
	print qq{<td><textarea name="$studnum:injury" rows="2" cols="60"></textarea></td></tr>\n};

	# Time
	print qq{<tr><td class="bra">Time</td><td class="la">};
	print qq{<input type="text" name="$studnum:time" style="width:10ch;"> };
	print qq{HH:MM</td></tr>\n};

	# Location
	print qq{<tr><td class="bra">Location</td><td class="la">};
	print qq{<input type="text" name="$studnum:location" style="width:30ch;"></td></tr>\n};

	# Action Taken
	print qq{<tr><td class="bra">Action Taken</td><td class="la">};
	print qq{<textarea name="$studnum:action" rows="2" cols="60"></textarea></td></tr>\n};

	print qq{</table>\n};

    }


    # Close Outer Table
    print qq{</td></tr>\n};
    print qq{</table>\n};

    # Save
    print qq{<div style="margin:0.3em;"><input type="submit" value="$lex{Save}"></div>\n};
    
    print qq{</form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "date", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    });
   </script>\n};

    print qq{</body></html>\n};

    exit;

} # end of LBEvent
=cut


#--------------
sub writeRecord {
#--------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Check for any Blanks in any fields
    my $errorflag;
    foreach my $key ( sort keys %arr ) { 
	if ( not $arr{$key} ) {
	    print qq{<div>Missing value for $key</div>\n};
	    $errorflag = 1;
	}
    }
    if ( $errorflag ) {
    	print qq{</body></html>\n};
	exit;
    }

    
    # Check for messed up Date Format
    if ( $arr{date} =~ m/\// ) { # slashes rather than hyphens
	$errorflag = 1;
    } else {
	my ($y,$m,$d) = split('-', $arr{date});
	if ( not $m or ( $m < 1 or $m > 12 )) { $errorflag = 1; }
	if ( not $d or ( $d < 1 or $d > 31 )) { $errorflag = 1; }
    }
    if ( $errorflag ) {
	# print qq{<div>Year:$y Month:$m Day:$d</div>\n};
	print qq{<h3>Date $lex{Error}: $arr{date}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    print qq{<h3>Date: $arr{date}</h3>\n};


    # Write the landedu record
    my $sth = $dbh->prepare("insert into landedu
    	 ( description, date, entry, grades, hours, author ) 
         values ( ?, ?, now(), ?, ?, ?) ");
    

    # Add Land Edu Record
    $sth->execute( $arr{description},  $arr{date}, $arr{grades},  $arr{hours}, $userid);
    
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    print qq{<div>Record Added for $userid - $arr{date}</b></div>\n};
    
    print qq{<p>[ <a href="$self">Add More</a> | <a href="./landView.pl">View</a> ]\n};

    print qq{</body></html>\n};

    exit;
}
