#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Literacy Intervention' => 'Literacy Intervention',
	   'Delete' => 'Delete',
	   'Continue' => 'Continue',
	   'No User Id' => 'No User Id',
	   'No Password' => 'No Password',
	   'Please Log In' => 'Please Log In',
	   'Record Deleted' => 'Record Deleted',
	   'Admin Password' => 'Admin Password',
	   'Not Allowed' => 'Not Allowed',
	   'Teacher' => 'Teacher',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Group' => 'Group',
	   'Description' => 'Description',
	   'Program Hours' => 'Program Hours',
	   'Program' => 'Program',
	   'Students' => 'Students',

	   );

use DBI;
use CGI;
use CGI::Session;

my $adminpassword = 'meisowen';
my $self = 'lintProgDelete.pl';

# Configuration Settings ---------------------
my $allow_lint = 1; # allow user with lint access code to delete
#---------------------------------------------

my $q = new CGI;
my %arr = $q->Vars;

my @time = localtime(time);
my $year = $time[5] + 1900;
my $month = $time[4] + 1;
my $currdate = "$year-$month-$time[3]";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

# Session Setup Here
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

# Get/Set  Session Values (a defined userid means it was passed)
if ( $arr{userid} ){ # we want to login, passed userid/password pair.

    # Check password/userid against database (-1 no user, -2 wrong password);
    my $error = checkPassword($arr{userid}, $arr{password}, $dbh);
    if ($error == -1){ print $q->header( -charset, $charset ); login($lex{'No User Id'}); }
    if ($error == -2){ print $q->header( -charset, $charset ); login($lex{'No Password'}); }

    $cookietime = checkCookieTime( $arr{duration} );

    # Set values for userid and logged_in in session
    $session->param( 'logged_in','1');
    $session->expire( 'logged_in', $cookietime );
    $session->param( 'userid',$arr{userid} );
    $session->param( 'duration',$cookietime );

    $userid = $arr{userid};


} else { # check logged_in value in session

    if ( not $session->param('logged_in') ){
	$userid = $session->param('userid');
        print $q->header( -charset, $charset );
	print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
        print qq{<h3>$lex{'Please Log In'}</h3></body></html>\n};
        exit;
    }
    # Ok, we have a login. Values below we have in environment.

    $userid = $session->param('userid');
    $duration = $session->param('duration');

    if ( not ($duration =~ /\+/)) { # if not in +20m format, do so.
	$duration = checkCookieTime( $duration );
    }

    $session->expire('logged_in', $duration );


} # End of check for logged_in value

print $session->header( -charset, $charset );
# Session Setup End


# Check for ppvt access code
my $sth = $dbh->prepare("select field_value from staff_multi 
  where field_name = 'access' and userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

my $accesslint;
while ( my $val = $sth->fetchrow ) {
    if ( uc $val eq 'LINT' ) { $accesslint = 1; }
    # print qq{VAL:$val ACCESS:$accessdra<br>\n};
}


# Page Header
my $title = "$lex{Delete} $lex{'Literacy Intervention'} $lex{Group}";
print qq{$doctype\n<html><head><title>$title</title>};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    confirmDelete( $arr{id} );

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteRecord( $arr{id} );
}


#----------------
sub confirmDelete {
#----------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = shift;

    # Check for existing students enrolled.
    my $sth = $dbh->prepare("select count(*) from lint_student where progid = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth->fetchrow;
    if ( $count > 0 ) { # Delete Not Allowed.
	print qq{<h3>$lex{Students}: $count<br>\n};
	print qq{$lex{Delete} $lex{'Not Allowed'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    # Get Lint Record
    my $sth = $dbh->prepare("select * from  lint_program where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %rec = %$ref;


    # Access Controls
    my $failflag;
    if ( not $allow_lint ) { $failflag = 1; } # nobody deletes
    if ( $allow_lint and $accesslint ) { $failflag = 0; } # allow catalyst access
    if ( $adminpassword eq $arr{adminpassword} ) { $failflag = 0; } # allow admin override
    if ( $failflag ) {
	print qq{<h3>$lex{Delete} $lex{'Not Allowed'}</h3>\n};

	print qq{<form action="$self" method="post"> \n};
	print qq{<input type="hidden" name="id" value="$id">\n};
	print qq{<p>$lex{'Admin Password'} <input type="text" size="10" name="adminpassword">\n};
	print qq{<input type="submit" value="$lex{Continue}">\n};
	print qq{</p></form>\n};
	print qq{</body></html>\n};
	exit;
    }

    # Get Teacher Name
    my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    $sth->execute( $rec{userid} );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;


    # Print Form Heading
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="id" value="$id">\n};

    # Print Table Header and Heading values
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td colspan="2" class="bcn">};
    print qq{<input type="submit" value="$lex{Delete} $lex{Program}"></td></tr>\n};

    print qq{<tr><td class="bra">$lex{Teacher}</td>};
    print qq{<td class="la">$firstname $lastname ($rec{userid})</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Group} $lex{Description}</td>};
    print qq{<td class="la">$rec{groupdesc}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{'Start Date'}</td><td class="la">$rec{startdate}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{'End Date'}</td><td class="la">$rec{enddate}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{'Program Hours'}</td>};
    print qq{<td class="la">$rec{programhours}</td></tr>\n}; 

    print qq{<tr><td colspan="2" class="bcn">};
    print qq{<input type="submit" value="$lex{Delete} $lex{Program}"></td></tr>\n};

    print qq{</table></form></body></html>\n};

    exit;
}


#---------------
sub deleteRecord {
#---------------

    my $id = shift;

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Delete Test
    $sth = $dbh->prepare("delete from lint_program where id = ?");  
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }


    print qq{<h1>$lex{'Record Deleted'}</h1>\n};

    print qq{<p>[ <a href="$tchpage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
