#! /usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Outline: This prints a full report of evaluations for a group of
#  students. These student numbers are passed in the %arr hash.

my %lex = ('Student Marks' => 'Student Marks',
	   'No Course Enrollments' => 'No Course Enrollments',
	   'Error' => 'Error',
	   'Term' => 'Term',
	   
	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

# Passed Values: studnum, subjsec, term
my $studnum = $arr{studnum};
my $term = $arr{term};


# Print the Page Header
print qq{$doctype\n<html><head><title>$lex{'Student Marks'}</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get student name...
my $sth = $dbh->prepare("select lastname, firstname from student where studnum = ?");
$sth->execute($studnum);
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
my ($lastname, $firstname) = $sth->fetchrow;

print qq{<h2>$firstname $lastname <span style="font-size:80%;">};
print qq{$lex{Term}:$term</span></h2>\n};
print qq{<table cellpadding="3" cellspacing="0" border="1">\n};


# Find student subjects and eval.id in order by subject description.
my $sth = $dbh->prepare("select distinct subject.description, eval.subjcode, 
 eval.id from eval, subject
 where eval.subjcode = subject.subjsec and eval.studnum = ? and eval.term = ?
 order by subject.description, eval.subjcode");
$sth->execute($studnum, $term);
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


my $sth1 = $dbh->prepare("select * from eval where id = ?");
my $subjflag = 0; # flag in case of no course enrollments.

while ( my ( $desc, $subjsec, $id ) = $sth->fetchrow ){ # Loop through each subject.

    $subjflag = 1; # we have at least one subject

    # Get eval record.
    $sth1->execute( $id );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $eref = $sth1->fetchrow_hashref;
    my %eval = %$eref;

    print qq{<tr><td><b>$desc</b> };

    if ( $eval{a2} ) { # We have more than 1 entry... load descriptors from subject.

	# Load Subject
	my $sth2 = $dbh->prepare("select * from subject where subjsec = ?");
	$sth2->execute( $subjsec );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $sref = $sth2->fetchrow_hashref;
	my %subject = %$sref;

	print '[ ';
	foreach my $i (1..20) {
	    my $skey = 'q'. $i;
	    my $ekey = 'a'. $i;
	    if ( $subject{$skey} ) {
		print qq{$subject{$skey} &ndash; $eval{$ekey} | \n};
	    } else {
		last; # done
	    }
	}
	# if comment
	if ( $eval{comment} ) { print qq{<br><i>$eval{comment}</i>\n}; }
	
    } else { # only a mark value

	if ( $eval{a1} ) { print qq{&ndash; $eval{a1} }; }  # mark
	if ($eval{comment}) { print qq{&ndash; $eval{comment} }; } # comment
    }

    print qq{</td></tr>\n};


} # Next Subject


if (not $subjflag){ # No Course enrollments for this student.
    my $colcount = $maxterm + 1;
    print qq{<tr><td colspan="$colcount"><b>$lex{'No Course Enrollments'}</b></td></tr>\n};
}

print qq{</table></body></html>\n};
