#!/usr/bin/perl
#  Copyright 2001-2012 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Class Report' => 'Class Report',
	   'Date' => 'Date',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Student' => 'Student',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Blank=All' => 'Blank=All',
	   'No Students Found' => 'No Students Found',
	   'Show Only Latest Test' => 'Show Only Latest Test',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Test' => 'Test',
	   'Not Found' => 'Not Found',
	   'Raw Score' => 'Raw Score',
	   'Standard Score' => 'Standard Score',
	   'Percentile' => 'Percentile',
	   'Age' => 'Age',
	   'Equivalent' => 'Equivalent',

	   );


use DBI;
use CGI;
use Number::Format qw(:all);

my $self = 'pvRptClass.pl';

my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
if ( length( $month) == 1 ) { $month = '0'. $month; }
if ( length( $day) == 1 ) { $day = '0'. $day; }
my $currdate = "$year-$month-$day";

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

my $q = new CGI;
print $q->header; 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = "PPVT $lex{'Class Report'}";
print "$doctype\n<html><head><title>$title</title>";
print "<link rel=\"stylesheet\" href=\"$tchcss\" type=\"text/css\">
<style type=\"text/css\">
th.fs6{font-size:60%;}
td { text-align:center; }
td.r { background-color:#822;color:white;font-size:120%;font-weight:bold; }
td.y { background-color:#BB1;color:white;font-size:120%;font-weight:bold; }
td.b { background-color:#228;color:white;font-size:120%;font-weight:bold; }
td.g { background-color:#282;color:white;font-size:120%;font-weight:bold; }
a {color:white; }
a.alt {color:blue; }
</style>\n";

if ( not $arr{page} ) { # calendar popup.
    print "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" ";
    print "href=\"/js/calendar-blue.css\" title=\"blue\">\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/lang/calendar-en.js\"></script>\n";
    print "<script type=\"text/javascript\" src=\"/js/calendar-setup.js\"></script>\n";
}

print "<script language=\"javascript\" type=\"text/javascript\">
function showhelp(type) {
  winName=window.open('/cgi-bin/reading/showhelp.pl?id=' + type,'helpWindow',
  'height=300,width=700,screenX=100,screenY=100,resizeable');
  winName.focus();
}
</script>
$chartype\n</head><body style=\"padding:1em 6em 0 0.5em;\">\n";

print "[ <a class=\"alt\" href=\"$tchpage\">$lex{Main}</a> ]\n";
print "<h1>$title</h1>\n\n";

if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showReport();
} 



#----------
sub fmtDate {
#----------

    my ( $year, $mon, $day ) = split /-/, shift;
    return "$year-$s_month[$mon]-$day";
}


#----------------
sub showStartPage {
#----------------

    # Form Start - Student Group
    print "<form action=\"$self\" method=\"post\"> \n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" ";
    print "style=\"padding:0.5em;border:1px solid gray;\">\n";

    print "<tr><td class=\"ra\">$lex{Select} $lex{Student}</td>\n";
    print "<td><select name=\"groupname\"><option value=\"grade\">$lex{Grade}</option>\n";
    print "<option value=\"homeroom\">$lex{Homeroom}</option>\n";
    print "</select>\n";
    print "<input type=\"text\" name=\"groupvalue\" size=\"10\"> ";
    print "$lex{'Blank=All'}</td></tr>\n\n";

    print "<tr><td class=\"ra\">\n";
    print "<input type=\"checkbox\" name=\"onlylatest\" value=\"1\">\n";
    print "<td class=\"la\">$lex{'Show Only Latest Test'}</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{'Start Date'}</td><td class=\"la\"><input type=\"text\" ";
    print "name=\"startdate\" id=\"sdate\" size=\"10\" value=\"$schoolstart\">";
    print "<button type=\"reset\" id=\"start_trigger\">...</button>\n";
    print "</td></tr>\n";

    print "<tr><td class=\"ra\">$lex{'End Date'}</td><td class=\"la\"><input type=\"text\" ";
    print "name=\"enddate\" id=\"edate\" size=\"10\" value=\"$currdate\">";
    print "<button type=\"reset\" id=\"end_trigger\">...</button></td></tr>\n";


    print "<tr><td></td><td class=\"la\"><input type=\"submit\" value=\"$lex{Continue}\"></td></tr>\n";
    print "</table></form>\n";

    print "<script type=\"text/javascript\">
     Calendar.setup({
        inputField     :    \"sdate\", 
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"start_trigger\",
        singleClick    :    false,
        step           :    1
    });

    Calendar.setup({
        inputField     :    \"edate\",
        ifFormat       :    \"%Y-%m-%d\",
        button         :    \"end_trigger\",
        singleClick    :    false,
        step           :    1
    });
   </script>\n";

    print "</body></html>\n";

    exit;

} # end of showStartPage



#-------------
sub showReport {
#-------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $group;
    my @students = ();

    my $startdate = $arr{startdate};
    my $enddate = $arr{enddate};
    delete $arr{startdate};
    delete $arr{enddate};   

    # Show Group Name and Value
    if ( $arr{groupvalue} ) {
	my $groupname = $lex{Grade};
	if ( $arr{groupname} eq 'homeroom' ) { $groupname = $lex{Homeroom}; }

	print "<h3 style=\"font-size:120%;margin:0;padding:0.3em;\">";
	print "$groupname $arr{groupvalue} ";

        # Get Teacher, if any
	if ( $arr{groupname} eq $lex{Homeroom} ) {
	    my $sth = $dbh->prepare("select lastname, firstname from staff as s, staff_multi as sm
              where sm.userid = s.userid and field_name = 'homeroom' and field_value = ?");
	    $sth->execute( $arr{groupvalue} );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my ( $lastname, $firstname ) = $sth->fetchrow;
	    if ( $lastname ) {
		print " &ndash; $firstname $lastname ";
	    }
	}

	print "</h3>\n"
    }



    # Find students in this group and order by testdates.
    if ( $arr{groupname} eq 'homeroom' ) {
	$group = 'homeroom';
    } else {
	$group = 'grade';
    }

    # Find students with tests, add in missing current students.??
    my @students = ();

#    my $sth = $dbh->prepare("select distinct s.studnum from ppvt_test as t, student as s
#     where $group = ? and t.studnum = s.studnum 
#     order by s.lastname, s.firstname");

    my $sth = $dbh->prepare("select studnum from student
     where $group = ? order by lastname, firstname");

    $sth->execute( $arr{groupvalue} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my ( $studnum ) = $sth->fetchrow ) {
	push @students, $studnum;
    }

    if ( not @students ) {
	print "<h3>$lex{'No Students Found'}</h3>\n";
	print "</body></html>\n";
    }

    showTests( \@students, $startdate, $enddate, $arr{onlylatest} );
    
    print "</body></html>\n";

    exit;

}


#------------
sub showTests {
#------------

    my ( $stud_ref, $startdate, $enddate, $onlylatest ) = @_;
    my @students = @$stud_ref;
    
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\">\n";
    print "<tr><th></th><th>$lex{Test} $lex{Date}</th><th>Raw</th>\n";
    print "<th>Std</th><th>Per</th><th>AgeE</th>\n";

    # Now loop through all students printing results; setup queries first
    $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

    $sth1 = $dbh->prepare("select * from ppvt_test 
     where studnum = ? and to_days( tdate ) >= to_days( '$startdate' ) 
     and to_days( tdate ) <= to_days( '$enddate') order by tdate desc"); # get tests


    foreach my $studnum ( @students ) {

        # Get Name
	$sth->execute( $studnum );
	my ( $lastname, $firstname ) = $sth->fetchrow;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	# Get Tests
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $trows = $sth1->rows;

	if ( $trows < 1 ) { # no tests.
	    print "<tr><td class=\"la\"><b>$lastname</b>, $firstname</td>\n";
	    print "<td class=\"bla\" colspan=\"5\">$lex{'Test'} $lex{'Not Found'}</td></tr>\n";
	    next; 
	}

	# if $onlylatest, limit to 1 test
	if ( $onlylatest and $trows > 1 ) { $trows = 1; } 

	for ( 1 .. $trows ) {

	    my $ref = $sth1->fetchrow_hashref;
	    my %rec = %$ref;

	    print "<tr><td class=\"la\"><b>$lastname</b>, $firstname</td>\n";
	    print "<td>$rec{tdate}</td><td>$rec{rawscore}</td><td>$rec{stdscore}</td>";
	    print "<td>$rec{percentile}</td><td>$rec{equivage}</td>\n";
	    print "</tr>\n";

	} # end of test print loop

    } # end of student loop.

    print "</table><p></p>\n";

    print "<tr><td class=\"la\" colspan=\"5\" style=\"font-size:80%;\">";
    print "Raw = $lex{'Raw Score'},&nbsp;&nbsp;Std = $lex{'Standard Score'},\n";
    print "Per = $lex{Percentile},&nbsp;&nbsp;AgeE = $lex{Age} $lex{Equivalent}</td></tr>\n";

    return;

}
