#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'PPVT Scores' => 'PPVT Scores',
	   'Delete' => 'Delete',
	   'Continue' => 'Continue',
	   'Test Date' => 'Test Date',
	   'No User Id' => 'No User Id',
	   'No Password' => 'No Password',
	   'Please Log In' => 'Please Log In',
	   'Record(s) Deleted' => 'Record(s) Deleted',
	   'Admin Password' => 'Admin Password',
	   'Not Allowed' => 'Not Allowed',
	   'Raw Score' => 'Raw Score',
	   'Standard Score' => 'Standard Score',
	   'Grade' => 'Grade',
	   'Test' => 'Test',
	   'Author' => 'Author',

	   );

use DBI;
use CGI;
use CGI::Session;

my $adminpassword = 'meisowen';
my $self = 'pvTestDelete.pl';

# Configuration Settings ---------------------
my $allow_author = 1; # allow author to delete
my $allow_ppvt = 1; # allow user with dra access code to delete
#---------------------------------------------

my $q = new CGI;
my %arr = $q->Vars;

my @time = localtime(time);
my $year = $time[5] + 1900;
my $month = $time[4] + 1;
my $currdate = "$year-$month-$time[3]";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

# Session Setup Here
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

# Get/Set  Session Values (a defined userid means it was passed)
if ( $arr{userid} ){ # we want to login, passed userid/password pair.

    # Check password/userid against database (-1 no user, -2 wrong password);
    my $error = checkPassword($arr{userid}, $arr{password}, $dbh);
    if ($error == -1){ print $q->header( -charset, $charset ); login($lex{'No User Id'}); }
    if ($error == -2){ print $q->header( -charset, $charset ); login($lex{'No Password'}); }

    $cookietime = checkCookieTime( $arr{duration} );

    # Set values for userid and logged_in in session
    $session->param( 'logged_in','1');
    $session->expire( 'logged_in', $cookietime );
    $session->param( 'userid',$arr{userid} );
    $session->param( 'duration',$cookietime );

    $userid = $arr{userid};


} else { # check logged_in value in session

    if ( not $session->param('logged_in') ){
	$userid = $session->param('userid');
        print $q->header( -charset, $charset );
        print qq{$lex{'Please Log In'}</body></html>\n}; 
        exit;
    }
    # Ok, we have a login. Values below we have in environment.

    $userid = $session->param('userid');
    $duration = $session->param('duration');

    if ( not ($duration =~ /\+/)) { # if not in +20m format, do so.
	$duration = checkCookieTime( $duration );
    }

    $session->expire('logged_in', $duration );


} # End of check for logged_in value

print $session->header( -charset, $charset );
# Session Setup End


# Check for ppvt access code
my $sth = $dbh->prepare("select field_value from staff_multi 
  where field_name = 'access' and userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

my $accessppvt;
while ( my $val = $sth->fetchrow ) {
    if ( uc $val eq 'PPVT' ) { $accessppvt = 1; }
    # print qq{VAL:$val ACCESS:$accessdra<br>\n};
}


# Page Header
print qq{$doctype\n<html><head><title>$lex{Delete} $lex{'PPVT Scores'}};
print qq{</title><link rel="stylesheet" href="$tchcss" type="text/css">\n};

print qq{<style type="text/css">td.ra { text-align:right; }
td.bcn { font-size:100%;text-align:center;font-weight:bold; }
</style>\n};

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$lex{Delete} $lex{'PPVT Scores'}</h1>\n};


if ( not $arr{page} ) {
    selectTest( $arr{testid} );
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteTest();
}


#-------------
sub selectTest {
#-------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $testid = shift;

    # Get PPVT Test fields.
    my $sth = $dbh->prepare("select studnum, tdate, tauthor, rawscore, stdscore 
     from  ppvt_test where id = ?");
    $sth->execute( $testid );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my ( $studnum, $tdate, $tauthor, $rawscore, $stdscore ) = $sth->fetchrow;

    # Access Controls
    my $failflag;
    if ( not $allow_author and not $allow_ppvt ) { $failflag = 1; } # nobody deletes
    elsif ( $allow_author and $tauthor ne $userid ) { $failflag = 1; } # not author

    if ( $allow_ppvt and $accessppvt ) { $failflag = 0; } # allow dra override of author failure
    if ( $adminpassword eq $arr{adminpassword} ) { $failflag = 0; } # allow admin override
    if ( $failflag ) {
	print qq{<h3>$lex{Delete} $lex{'Not Allowed'}</h3>\n};

	print qq{<form action="$self" method="post"> \n};
	print qq{<input type="hidden" name="testid" value="$testid">\n};
	print qq{<p>$lex{'Admin Password'} <input type="text" size="10" name="adminpassword">\n};
	print qq{<input type="submit" value="$lex{Continue}">\n};
	print qq{</p></form>\n};
	print qq{</body></html>\n};
	exit;
    }


    # Get Student Name
    my $sth1 = $dbh->prepare("select lastname, firstname, grade from student where studnum = ?");
    $sth1->execute( $studnum );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ( $lastname, $firstname,$grade ) = $sth1->fetchrow;
    # print qq{Name: $lastname $firstname<br>\n};

    # Print Form Heading
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="testid" value="$testid">\n};

    # Print Table Header and Heading values
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td colspan="2" class="bcn">};
    print qq{<input type="submit" value="$lex{Delete} $lex{Test}"></td></tr>\n};

    print qq{<tr><td colspan="3" class="bcn">$firstname $lastname</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Grade}</td><td class="la">$grade</td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Test Date'}</td><td class="la">$tdate</td></tr>\n}; 

    print qq{<tr><td class="bra">$lex{Author}</td><td class="la">$tauthor</td></tr>\n}; 

    print qq{<tr><td class="bra">$lex{'Raw Score'}</td><td class="la">$rawscore</td></tr>\n};
    print qq{<tr><td class="bra">$lex{'Standard Score'}</td><td class="la">$stdscore</td></tr>\n};

    print qq{<tr><td colspan="2" class="bcn">};
    print qq{<input type="submit" value="$lex{Delete} $lex{Test}"></td></tr>\n};

    print qq{</table></form></body></html>\n};

    exit;

}


#--------------
sub deleteTest {
#--------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $testid = $arr{testid};

    # Delete Test
    $sth = $dbh->prepare("delete from ppvt_test where id = ?");  
    $sth->execute( $testid );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }


    print qq{<h1>$lex{'Record(s) Deleted'}</h1>\n};

    print qq{<p>[ <a href="$tchpage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
