#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Read Report - read all reading tests from all schools, calc the
# Equiv Grade and then compare to the actual grade and get a
# delta. Compile into per grade, per school and overall stats.


my %lex = ('Error' => 'Error',
	   'Main' => 'Main',
	   'Date' => 'Date',
	   'Continue' => 'Continue',
	   'Schools' => 'Schools',
	   'Database' => 'Database',
	   'Reading' => 'Reading',
	   'Check' => 'Check',
	   'Tests' => 'Tests',

	   );


my $self = 'readTestCheck.pl';


use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

# Get current dir so know what CSS to display and shift to teacher settings.
if ( getcwd() !~ /tcgi/ ) { # we are in cgi

    $tchcss = $css;
    $tchpage = $homepage;
    $tchdownloaddir = $downloaddir;
    $tchwebdownloaddir = $webdownloaddir;
}


my $q = new CGI;
print $q->header; 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

# Page Header
my $title = "$lex{Check} $lex{Reading} $lex{Tests}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

print qq{$chartype\n</head><body style="padding:0.4em 2em;">\n};
print qq{[ <a class="alt" href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


checkTests();


#-------------
sub checkTests {
#-------------

    my $sth1 = $dbh->prepare("select count(*) from read_test_score where testid = ?");

    my $sth2 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth3 = $dbh->prepare("select lastname, firstname from staff where userid = ?");

	
    my $sth = $dbh->prepare("select * from read_test order by tdate, studnum");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $errorflag;
    my $first = 1;
	
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %t = %$ref;

	$sth1->execute($t{id});
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	if ( not $count ) { # missing scores
	    $errorflag = 1;

	    if ( $first ) {
		print qq{<table cellpadding="3" cellspacing="0" border = "1">\n};
		print qq{<caption style="font-size:120%;font-weight:bold;">Missing Scores</caption>\n};
		print qq{<tr><th>Student</th><th>Teacher</th><th>Date</th><th>Season</th></tr>\n};
		$first = 0;
	    }


	    # Get Student Name
	    $sth2->execute($t{studnum});
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth2->fetchrow;


	    # Get Staff Name
	    $sth3->execute($t{tauthor});
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my ($tlastname, $tfirstname) = $sth3->fetchrow;
	    my $staffname = "<b>$tlastname</b>, $tfirstname";
	    if ( not $tlastname ) { $staffname = $t{tauthor}; }
	    
	    print qq{<tr><td class="la"><b>$lastname</b>, $firstname ($t{studnum})</td>};
	    print qq{<td class="la">$staffname</td>\n};
	    print qq{<td>$t{tdate}</td><td>$t{season}</td></tr>\n};


	}
    } # end of reading tests loop

    if ( not $first ) { print qq{</table>\n}; }; # close the table.
	
    if ( not $errorflag ) { 
	print qq{<h3>No Missing Scores found</h3>\n};
    } else {
	print qq{<p></p>\n};
    }
	
    print qq{</body></html>\n};
    exit;

}
    
