#! /usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson
# Part of Open Administration for Schools

my %lex = ('Attendance Report' => 'Attendance Report',
	   'Attendance' => 'Attendance',
	   'Continue' => 'Continue',
	   'Course' => 'Course',
	   'Date' => 'Date',
	   'Details' => 'Details',
	   'End Date' => 'End Date',
	   'Error' => 'Error',
	   'Main' => 'Main',
	   'Missing' => 'Missing',
	   'Period' => 'Period',
	   'Teacher' => 'Teacher',
	   'View' => 'View',
	   
    );


use DBI;
use CGI;
use Number::Format qw(:all);
use Time::JulianDay;
use Cwd;

# Constants
my $self = 'rptatttch3.pl';


# Get current dir so know what path for config files.
my $configpath;
my $teachermode;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $teachermode = 1;
    $configpath = '..'; # go back one to get to etc.

} else {
    $configpath = '../..'; # go back two to get to etc.
}

# main config file
eval require "$configpath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "$configpath/lib/libattend.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Needs findDayInCycle function
eval require "$configpath/lib/libschedule.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "$configpath/lib/libDate.pl";  # functions to check partial day closure vals; grades field.
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $dsn = "DBI:$dbtype:$dbase";
$dbh = DBI->connect($dsn,$user,$password);

my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
if (length($month) == 1){ $month = "0".$month;}
if (length($day) == 1){ $day = "0".$day;}
my $currsdate = "$year-$month-$day";
my $currdate = "$month[$month] $day, $year";


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


# Find partial day closures from dates_periods for entire year.
my %pclosed;

my $sth = $dbh->prepare("select * from dates_periods");
$sth->execute;
if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref; # date, grades, period
	
	my $cref = parseGradesPeriod( $r{date}, $dbh);
	%cl = %$cref; # periods closed for this date cl{grade}{period} = 1
	foreach my $gr ( keys %cl ) {
	    foreach my $per ( sort keys %{ $cl{$gr} } ) { # if we have a value.
		$pclosed{ $r{date} }{ $gr }{$per} = 1;
	    }
	}
    }
    # we now have %pclosed{date}{grade}{period} = 1;

    # Test %pclosed;
=head    
    foreach my $date ( sort keys %pclosed ) {
	foreach my $grade ( sort keys %{ $pclosed{$date} } ) {
	    foreach my $period ( sort keys %{ $pclosed{$date}{$grade} } ) {
		print qq{Date:$date Grade:$grade Period:$period<br>\n};
	    }
	}
    }
=cut



# Get current dir so know what CSS to display and shift to teacher settings.
if ( getcwd() =~ /tcgi/ ) { # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
    $downloaddir = $tchdownloaddir;
    $webdownloaddir = $tchwebdownloaddir;
}


# HTML Header
my $title = "$lex{Teacher} $lex{'Attendance Report'} 2 (Course Attendance Entry)";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
<style type="text/css">.ra { text-align:right;} .cn {text-align:center;}</style>
<link rel="stylesheet" type="text/css" media="all" href="/js/calendar-blue.css" title="blue">
<script type="text/javascript" src="/js/calendar.js"></script>
<script type="text/javascript" src="/js/lang/calendar-en.js"></script>
<script type="text/javascript" src="/js/calendar-setup.js"></script>
$chartype\n</head><body>\n};


print qq{[ <a href="$homepage">$lex{Main}</a> };
if (not $teachermode ) {
    print qq{| <a href="$attpage">$lex{Attendance}</a> ]\n};
} else {
    print qq{]\n};
}

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    viewDetails();
}

delete $arr{page};

#foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n};}

my $enddate;
if ( $arr{enddate} ){
    $enddate = $arr{enddate};
} else {
    $enddate = $currsdate;
}


# Get Courses, Teachers.
my @grades;
foreach my $gr ( sort {$a <=> $b} keys %g_AttendanceEntryMethod ) {
    if ( $g_AttendanceEntryMethod{$gr} eq 'subject' ) {
	push @grades, $gr;
    }
}
if ( not @grades ) {
    print qq{<h3>No Grades with Course Attendance</h3>\n};
    print qq{</body></html>\n};
    exit;
}

my $select = 'where ';
my $first = 1;
foreach my $gr ( @grades ) {
    if ( not $first ) { $select .= ' or '; }
    $select .= "grade = '$gr'";
    $first = 0;
}

#print qq{Select:$select<br>\


my $sth = $dbh->prepare("select subjsec, teacher, description from subject $select 
			order by teacher, description");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

# Setup check for actual enrollments
my $sth1 = $dbh->prepare("select count(*) from eval where subjcode = ?");

my $sth2 = $dbh->prepare("select lastname, firstname from staff where userid = ?");

print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
print qq{<tr><th>$lex{Teacher}</th><th>$lex{Course}</th><th>Periods<br>Missed</th><th></th></tr>\n};


while ( my ($subjsec, $userid, $desc) = $sth->fetchrow ) {
    
    # Check for Enrollments
    $sth1->execute( $subjsec );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth1->fetchrow;
    if ( $count < 1 ) { next; } # skip this course; no enrollments.

    # Get Name
    $sth2->execute( $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth2->fetchrow;


    # Check attendance
    # my @res = checkCourseAttEntry( $enddate, $subjsec, $dbh );
    # foreach my $res ( @res ) { print qq{ $res}; }
    my $res = checkCourseAttEntry( $enddate, $subjsec, \%pclosed, $dbh );  # from libAttend.pl

    if ($res) { # we have a non-zero result
    
	print qq{<tr><td>$firstname $lastname</td><td>$desc ($subjsec)</td>};
    	print qq{<td class="cn">$res</td>\n};

	print qq{<td>};
	print qq{<form action="$self" method="post" style="display:inline;">\n};
	print qq{<input type="hidden" name="page" value="2">\n};
	print qq{<input type="hidden" name="enddate" value="$enddate">\n};
	print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
	print qq{<input type="submit" value="$lex{View} $lex{Details}">\n};
	print qq{</form>\n};

	print qq{</td></tr>\n};
    }

}


#----------------
sub showStartPage {
#----------------


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<table cellspacing="0" cellpadding="3" border="0">\n};

    
    print qq{<tr><td class="ra">$lex{'End Date'}</td><td>\n};
    print qq{<input type="text" id="monthatt_date" name="enddate" value="$currsdate" size="10">\n};
    print qq{<button type="reset" id="monthatt_trigger">...</button></td></tr>\n};

    print qq{<tr><td class="bla" colspan="2">So we don't search all year....</td></tr>\n};

    print qq{<tr><td></td><td><input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table></form>\n};

    print qq{<script type="text/javascript">\n};
    print "Calendar.setup({ \n";
    print qq{inputField  : "monthatt_date", \n};
    print qq{ifFormat    : "%Y-%m-%d", \n};
    print qq{button      : "monthatt_trigger", \n};
    print qq{singleClick : false, \n};
    print qq{step : 1 \n};
    print "})\n";
    print qq{</script>\n};

    print qq{</body></html>\n};

    exit;

}


#--------------
sub viewDetails {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed: enddate, subjsec
    
    
    # Load Course Info
    my $sth = $dbh->prepare("select * from subject where subjsec = ?");
    $sth->execute( $arr{subjsec} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %sr = %$ref;

    # Get Name of Teacher for this Course
    my $sth2 = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    $sth2->execute( $sr{teacher} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth2->fetchrow;

    print qq{<h3>$sr{description} ($sr{subjsec}) - $firstname $lastname</h3>\n};

    # Check attendance
    my @res = checkCourseAttEntry( $arr{enddate}, $sr{subjsec}, \%pclosed, $dbh );
    my $first = 1;
    my $count;
    foreach my $res ( sort @res ) {
	if ( $first ) {
	    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
	    print qq{<tr><th>$lex{Missing}<br>$lex{Date}</th><th>$lex{Period}</th>};
	    print qq{<th>Cycle Day</th></tr>\n};
	    $first = 0;
	}

	$count++;
	my ( $date, $period ) = split(':', $res);
	my $dayincycle = findDayInCycle( $date );
	my $dow = day_of_week( julian_day( split('-', $date))) + 1;
	print qq{<tr><td class="la">$count. $date ($s_dow[$dow])</td>};
	print qq{<td class="cn">$period</td><td class="cn">$dayincycle</td></tr>\n};
    }

    if ( $first ) {
	print qq{<h4>No Records Found</h4>\n};
    } else {
	print qq{</table>\n};
    }
    print qq{</body></html>\n};

    exit;

}
