#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View' => 'View',
	   'Staff' => 'Staff',
	   'Absences' => 'Absences',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'No Records Found' => 'No Records Found',
	   'Error' => 'Error',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',

	   );


use DBI;
use CGI;
use CGI::Session;
use Cwd;

my $self = 'staffabsTch.pl';


eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


eval require "../lib/libsession.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Get Session Information...
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

# Get/Set  Session Values (a defined userid means it was passed)

my ($userid, $duration);
if ( $arr{userid} ){ # we want to login, passed userid/password pair.

    # Check password/userid against database (-1 no user, -2 wrong password;
    my $error = checkPassword($arr{userid}, $arr{password}, $dbh);
    if ($error == -1){ print $q->header( -charset, $charset ); login( $lex{'No User Id'}); }
    if ($error == -2){ print $q->header( -charset, $charset ); login($lex{'No Password'}); }

    $cookietime = checkCookieTime( $arr{duration} );

    # Set values for userid and logged_in in session
    $session->param('logged_in','1');
    $session->expire('logged_in',$cookietime );
    $session->param('userid', $arr{userid} );
    $session->param( 'duration', $cookietime );

    $userid = $arr{userid};
    $duration = $cookietime;

} else { # check logged_in value in session

    if ( not $session->param('logged_in') ){
	$userid = $session->param('userid');
        print $q->header( -charset, $charset );
        login( $lex{'Please Log In'}, $userid ); 
    }
    # Ok, we have a login. Values below we have in environment.

    $userid = $session->param('userid');
    $duration = $session->param('duration');
    if ( not ($duration =~ /\+/)) { # if not in +20m format, do so.
	$duration = checkCookieTime( $duration );
    }
    $session->expire('logged_in',$duration); # duration is in +20m format;

} # End of check for logged_in value

print $session->header( -charset, $charset );


# Print Page Header
my $title = qq{$lex{View} $lex{Staff} $lex{Absences}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{</head>\n};

print qq{<body>[ <a href="$tchpage">$lex{Main}</a> ]\n};


my $sth = $dbh->prepare("show columns from staff_absent");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while (my @cols = $sth->fetchrow ) {
    if ( $cols[0] eq 'id' or $cols[0] eq 'comment' ) { next; }
    push @fields, $cols[0];
}

$sth = $dbh->prepare("select * from staff_absent where userid = ? order by adate desc");
$sth->execute( $userid );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

print qq{<h1>$title</h1>\n};

if ($rows < 1 ) {
    print qq{<p>$lex{'No Records Found'}</p>\n};
    print qq{</body></html>\n};
    exit;
}

print qq{<table border="1" cellpadding="3" cellspacing="0">\n};

print qq{<tr>};
foreach my $fld (@fields ) {
    print qq{<th>$fld</th>};
}
print qq{</tr>\n\n};


my ($totalabs, $totallate);
while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;

    if ( $r{daypart} and not $r{late} ) {
	if ( $r{daypart} eq 'All Day' ) {
	    $totalabs ++;
	} else {
	    $totalabs += 0.5;
	}
    }

    if ( $r{late} ) {
	$totallate += $r{late};
    }
    
    
    print qq{<tr>};
    foreach my $field ( @fields ) {
	print qq{<td>$r{$field}</td>};
    }
    print qq{</tr>\n};
    
}

print qq{<tr style="background-color:#DDD;"><td colspan="5" class="bra">Totals</td>\n};
print qq{<td>$totalabs</td><td></td><td>$totallate</td></tr>\n};

print qq{</table>\n};
print qq{<p>[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{</body></html>\n};
