#!/usr/bin/perl
# Copyright Leslie Richardson 2001-2024

#  This file is part of Open Admin for Schools
#  Freely licensed under the GNU GPL.

my %lex = ('Student Attendance' => 'Student Attendance',
	   'View' => 'View',
	   'Main' => 'Main',
	   'Search' => 'Search',
	   'Date' => 'Date',
	   'Reason' => 'Reason',
	   'Period' => 'Period',
	   'Subject' => 'Subject',
	   'Select' => 'Select',
	   'Student' => 'Student',
	   'Continue' => 'Continue',
	   'Error' => 'Error',
	   'Last,First/Last/Initials/Studnum' => 'Last,First/Last/Initials/Studnum',

	   );

my $self = 'studattview.pl';

use DBI;
use CGI;

# Read config variables
eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header.
my $title = qq{$lex{Search} $lex{'Student Attendance'}};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$tchcss" type="text/css">
$chartype\n</head><body style="padding:1em;">[ <a href="$tchpage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showSearchForm();
    print qq{</body></html>\n};
    exit;

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    doSearch();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    showAttendance();
}


#-----------------
sub showAttendance {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $studnum = $arr{student};

    # Get student info...
    my $sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    $sth->execute($studnum);
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;

    # Retrieve Student Attendance records
    $sth = $dbh->prepare("select attid, absdate, reason, period, subjsec 
      from attend where studentid = ? order by absdate desc, period");
    $sth->execute( $studnum );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}


    print qq{<div style="font-size:130%;font-weight:bold;">};
    print qq{$firstname $lastname ($studnum)</div>\n};
    print qq{<table border="1" cellpadding="3" cellspacing="0">\n};

    print qq{<tr><th>$lex{Date}</th><th>$lex{Reason}</th><th>};
    print qq{$lex{Period}</th><th>$lex{Subject}</th></tr>\n};
    
    my $colcolor = 'blue'; # tr colors are blue or gray;
    my $currdate = -1;
    
    while ( my ( $attid, $absdate, $reason, $period, $subjsec ) = $sth->fetchrow ) {
	$prevdate = $currdate;
	$currdate = $absdate;
	if ($prevdate ne $currdate){
	    if ($colcolor eq 'blue'){ 
		$colcolor = 'gray';
	    } else { 
		$colcolor = 'blue';
	    }
	}

	print qq{<tr class="$colcolor"><td>$absdate</td><td>$reason</td>};
	print qq{<td>$period</td><td>$subjsec</td></tr>\n};
    }

    print qq{</table><p></p>};
    showSearchForm();
    print qq{</body></html>\n};

    exit;

}


#-----------
sub doSearch {
#-----------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $student = $arr{student};

    # Setup the Search
    if ($student =~ /\d+/) {  # we have a student number
	$studentnumber = $student;
	$sth = $dbh->prepare("select lastname,firstname,studnum
         from studentall where studnum = '$student'");

    } else { # we have words hopefully with a comma
	($lastname,$firstname)  = split /\,/, $student;
	$firstname =~ s/^\s*//;
	$lastname =~ s/^\s*//;
	if ($lastname and $firstname){ # both entered.
	    $sth = $dbh->prepare("select lastname,firstname,studnum
             from studentall
             where lastname = '$lastname' and firstname = '$firstname'");

	} elsif ($lastname and not $firstname){ # only lastname (no comma)
	    if (length($lastname) == 2){ # search by initials: fi, li.
		$fi = substr($lastname,0,1); $li = substr($lastname,1,1);
		$sth = $dbh->prepare("select lastname,firstname,studnum
                  from studentall 
                  where lastname $sql{like} '$li%' and 
                    firstname $sql{like} '$fi%'");

	    } else {  # Lastname only 
		$sth = $dbh->prepare("select lastname, firstname, 
                  studnum from studentall 
                  where lastname = '$lastname' order by studentall.firstname");
	    }
	}
    }

    my %students;
    my %sort;
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my ($lastname, $firstname,$studnum) = $sth->fetchrow ) {
	$students{$studnum} = "$lastname, $firstname";
	$sort{"$lastname$firstname$studnum"} = $studnum;
    }

    # If nobody found, show Search Form.
    if ( not %students ){ # nobody found, try again.
	print qq{<h3>$lex{Student} $lex{'Not Found'}</h3>\n};
	showSearchForm();
	print qq{</body></html>\n};
	exit;
    }


    # print list of students to select...
    $sth = $dbh->prepare("select count(*) from attend where studentid = ?");


    print qq{<h1>$lex{Select} $lex{Student}</h1>\n};
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
    foreach my $key ( sort keys %sort ) {
	my $studnum = $sort{$key};

	# Check for attendance.
	$sth->execute($studnum);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth->fetchrow;

	print qq{<tr><td>$students{$studnum}</td><td>};
	print qq{<input type="radio" name="student" value="$studnum">};
	print qq{</td></tr>\n};
    }

    print qq{<tr><td colspan="2" class="cn">};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table></form>\n};

    print qq{</body></html>\n};
    
    exit;

} # End of Sub doSearch



#-----------------
sub showSearchForm {
#-----------------
    
    print qq{<p><div style="font-size:130%;padding:1em 0 0.3em 0;">};
    print qq{$lex{Search} $lex{'Student Attendance'}</div>\n};
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<input type="text" name="student" size="30">\n};
    print qq{<input type="submit" value="$lex{Search}"><br>};
    print qq{$lex{'Last,First/Last/Initials/Studnum'}\n};
    print qq{</form></p>\n};

}
