#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Top' => 'Top',
	   'View' => 'View',
	   'Attendance' => 'Attendance',
	   'Start' => 'Start',
	   'End' => 'End',
	   'Records' => 'Records',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Reason' => 'Reason',
	   'Period' => 'Period',
	   'Subject' => 'Subject',
	   'Grade' => 'Grade',
	   'Error' => 'Error',
	   'Start of Year' => 'Start of Year',
	   'Current Date' => 'Current Date',
	   'No Records Found' => 'No Records Found',
	   'Error' => 'Error',
	   'Blank=All' => 'Blank=All',
	   'Continue' => 'Continue',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Select' => 'Select',
	   'Homeroom' => 'Homeroom',

	   );

use DBI;
use CGI;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = qq{$lex{View} $lex{Attendance}};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{</head><body style="margin:1em;"><a name="top"></a>\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showAttendance();

}



#-----------------
sub showStartPage {
#-----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td></td><td><input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{<tr><td class="bra">$lex{Select}</td><td class="la">};
    print qq{<select name="grouptype"><option value="grade">$lex{Grade}</option>\n};
    print qq{<option value="homeroom">$lex{Homeroom}</option></select> \n};

    print qq{ <input type="text" name="groupvalue" size="8">\n};
    print qq{$lex{'Blank=All'}</td></tr>\n};

    # Get Dates
    print qq{<tr><td class="bra">$lex{'Start Date'}</td><td class="la">};
    print qq{<input type="text" name="startdate" id="startdate" size="10">\n};
    print qq{<button type="reset" id="start_trigger">...</button>\n};

    print qq{<tr><td class="bra">$lex{'End Date'}</td><td class="la">};
    print qq{<input type="text" name="enddate" id="enddate" size="10">\n};
    print qq{<button type="reset" id="end_trigger">...</button>\n};

    print qq{<tr><td></td><td><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table></form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
	 inputField  : "startdate",
	 ifFormat    : "%Y-%m-%d",
	 button      : "start_trigger",
	 singleClick : false,
	 step : 1
     });

     Calendar.setup({
	 inputField  : "enddate",
	 ifFormat    : "%Y-%m-%d",
	 button      : "end_trigger",
	 singleClick : false,
	 step : 1
     });
     </script>\n};
    
    print qq{</body></html>\n};

    exit;

} # end of showStartPage



#-----------------
sub showAttendance {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $group = $arr{grouptype};

    # Now Setup the Dates.
    if ( $arr{startdate} ) {
	my ($year,$mo,$day) = split /-/, $arr{startdate};
	$startdate = "$month[$mo] $day, $year";
    } else {
	$startdate = $lex{'Start of Year'};
    }


    if ( $arr{enddate} ) {
	my ($eyear, $emo, $eday) = split /-/, $arr{enddate};
	$enddate = "$month[$emo] $eday, $eyear";
    } else {
	$enddate = $lex{'Current Date'};
    }

    my $select;
    if ( $arr{startdate}  and  $arr{enddate} ) {
	$select = " and to_days(a.absdate) >= to_days('$arr{startdate}') 
         and to_days(a.absdate) <= to_days('$arr{enddate}') ";
	# Otherwise, there is one or both are not defined.
    } elsif ( $arr{enddate} ) {
	$select = " and to_days(a.absdate) <= to_days('$arr{enddate}')";
    } elsif ($arr{startdate}) {
	$select = " and to_days(a.absdate) >= to_days('$arr{startdate}')";
    }


    my $sth = $dbh->prepare("select a.attid, a.studentid, a.absdate, a.reason, a.period, 
     a.subjsec, s.lastname, s.firstname from attend as a, student as s 
     where a.studentid = s.studnum and  s.$group = ? $select 
     order by a.absdate desc, s.lastname, s.firstname, a.period");

    $sth->execute( $arr{groupvalue} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}

    my $rows = $sth->rows;

    print qq{<div style="margin:1em 5em;padding:0.5em;">\n};
    print qq{<b>$lex{Start}</b> $startdate <b>$lex{End}</b> $enddate \n};
    print qq{<b>$lex{Records}:</b> $rows</div>\n};


    if ( $rows < 1 ) {
	print qq{<h3>$lex{'No Records Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }


    print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
    print qq{<tr><th>$lex{Name}</th><th>$lex{Date}</th><th>};
    print qq{$lex{Reason}</th><th>$lex{Period}</th><th>$lex{Subject}</th></tr>\n};

    my $colcolor = 'blue'; # tr colors are blue or gray;
    my $currdate = -1;

    for ( my $i=1; $i <= $rows; ++$i ) {
	my ($attid, $studnum, $absdate, $reason, $period, $subjsec, 
	    $lastname, $firstname) = $sth->fetchrow;
	$prevdate = $currdate;
	$currdate = $absdate;
	if ( $prevdate ne $currdate ){
	    if ($colcolor eq 'blue' ){ $colcolor = 'gray'; } else { $colcolor = 'blue';}
	}

	print qq{<tr class="$colcolor">};
	print qq{<td><b>$lastname</b>, $firstname</td><td>$absdate</td>};
	print qq{<td>$reason</td><td>$period</td><td>$subjsec</td></tr>\n};

    }

    print qq{</table>};
    print qq{<p>[ <a href="$tchpage">$lex{Main}</a> | <a href="#top">$lex{Top}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;
}
