#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Delete Any writing scores 

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Scores' => 'Scores',
	   'Delete' => 'Delete',
	   'Continue' => 'Continue',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Record(s) Deleted' => 'Record(s) Deleted',
	   'Admin Password' => 'Admin Password',
	   'Not Allowed' => 'Not Allowed',
	   'Grade' => 'Grade',
	   'Author' => 'Author',
	   'Close' => 'Close',

	   );

use DBI;
use CGI;


my $self = 'wrDelete.pl';


my @time = localtime(time);
my $year = $time[5] + 1900;
my $month = $time[4] + 1;
my $currdate = "$year-$month-$time[3]";


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. "$self: $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset);
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Check for WR access code
my $sth = $dbh->prepare("select field_value from staff_multi 
  where field_name = 'access' and userid = ?");
$sth->execute( $userid );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

my $accessWR;
while ( my $val = $sth->fetchrow ) {
    if ( uc $val eq 'WR' ) { $accessWR = 1; }
}


# Page Header
my $title = "$lex{Delete} Writing $lex{Scores}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

print qq{$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    selectScore();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteScore();
}


#-------------
sub selectScore {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = $arr{id};

    # Get Writing Record 
    my $sth = $dbh->prepare("select * from write_scores where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my $tauthor = $ref->{tauthor};

=head    
    # Access Controls
    my $failflag;
    if ( not $allow_author and not $allow_wr ) { $failflag = 1; } # nobody deletes
    elsif ( $allow_author and $tauthor ne $userid ) { $failflag = 1; } # not author

    if ( $allow_cma and $accesscma ) { $failflag = 0; } # allow dra override of author failure
    if ( $adminpassword eq $arr{adminpassword} ) { $failflag = 0; } # allow admin override
    if ( $failflag ) {
	print qq{<h3>$lex{Delete} $lex{'Not Allowed'}</h3>\n};

	print qq{<form action="$self" method="post"> \n};
	print qq{<input type="hidden" name="id" value="$id">\n};
	print qq{<p>$lex{'Admin Password'} <input type="text" size="10" name="adminpassword">\n};
	print qq{<input type="submit" value="$lex{Continue}">\n};
	print qq{</p></form>\n};
	print qq{</body></html>\n};
	exit;
    }
=cut


    # Get Student Name
    my $sth1 = $dbh->prepare("select lastname, firstname, grade from studentall where studnum = ?");
    $sth1->execute( $ref->{studnum} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ( $lastname, $firstname,$grade ) = $sth1->fetchrow;
    # print qq{Name: $lastname $firstname<br>\n};

    # Print Form Heading
    print qq{<form action="$self" method="post"> \n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="id" value="$id">\n};


    print qq{<div><input type="submit" value="$lex{Delete} Score"></div>\n};

    # Print Table Header and Heading values
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    
    # Delete
    
    print qq{<tr><td class="bra">$lex{Name}</td><td>$firstname $lastname</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Grade}</td><td class="la">$ref->{tgrade}</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Date}</td><td class="la">$ref->{tdate}</td></tr>\n}; 
    print qq{<tr><td class="bra">$lex{Author}</td><td class="la">$ref->{tauthor}</td></tr>\n}; 

    print qq{<tr><td class="bra">Score</td><td class="la">$ref->{score}</td></tr>\n}; 

    print qq{</table>\n};
    print qq{<div><input type="submit" value="$lex{Delete} Score"></div>\n};

    print qq{</form></body></html>\n};

    exit;

}


#--------------
sub deleteScore {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = $arr{id};

    # Delete Test
    $sth = $dbh->prepare("delete from write_scores where id = ?");  
    $sth->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$lex{'Record(s) Deleted'}</h3>\n};

    print qq{<p><form><input type="hidden" name="none">\n};
    print qq{<input type="button" value="$lex{Close} this Tab" };
    print qq{onClick="parent.close()"></form></p>};

    print qq{</body></html>\n};

    exit;

}
