#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  Compare variables in the meta table from 2 different DB's.

use DBI;

my ($password, $db1, $db2) = @ARGV;

if ( not $password ) {
    print "Usage: comparemeta password db1 db2\n";
    exit;
}

$user = 'root';
$dbtype = 'mysql';


my $dsn1 = "DBI:$dbtype:dbname=$db1";
my $dbh1 = DBI->connect($dsn1,$user,$password);

my $dsn2 = "DBI:$dbtype:dbname=$db2";
my $dbh2 = DBI->connect($dsn2,$user,$password);


# Get  conf_system data - db1
my (%conf1, %confdata1 );

my $sth = $dbh1->prepare("select * from meta");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf1{$ref->{fieldid}} = $ref->{tableid};
    $confdata1{$ref->{fieldid}} = $ref;
}


# Get  conf_system data - db2
my (%conf2, %confdata2 );

my $sth = $dbh2->prepare("select * from meta");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf2{$ref->{fieldid}} = $ref->{tableid};
    $confdata2{$ref->{fieldid}} = $ref;
}



# Assemble master hash to iterate over
my %master = %conf1;
foreach my $key ( keys %conf2 ) {
    if ( not $master{$key} ) {
	$master{$key} = $tempconf{$key};
    }
}



# Loop over all hash values
foreach my $key ( keys %master ) {
    if ( $conf1{$key} eq $conf2{$key} ) {
	my %r1 = %{ $confdata1{$key} };
	my %r2 = %{ $confdata2{$key} };

	# Compare 
	if ( $confdata1{$key}->{viewsize} ne $confdata2{$key}->{viewsize} ) {
	    print "$conf1{$key} - $r1{fieldid}: Viewsize differs:\n";
	    print "$db1: $confdata1{$key}->{viewsize}\n$db2: $confdata2{$key}->{viewsize}\n\n";
	}
	if ( $confdata1{$key}->{formtype} ne $confdata2{$key}->{formtype} ) {
	    print "$conf1{$key} - $r1{fieldid}: Formtype differs:\n";
	    print "$db1: $confdata1{$key}->{formtype}\n$db2: $confdata2{$key}->{formtype}\n\n";
	}
	if ( $confdata1{$key}->{defaultvalue} ne $confdata2{$key}->{defaultvalue} ) {
	    print "$conf1{$key} - $r1{fieldid}: Defaultvalue differs:\n";
	    print "$db1: $confdata1{$key}->{defaultvalue}\n$db2: $confdata2{$key}->{defaultvalue}\n\n";
	}
	if ( $confdata1{$key}->{fieldname} ne $confdata2{$key}->{fieldname} ) {
	    print "$conf1{$key} - $r1{fieldid}: Fieldname differs:\n";
	    print "$db1: $confdata1{$key}->{fieldname}\n $db2: $confdata2{$key}->{fieldname}\n\n";
	}


	# Remove identical records
	delete $conf1{$key};
	delete $conf2{$key};
    }
}


if ( %conf1 ) {
    print "\n$db1: Remaining Meta Keys:\n";
    foreach my $key ( sort keys %conf1 ) {
	print "$key\n";
    }
} else {
    print "$db1: No Remaining Meta Keys\n";
}

if ( %conf2 ) {
    print "\n$db2: Remaining Meta Keys:\n";
    foreach my $key ( sort keys %conf2 ) {
	print "$key\n";
    }
} else {
    print "$db2: No Remaining Meta Keys\n";
}


print"Done!\n";
