#!/usr/bin/perl

use DBI;

my $user = 'root';
my ($password, $db, $table1, $table2) = @ARGV;
# db is the databse of interest, even though we don't open it, but rather the information_schema one.

if ( not $password ) {
    print "Usage: ./comparetable.pl password database table1 table2\n";
    exit;
}


my $database = 'information_schema';
my $dsn = "DBI:mysql:$database";
my $dbh = DBI->connect($dsn,$user,$password);

my (%master, %table1, %table2);

my $sth = $dbh->prepare("select column_name, column_type, character_maximum_length 
  from columns where table_schema = ? and table_name = ?");


# Table 1
$sth->execute( $db, $table1 );
while ( my  ( $cname, $ctype, $clength ) = $sth->fetchrow ) {
    $table1{$cname} = "$ctype:$clength";
    $master{$cname} = 1;
}


#foreach my $field ( sort keys %table1 ) {
#    my ($type,$length) = split(':', $table1{$field});
#    print qq{$field / $type / $length\n};
#}

# Table 2
$sth->execute( $db, $table2 );
while ( my  ( $cname, $ctype, $clength ) = $sth->fetchrow ) {
    $table2{$cname} = "$ctype:$clength";
    $master{$cname} = 1;
}


# Now remove the common fields to leave the differences.
foreach my $field ( sort keys %master ) {
    
    my $tb1val = $table1{$field};
    my ($tb1_type,$tb1_length) = split(':', $tb1val );

    my $tb2val = $table2{$field};
    my ($tb2_type,$tb2_length) = split(':', $tb2val );
    
    if ( $tb1val eq $tb2val ) { # delete duplicates
	delete $table1{$field};
	delete $table2{$field};
    }
}


# Now Display the values left;
my $first = 0;
print "\n\nTable 1 - $table1\n";
if ( %table1 ) {
    foreach my $field ( sort keys %table1 ) {
	my $tb1val = $table1{$field};
	my ($tb1_type,$tb1_length) = split(':', $tb1val );

#    if ( $first ) {
#		print qq{<h3>Database 1 - $db1</h3>\n};
#		print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
#		print qq{<tr><th>Table</th><th>Column</th><th>Type</th>\n};
#		$first = 0;
#	    }

#	    print qq{<tr><td>$tbl</td><td>$col</td><td>$db1_type - $db1_length</td></tr>\n};
	print qq{$field\t$tb1val\t$tb1_type - $tb1_length\n};
    }
} else {
    print qq{No Fields Left\n};
}

    
my $first = 0;
print "\n\nTable 2 - $table2\n";
if ( %table2 ) {
    foreach my $field ( sort keys %table2 ) {
	my $tb2val = $table2{$field};
	my ($tb2_type,$tb2_length) = split(':', $tb2val );

#    if ( $first ) {
#		print qq{<h3>Database 1 - $db1</h3>\n};
#		print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
#		print qq{<tr><th>Table</th><th>Column</th><th>Type</th>\n};
#		$first = 0;
#	    }

#	    print qq{<tr><td>$tbl</td><td>$col</td><td>$db1_type - $db1_length</td></tr>\n};
	print qq{$field\t$tb2val\t$tb2_type - $tb2_length\n};
    }
} else {
    print qq{No Fields Left\n};
}
