#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  Compare variables in the conf_system from 2 different DB's, AND ADD
#  the missing values from one into the other.

use DBI;

my ($password, $db1, $db2) = @ARGV;

if ( not $password ) {
    print "Usage: ./compareconfsystem.pl rootDBpassword sourcedb destinationdb\n";
    exit;
}

my $user = 'root';

my $dbtype = 'mysql';
my $dsn1 = "DBI:$dbtype:dbname=$db1";
my $dbh1 = DBI->connect($dsn1,$user,$password);

my $dsn2 = "DBI:$dbtype:dbname=$db2";
my $dbh2 = DBI->connect($dsn2,$user,$password);


# Get  conf_system data - db1
my (%conf1, %confdata1 );

my $sth = $dbh1->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf1{$ref->{dataname}} = $ref->{filename};
    $confdata1{$ref->{dataname}} = $ref;
}


# Get  conf_system data - db2
my (%conf2, %confdata2 );

my $sth = $dbh2->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf2{$ref->{dataname}} = $ref->{filename};
    $confdata2{$ref->{dataname}} = $ref;
}



# Assemble master hash to iterate over
my %master = %conf1;
foreach my $key ( keys %conf2 ) {
    if ( not $master{$key} ) {
	$master{$key} = $tempconf{$key};
    }
}



# Loop over all hash values
foreach my $key ( keys %master ) {
    if ( $conf1{$key} eq $conf2{$key} ) {

	# Compare sectionname, sequenceval, datatype
	if ( $confdata1{$key}->{sectionname} ne $confdata2{$key}->{sectionname} ) {
	    print "K:$key $conf1{$key}: Sectionname differs: DB1:$confdata1{$key}->{sectionname} DB2:$confdata2{$key}->{sectionname}\n";
	}
	if ( $confdata1{$key}->{sequenceval} ne $confdata2{$key}->{sequenceval} ) {
	    print "K:$key $conf1{$key}: SequenceVal differs: DB1:$confdata1{$key}->{sequenceval} DB2:$confdata2{$key}->{sequenceval}\n";
	}
	if ( $confdata1{$key}->{datatype} ne $confdata2{$key}->{datatype} ) {
	    print "K:$key $conf1{$key}: Datatype differs: DB1:$confdata1{$key}->{datatype} DB2:$confdata2{$key}->{datatype}\n";
	}

	# Remove identical records
	delete $conf1{$key};
	delete $conf2{$key};
    }
}


my $sth1 = $dbh1->prepare("select * from conf_system where dataname = ?");



if ( %conf1 ) {
    print "\nSource DB Remaining Configuration Keys (to be added to Destination Conf System):\n";
    foreach my $key ( sort keys %conf1 ) {  # these values go into the other database.

	# Get the information from source db. Add to dest db.
	$sth1->execute( $key );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %sr = %$ref;
	print "KEY:$key Source:$sr{dataname} - $sr{datavalue} - SEC:$sr{sectionname}\n";

	delete $sr{id};
	my (@keys, @values, @qst);
	foreach my $k ( keys %sr ) {
	    push @keys, $k;
	    push @values, $sr{$k};
	    push @qst, '?';
	}

	my $keystr = join(',', @keys);
	my $qststr = join(',', @qst);
	# my $valstr = join(',', @values);
	
	my $sth2 = $dbh2->prepare("insert into conf_system ($keystr) values($qststr)");
	$sth2->execute( @values );
	
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	print "\nInserted: $key\n";


    }
    
} else {
    print "Source DB:  No Remaining Configuration Keys\n";
}


if ( %conf2 ) {
    print "\nDestination DB: Remaining Configuration Keys:\n";
    foreach my $key ( sort keys %conf2 ) {
	print "$key\n";
    }
} else {
    print "Destination DB: No Remaining Configuration Keys\n";
}


print"Done!\n";
