#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  Compare variables in the conf_system from 2 different DB's, AND 
#  the sectionname and sequence from one to the other.

# Uncomment the lines below to make the update.

use DBI;

my ($password, $db1, $db2) = @ARGV;

if ( not $password ) {
    print "Usage: ./compareconfsystemUpdateSeq.pl rootDBpassword sourcedb destinationdb\n";
    exit;
}

my $user = 'root';

my $dbtype = 'mysql';
my $dsn1 = "DBI:$dbtype:dbname=$db1";
my $dbh1 = DBI->connect($dsn1,$user,$password);

my $dsn2 = "DBI:$dbtype:dbname=$db2";
my $dbh2 = DBI->connect($dsn2,$user,$password);


my $sth2 = $dbh2->prepare("update conf_system set sequenceval = ?, sectionname = ? where dataname = ?");


# Source Data
my $sth = $dbh1->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $sref = $sth->fetchrow_hashref ) {
    my %sr = %$sref;
    print qq{$sr{sequenceval} - $sr{sectionname} - $sr{dataname}\n};

# UNCOMMENT the lines below to make the updates....    
#    $sth2->execute($sr{sequenceval}, $sr{sectionname}, $sr{dataname} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

}    


print"Done!\n";
