#!/usr/bin/perl
#  Copyright 2001-2017 Leslie Richardson

#  Compare variables in the conf_system within single database, where one is called 'temp_conf_system' and other is normal conf_system table.

use DBI;

my ($password, $db ) = @ARGV;

if ( not $password ) {
    print "Compare a single database with a meta_temp table and a normal meta table\n";
    print "Usage: ./comparemeta2.pl password dbase\n";
    exit;
}

$user = 'root';
$dbtype = 'mysql';


my $dsn1 = "DBI:$dbtype:dbname=$db";
my $dbh1 = DBI->connect($dsn1,$user,$password);


# Get  meta data - normal meta
my (%conf1, %confdata1 );

my $sth = $dbh1->prepare("select * from meta");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf1{$ref->{fieldid}} = $ref->{tableid};
    $confdata1{$ref->{fieldid}} = $ref;
}


# Get  meta_temp data
my (%conf2, %confdata2 );

my $sth = $dbh1->prepare("select * from meta_temp");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf2{$ref->{fieldid}} = $ref->{tableid};
    $confdata2{$ref->{fieldid}} = $ref;
}



# Assemble master hash to iterate over
my %master = %conf1;
foreach my $key ( keys %conf2 ) {
    if ( not $master{$key} ) {
	$master{$key} = $tempconf{$key};
    }
}



# Loop over all hash values
foreach my $key ( keys %master ) {
    if ( $conf1{$key} eq $conf2{$key} ) {
	my %r1 = %{ $confdata1{$key} };
	my %r2 = %{ $confdata2{$key} };

	# Compare 
	if ( $confdata1{$key}->{viewsize} ne $confdata2{$key}->{viewsize} ) {
	    print "$key - $conf1{$key}-$r1{fieldid}: Viewsize differs:\n";
	    print "$key - Meta: $confdata1{$key}->{viewsize}\nTEMP: $confdata2{$key}->{viewsize}\n\n";
	}
	if ( $confdata1{$key}->{formtype} ne $confdata2{$key}->{formtype} ) {
	    print "$key - $conf1{$key}-$r1{fieldid}: Formtype differs:\n";
	    print "$key - Meta: $confdata1{$key}->{formtype}\nTEMP: $confdata2{$key}->{formtype}\n\n";
	}
	if ( $confdata1{$key}->{defaultvalue} ne $confdata2{$key}->{defaultvalue} ) {
	    print "$key - $conf1{$key}-$r1{fieldid}: Defaultvalue differs:\n";
	    print "$key - Meta: $confdata1{$key}->{defaultvalue}\nTEMP: $confdata2{$key}->{defaultvalue}\n\n";
	}
	if ( $confdata1{$key}->{fieldname} ne $confdata2{$key}->{fieldname} ) {
	    print "$key - $conf1{$key}-$r1{fieldid}: Fieldname differs:\n";
	    print "$key - Meta: $confdata1{$key}->{fieldname}\n TEMP: $confdata2{$key}->{fieldname}\n\n";
	}

	# Remove identical records
	delete $conf1{$key};
	delete $conf2{$key};
    }
}


if ( %conf1 ) {
    print "\nNormal Meta Remaining Configuration Keys (new records):\n";
    foreach my $key ( sort keys %conf1 ) {
	print "$key - $conf1{$key}\n";
    }
} else {
    print "META - No Remaining Configuration Keys\n";
}

if ( %conf2 ) {
    print "\nMETA TEMP Remaining Configuration Keys (old records, no longer used?):\n";
    foreach my $key ( sort keys %conf2 ) {
	print "$key - $conf2{$key}\n";
    }
} else {
    print "META TEMP No Remaining Configuration Keys\n";
}


print"\nDone!\n";
