#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson

#  Update variables in the temp_conf_system within single database, where
#  one is called 'temp_conf_system' and other is normal conf_system
#  table.

use DBI;

my ($password, $db ) = @ARGV;

if ( not $password ) {
    print "Update temp_conf_system table from normal conf_system table\n";
    print "Usage: ./updateTempConf.pl password dbase\n";
    exit;
}

$user = 'root';
$dbtype = 'mysql';


my $dsn1 = "DBI:$dbtype:dbname=$db";
my $dbh1 = DBI->connect($dsn1,$user,$password);


# Get  conf_system data - normal conf system table
my (%conf1, %confdata1 );

my $sth = $dbh1->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf1{$ref->{dataname}} = $ref->{filename};
    $confdata1{$ref->{dataname}} = $ref;
}


# Get  temp_conf_system data
my (%conf2, %confdata2 );

my $sth = $dbh1->prepare("select * from temp_conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $conf2{$ref->{dataname}} = $ref->{filename};
    $confdata2{$ref->{dataname}} = $ref;
}


# Assemble master hash to iterate over
my %master = %conf1;
foreach my $key ( keys %conf2 ) {
    if ( not $master{$key} ) {
	$master{$key} = $tempconf{$key};
    }
}

my $sth1 = $dbh1->prepare("update temp_conf_system set sectionname = ?  where dataname = ?");
my $sth2 = $dbh1->prepare("update temp_conf_system set sequenceval = ?  where dataname = ?");
my $sth3 = $dbh1->prepare("update temp_conf_system set datatype = ?  where dataname = ?");

# Loop over all hash values
foreach my $key ( keys %master ) {
    if ( $conf1{$key} eq $conf2{$key} ) {

	# Compare sectionname, sequenceval, datatype
	if ( $confdata1{$key}->{sectionname} ne $confdata2{$key}->{sectionname} ) {
	    print "$conf1{$key}: Sectionname differs: DB1: $confdata1{$key}->{sectionname} DB2: $confdata2{$key}->{sectionname}\n";
	    $sth1->execute( $confdata1{$key}->{sectionname}, $key );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	}

	if ( $confdata1{$key}->{sequenceval} ne $confdata2{$key}->{sequenceval} ) {
	    print "$conf1{$key}: SequenceVal differs: DB1: $confdata1{$key}->{sequenceval} DB2: $confdata2{$key}->{sequenceval}\n";
	    $sth2->execute( $confdata1{$key}->{sequenceval}, $key );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	}

	if ( $confdata1{$key}->{datatype} ne $confdata2{$key}->{datatype} ) {
	    print "$conf1{$key}: Datatype differs: DB1: $confdata1{$key}->{datatype} DB2: $confdata2{$key}->{datatype}\n";
	    $sth3->execute( $confdata1{$key}->{datatype}, $key );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	}

	# Remove identical records
	delete $conf1{$key};
	delete $conf2{$key};
    }
}


if ( %conf1 ) {
    print "\nNormal conf_system Remaining Configuration Keys (new records):\n";
    foreach my $key ( sort keys %conf1 ) {
	print "$key - $conf1{$key}\n";
    }
} else {
    print "DB1 No Remaining Configuration Keys\n";
}

if ( %conf2 ) {
    print "\nTemp Conf System Remaining Configuration Keys (old records, no longer used?):\n";
    foreach my $key ( sort keys %conf2 ) {
	print "$key - $conf2{$key}\n";
    }
} else {
    print "DB2 No Remaining Configuration Keys\n";
}


print"\nDone!\n";
