#!/usr/bin/perl

use DBI;
use CGI;
use Text::CSV_XS;


$user = "root";
$password = "PASSWORD";
$dbase = "chiefnapew";
my $studentnumber = 10561;
 
$csv = Text::CSV_XS->new();

%monlkup = ("JAN",1,"FEB",2,"MAR",3,"APR",4,"MAY",5,"JUN",6,"JUL",7,"AUG",
	    8,"SEP",9,"OCT",10,"NOV",11,"DEC",12);


$dsn = "DBI:mysql:$dbase";
$dbh = DBI->connect($dsn,$user,$password);


$ARGV = shift @ARGV;
open (INFILE,"<$ARGV") || die "Cannot open input file";

my $count = 1;

my $sth1 = $dbh->prepare("insert into student (studnum, lastname, firstname, grade, birthdate ) 
      values (?, ?, ?, ?, ?)");


while (<INFILE>){
    my @s;
    if ($csv->parse($_)) {

#	( $fullname, $grade,$transport_am_route, $foip, $mass, $religion, 
#	  $dental, $lice, $bc, $allergies, $treaty, $healthid, $cust, $ipp, $birthdate) = $csv->fields;

	@s = $csv->fields;

    }

    # Sucessmaker number (first value
    my $success = $s[0];


    # Name
    my $lastname = $s[18];
    $lastname =~ s/\(.+\)//;

    my @name = split(' ', $s[19] );
    my $firstname = $name[0];

    # Birthdate;
    my $birthdate;
    if ( $s[6] ) {
	my @bd = split('/', $s[6]); #MM/DD/YY
	$birthdate = "$bd[2]-$bd[0]-$bd[1]";
    } else {
	print "No Birthdate for: $firstname $lastname\n";
	next;
    }
    if ( $birthdate eq '0000-00-00' ) {
	print "Blank Birthdate: $firstname $lastname\n";
    }


    # Father
    my %f; 
    if ( $s[14] ) { # lastname;
	$f{lastname} = $s[14];
	$f{firstname} = $s[15];
	$f{homephone} = $s[16];
	$f{address} = $s[17];
	$f{city} = $s[20];
	$f{prov} = $s[21];
	$f{pcode} = $s[22];
    }

    # Mother
    my %m; # mother
    if ( $s[23] ) {
	$m{lastname} = $s[23];
	$m{firstname} = $s[24];
	$m{homephone} = $s[25];
	$m{address} = $s[26];
	$m{city} = $s[27];
	$m{prov} = $s[28];
	$m{pcode} = $s[29];
    }

    # Guardian
    my %g;
    if ( $s[30]) {
	$g{lastname} = $s[30];
	$g{firstname} = $s[31];
	$g{homephone} = $s[32];
    }


=head
    if ( %f ) {
	print "Father:";
	foreach my $key ( sort keys %f ) { print "|K:$key V:$f{$key} "; }
	print "\n";
    }
    if ( %m ) {
	print "Mother:";
	foreach my $key ( sort keys %m ) { print "|K:$key V:$m{$key} "; }
	print "\n";
    }
    if ( %g ) {
	print "Guardian:";
	foreach my $key ( sort keys %g ) { print "|K:$key V:$g{$key} "; }
	print "\n";
    }
    print "\n";
=cut


    my $sth = $dbh->prepare("select studnum, firstname from studentall where lastname = ? and birthdate = ?");
    $sth->execute( $lastname, $birthdate );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ($studnum, $fn) = $sth->fetchrow;
    my %par = ('M' => 1, 'F' => 1, 'G' => 1 );


    if ( not $studnum ) { # add a new record, minimal fields.

	$sth1->execute( $studentnumber, $lastname, $firstname, $s[3], $birthdate );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	$studnum = $studentnumber;

	$studentnumber++;

    }



    #if ( $fn ne $firstname ) {
    #    print "No Match: $fn - $firstname  || $lastname ($studnum)\n";
    #}

    if ( %f ) { # insert father info.
	    
	my $sth1 = $dbh->prepare("update student set relation1 = 'Father', 
          par1_lastname = ?, par1_firstname = ?, hphone1 = ?, 
          address1 = ?, city1 = ?, prov1 = ?, pcode1 = ? where studnum = ?");
	$sth1->execute($f{lastname}, $f{firstname},$f{homephone},$f{address},$f{city},$f{prov},$f{pcode}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	delete $par{F};
    } elsif ( %m ) { # mother insert

	my $sth1 = $dbh->prepare("update student set relation1 = 'Mother', 
          par1_lastname = ?, par1_firstname = ?, hphone1 = ?, 
          address1 = ?, city1 = ?, prov1 = ?, pcode1 = ? where studnum = ?");
	$sth1->execute($m{lastname}, $m{firstname},$m{homephone},$m{address},$m{city},$m{prov},$m{pcode}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	delete $par{M};

    } elsif ( %g ) { # guardian
	my $sth1 = $dbh->prepare("update student set relation1 = 'Guardian', 
          par1_lastname = ?, par1_firstname = ?, hphone1 = ? where studnum = ?");
	$sth1->execute($g{lastname}, $g{firstname},$g{homephone}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	delete $par{G};

    }


    # Now Secondary Parent
    if ( %f and $par{F} ) { # insert father info.
	    
	my $sth1 = $dbh->prepare("update student set relation2 = 'Father', 
          par2_lastname = ?, par2_firstname = ?, hphone2 = ?, 
          address2 = ?, city2 = ?, prov2 = ?, pcode2 = ? where studnum = ?");

	$sth1->execute($f{lastname}, $f{firstname},$f{homephone},$f{address},$f{city},$f{prov},$f{pcode}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( %m and $par{M} ) { # mother insert

	my $sth1 = $dbh->prepare("update student set relation2 = 'Mother', 
          par2_lastname = ?, par2_firstname = ?, hphone2 = ?, 
          address2 = ?, city2 = ?, prov2 = ?, pcode2 = ? where studnum = ?");

	$sth1->execute($m{lastname}, $m{firstname},$m{homephone},$m{address},$m{city},$m{prov},$m{pcode}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( %g and $par{G} ) { # guardian

	my $sth1 = $dbh->prepare("update student set relation2 = 'Guardian', 
          par2_lastname = ?, par2_firstname = ?, hphone2 = ? where studnum = ?");

	$sth1->execute($g{lastname}, $g{firstname},$g{homephone}, $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    }


    # Insert Emergency Contacts.
    my $sth1 = $dbh->prepare("update student set emname = ?, emhphone = ? where studnum = ?");
    my ($index1, $index2);
    if  ( $s[38] =~ m/\d/ ) { # if a digit, then shift right.
	$index1 = 39; $index2 = 40;
    } else {
	$index1 = 38; $index2 = 39;
    }

    $sth1->execute( $s[$index1], $s[$index2], $studnum);
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    # Identifiers.
    my $provnum = $s[42];
    $provnum =~ s/-//g;
    $provnum =~ s/\s+//g;
    if ( length($provnum) != 9 ) { $provnum = ''; }

    my $healthid = $s[40];
    $healthid =~ s/-//g;
    $healthid =~ s/\s+//g;
    $healthid =~ s/\(//g;
    $healthid =~ s/\)//g;
    if ( length($healthid) != 9 ) { $healthid = ''; }

    my $treaty = $s[45];
    $treaty =~ s/-//g;
    $treaty =~ s/\s+//g;

    if ( $treaty =~ m/\D/ ) { # non digits
	$treaty = $s[46];
    }
    $treaty =~ s/-//g;
    $treaty =~ s/\s+//g;


    my $sth1 = $dbh->prepare("update student set provnum = ?, healthid = ?, treaty = ? where studnum = ?");
    $sth1->execute( $provnum, $healthid, $treaty, $studnum);
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


}

print "Done!\n\n";
