#!/usr/bin/perl

# This version installs the teacher configuration setup so
# that teachers use their own userid's and passwords to log into the
# teacher site. It is also multisite capable (meaning that it can
# setup schools in their own directory below /opt/openadmin). This
# simplifies the management of multiple schools (and school divisions)
# running on the same server.

# Configuration Values

# Uncomment to place schools in this subdirectory of Install Directory
# my $subdir = 'tcef'; # no slashes, no spaces please, like 'tcef'.

# Change this value to place your installation somewhere else.

my $baseDirectory = '/opt/openadmin'; # full path
my $subdir = '';  # if desired to have any directory below, like opt/openadmin/batc

## NOT USED Anymore: Single password for teacher site installation version.
## NOT USED Anymore: my $apacheConfFile = '../install-apache2conf/apache2-debian.conf';

# Apache 2.2. Teacher site with separate userid/password version
# my $apacheConfFile = '../install-apache2conf/apache22-debian.conf';
# Apache 2.4 Teacher site
my $apacheConfFile = '../install-apache2conf/apache24-debian.conf';


my $apacheOutputDir = '/etc/apache2/sites-available';

my $a2ensite = '/usr/sbin/a2ensite';
my $a2enmod = '/usr/sbin/a2enmod';
my $apache2ctl = '/usr/sbin/apache2ctl';
my $htpasswd = '/usr/bin/htpasswd';

my $dbtype = 'MariaDB';
my $dbfile = 'fulldbase.sql';

use DBI;
use Cwd;

# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}



# include subdirectory.
$installDirectory = $baseDirectory;
if ( $subdir ) {
    $installDirectory = $installDirectory. '/'. $subdir;
}
print "\nInstallation Directory: $installDirectory\n\n";

# Check for existing installation directory; directory below it must exist.
if ( not -e $baseDirectory ) {
    print "Creating '$baseDirectory'\n\n";
    mkdir $baseDirectory;
}

# Check for existing subdir
if ( $subdir ) { # if defined
    if ( not -e $installDirectory ) {
	print "Creating '$installDirectory'\n\n";
	mkdir $installDirectory;
    }
}


# Get schoolname
print "\nEnter School Name (single word only): ";
$schooldir = <STDIN>;
chomp $schooldir;

# strip any spaces
$schooldir =~ s/\s//g;
print "\nSchool Directory: $schooldir\n\n";


# Copy files into location.
my $error = system("cp -r ../../school  $installDirectory/$schooldir");
if ( not $error ) {
    print "Open Admin copied to $installDirectory/$schooldir\n";
}

# Change ownership
my $error = system("chown -R www-data:www-data $installDirectory/$schooldir");
if ( not $error ) {
    print "Ownership for OA files changed to www-data:www-data\n\n";
}




# Now create the database and populate it.
# Get MariaDB Root password
print "\n\nEnter Database ROOT Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "\nDatabase ROOT Password: $mysqlroot\n";

$error =  system("mysql -p$mysqlroot -u root -e \"create database $schooldir character set utf8\"");

if ( not $error ) {
    print "Database Created\n\n. Now adding tables. Please wait.\n";
}

$error =  system("mysql -p$mysqlroot -u root $schooldir < ../sql/$dbfile");
if ( not $error ) {
    print "Database Tables/Data Added\n\n";

}


# Add school userid and password for access to this school database.
print "\nEnter Desired SCHOOL Database Password: ";
$schoolmysqlpwd = <STDIN>;
chomp $schoolmysqlpwd;
print "\nSCHOOL Database Password: $schoolmysqlpwd\n";


$error =  system("mysql -p$mysqlroot -u root -e \"grant all on $schooldir.* to $schooldir\@localhost identified by '$schoolmysqlpwd'\"");
if ( not $error ) {
    print "Database user and password added\n\n";
}



# Load Apache Configuration File
unless ( open(FH, "<$apacheConfFile") ) {
	print "Cannot open $apacheConfFile: $!\n";
	die "Cannot open $apacheConfFile: $!\n";
}

# slurp in file
my $apachefile;
{ local $/; $apachefile = <FH>; close FH;}
close FH;

# Get Domain Names 
print "\nEnter Domain Name for Admin site (no http://): ";
$adminsite = <STDIN>;
chomp $adminsite;
print "Admin Site: $adminsite\n\n";


print "Enter Domain Name for Teacher site (no http://): ";
$teachersite = <STDIN>;
chomp $teachersite;
print "Teacher Site: $teachersite\n\n";


print "Enter Domain Name for Parent site (no http://): ";
$parentsite = <STDIN>;
chomp $parentsite;
print "Parent Site: $parentsite\n\n";


# Update Apache File.
$apachefile =~ s/ADMINSITENAME/$adminsite/; 
$apachefile =~ s/TEACHERSITENAME/$teachersite/;
$apachefile =~ s/PARENTSITENAME/$parentsite/;

$apachefile =~ s/INSTALLDIR/$installDirectory/g;

$apachefile =~ s/SCHOOLNAME/$schooldir/g;
$apachefile =~ s/USER/$schooldir/g; # same values for db user, database as schooldir
$apachefile =~ s/DBPASSWORD/$schoolmysqlpwd/g;


# Write Apache File into location.
unless ( open(FH, ">$apacheOutputDir/$schooldir.conf") ) {
	print "Cannot open $apacheOutputDir/$schooldir.conf: $!\n";
	die "Cannot open $apacheOutputDir/$schooldir.conf: $!\n";
}

print FH $apachefile;
close FH;


# Turn on Config, Turn on Modules, Restart Apache.
system("$a2ensite $schooldir.conf ");

system("$a2enmod include"); # turn on server side includes for date on index page.
system("$a2enmod cgi"); # turn on cgi scripting module
system("$a2enmod dbd"); # turn on dbd access (for mysql passwords)
system("$a2enmod authn_dbd"); # turn on db authentication

system("$apache2ctl configtest"); # test config

system("$apache2ctl graceful"); # gracefully restart


# Create the authorization file.
# Check for existing directory
if ( not -e '/etc/apache2/auth_users' ) {
    print "Creating '/etc/apache2/auth_users'\n\n";
    mkdir '/etc/apache2/auth_users';
}

print "\nEnter Admin Website User Id: ";
$adminuser = <STDIN>;
chomp $adminuser;
print "\nEnter Admin Website User Password: ";
$adminpassword = <STDIN>;
chomp $adminpassword;
print "\nUser:$adminuser  Password:$adminpassword\n\n";


my $authfile = $schooldir. 'admin';
my $teacherauthfile = $schooldir. 'teacher';

$error = system("$htpasswd -cb $authfile $adminuser $adminpassword");
if ( not $error ) {
    print "Apache Authorization File Created\n";
}
$error = system("mv $authfile /etc/apache2/auth_users/");
if ( not $error ) {
    print "Authorization File Moved into place.\n";
}

#$error = system("cp -f /etc/apache2/auth_users/$authfile /etc/apache2/auth_users/$teacherauthfile ");
#if ( not $error ) {
#    print "Teacher Authorization File Copied.\n";
#} else {
#    print "ERROR: Teacher Authorization File NOT copied.\n";
#}


# Now set the Local RO User Password and User Id in MariaDB.
# Removed the global ro user, since not commonly used.
print "\nEnter New Database Local Read Only User Id: ";
$mysqlrouser = <STDIN>;
chomp $mysqlrouser;
print "\nDatabase Local Read Only User Id: $mysqlrouser\n";


print "\nEnter New Database Local Read Only Password: ";
$mysqlropassword = <STDIN>;
chomp $mysqlropassword;
print "\nDatabase Local Read Only Password: $mysqlropassword\n";

$error =  system("mysql -p$mysqlroot -u root -e \"grant select on $schooldir.* to $mysqlrouser\@localhost identified by '$mysqlropassword'\"");
if ( not $error ) {
    print "Local User and Password Added\n";
}


# Now load the global conf file and reset values (using local ro values)
unless ( open(FH, "<$installDirectory/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (read): $!\n";
	die "Cannot open global.conf (read): $!\n";
}

# slurp in file
my $globalfile;
{ local $/; $globalfile = <FH>; close FH;}
close FH;

$globalfile =~ s/GLOBALUSER/$mysqlrouser/;
$globalfile =~ s/GLOBALPASSWORD/$mysqlropassword/;

$globalfile =~ s/YOURSCHOOLDATABASE/$schooldir/;
$globalfile =~ s/YOURSCHOOLNAME/$schooldir/;

unless ( open(FH, ">$installDirectory/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (write): $!\n";
	die "Cannot open global.conf (write): $!\n";
}

print FH $globalfile;
close FH;




# Now write admin.conf.root, rewrite the admin.conf
# then write all of the configuration files into location.
my $etcpath = "$installDirectory/$schooldir/etc";


# set admin.conf.root file values, and then write.
my $roottext = q{$dbase='}. $schooldir. q{';}. "\n". 
 q{$user='}. $schooldir. q{';}. "\n".
 q{$password='}. $schoolmysqlpwd. q{';}. "\n".
 q{$rouser='}. $mysqlrouser. q{';}. "\n".
 q{$ropassword='}. $mysqlropassword. q{';}. "\n".
 q{$sds_userid='SDSUSER';}. "\n". 
 q{$sds_password='SDSPASSWORD';}. "\n\n"; 


unless ( open(FH, ">$etcpath/admin.conf.root") ) {
	print "Cannot open admin.conf.root (write): $!\n";
	die "Cannot open admin.conf.root (write): $!\n";
}
print FH $roottext;
close FH;

$error =  system("cp -f $etcpath/admin.conf.root  $etcpath/admin.conf");
if ( not $error ) {
    print "COPY: admin.conf.root -> admin.conf\n\n";
}


# now open database and write configuration files
my $dsn = "DBI:$dbtype:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot );


my $sth = $dbh->prepare("select distinct filename from conf_system 
  where filename != '' and filename is not NULL order by filename");

my $sth1 = $dbh->prepare("select id, datavalue from conf_system 
  where filename = ? order by datavalue");

my $sth2 = $dbh->prepare("update conf_system 
  set datavalue = ? where id = ?");


# loop through all filenames in configuration setup
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $filename = $sth->fetchrow ) {

    if ( $filename eq 'admin' ) {

	unless ( open(FH, ">>$etcpath/admin.conf") ) {
	    print "Cannot open admin.conf (append): $!\n";
	    die "Cannot open admin.conf (append): $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	while ( my ($id, $datavalue) = $sth1->fetchrow ) {

	    if ( $datavalue =~ m/YOURSCHOOL/ ) {
		if ( $subdir ) { 
		    $datavalue =~ s!YOURSCHOOL!$subdir/$schooldir!;
		} else {
		    $datavalue =~ s/YOURSCHOOL/$schooldir/;
		}

		print "MATCH:$datavalue\n";
		$sth2->execute( $datavalue, $id ); # update database
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		print "UPDATE:$id - $datavalue\n";

	    }
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;

    } else { # all other conf files

	unless ( open(FH, ">$etcpath/$filename.conf") ) {
	    print "Cannot open $filename.conf: $!\n";
	    die "Cannot open $filename.conf: $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($id, $datavalue) = $sth1->fetchrow ) {
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;
    }

} # end of writing conf file

# Restart Apache
system("$apache2ctl restart"); # gracefully restart
print qq{Apache Webserver Restarted\n};


print "Done!\n";
