#!/usr/bin/perl

use Cwd;

# Configuration Values
# Perl Module Locations
$moddir[0] = 'CGI-Session-4.48';
$moddir[1] = 'Crypt-GeneratePassword-0.03';
$moddir[2] = 'Data-Password-1.08';
$moddir[3] = 'perl-ldap-0.65';
$moddir[4] = 'Expect-1.21';
$moddir[5] = 'FreezeThaw-0.5001';
$moddir[6] = 'GDGraph-1.47';
$moddir[7] = 'Mail-Sender-0.8.16';
$moddir[8] = 'Net-SCP-Expect-0.16';
$moddir[9] = 'Number-Format-1.73';
$moddir[10] = 'Text-CSV-1.32';
$moddir[11] = 'Text-CSV-Encoded-0.22';
$moddir[12] = 'Text-CSV_XS-1.19';
$moddir[13] = 'Time-modules-2011.0517';
$moddir[14] = 'XML-Writer-0.623';
$moddir[15] = 'XML-Writer-String-0.1';
$moddir[16] = 'Statistics-Basic-1.6611';


#$moddir[3] = 'Date-Business-1.2';

foreach my $mdir ( @moddir ) {

    my $cwd = getcwd();

    my $result = chdir "../perlmodules/$mdir";
    if ( $result ) {
	print "Changing directory to: $mdir\n";
    }

    my $error = system("perl Makefile.PL");
    if ( not $error ) {
	print "Making Makefile\n";
    } else { print "Error:$error\n"; }

    my $error = system("make");
    if ( not $error ) {
	print "Making module\n";
    } else { print "Error:$error\n"; }

    my $error = system("make test");
    if ( not $error ) {
	print "Testing Module\n";
    } else { print "Error:$error\n"; }

    my $error = system("make install");
    if ( not $error ) {
	print "Installing Module\n";
    } else { print "Error:$error\n"; }


    my $result = chdir $cwd;
    if ( $result ) {
	print "Moving to $cwd\n\n";
    } else { print "Result:$result\n"; }


}

print "Done!\n";
