#!/usr/bin/perl

# Update Version to the latest. This will ask for current school location (directory,dbase).
# Then install /opt/openadmin files and copy the etc directory into the new location. 

# Configuration Values

my $baseDirectory = '/opt/openadmin'; # full path
my $subdir = '';  # if desired to have any directory below, like opt/openadmin/batc

#-----------------------
my @smonth = ('JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC');
my @tim = localtime(time);
my $year = $tim[5] + 1900;

my $day = $tim[3];
if ( length( $day ) == 1 ) { $day = '0'. $day; }

# For Filename
#my $filecurrdate = $tim[3]. $smonth[ $tim[4] ]. $fyear;
my $filecurrdate = $year. $smonth[ $tim[4] ]. $day;

my $minutes = $tim[1];
if ( not $minutes ) { $minutes = '00'; }
my $filecurrtime = $tim[2]. $minutes;
my $tempinstalldir = 'OA11Update_'. $filecurrdate. '_'. $filecurrtime;

my $sqlfile = 'databasediff.sql';


# Apache 2.4 Teacher site
my $apacheConfFile = '../install-apache2conf/apache24-debian.conf';
my $apacheOutputDir = '/etc/apache2/sites-available';

my $a2ensite = '/usr/sbin/a2ensite';
my $a2enmod = '/usr/sbin/a2enmod';
my $apache2ctl = '/usr/sbin/apache2ctl';
my $htpasswd = '/usr/bin/htpasswd';

my $dbtype = 'mysql';
my $dbfile = 'fulldbase.sql';

use DBI;
use Cwd;

# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}


# include subdirectory.
$installDirectory = $baseDirectory;
if ( $subdir ) {
    $installDirectory = $installDirectory. '/'. $subdir;
}
print "\nCurrent Installation Directory: $installDirectory\n\n";

# Check for existing installation directory; directory below it must exist.
if ( not -e $baseDirectory ) {
    print "Creating '$baseDirectory'\n\n";
    mkdir $baseDirectory;
}

# Check for existing subdir
if ( $subdir ) { # if defined
    if ( not -e $installDirectory ) {
	print "Creating '$installDirectory'\n\n";
	mkdir $installDirectory;
    }
}


# Get School Name
print "\nEnter School Name to update (single word only): ";
$schooldir = <STDIN>;
chomp $schooldir;

# strip any spaces
$schooldir =~ s/\s//g;
print "\nSchool Directory: $schooldir\n\n";


# Get MySql Root password
print "\n\nEnter Database ROOT Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "\nDatabase ROOT Password: $mysqlroot\n";


# Get Database Handle
my $dsn = "DBI:mysql:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot );



# Check that this directory and database exist!  Exit if not!
if ( not -e $installDirectory ) {
    print "This directory does not exist! Exiting!\n\n";
    exit;
}

if ( $DBI::errstr ) { # no database.
    print qq{Database Error for $schooldir: $DBI::errstr\n};
    print qq{Exiting!\n\n};
    exit;
}


# copy files into a temporary location. ($tempinstalldir above!)
my $error = system("cp -r ../../school  $tempinstalldir"); # WAS $installDirectory/$schooldir");
if ( not $error ) {
    print "Open Admin new version temporarily copied to $tempinstalldir\n";
}


# Change ownership
my $error = system("chown -R www-data:www-data $installDirectory/$schooldir");
if ( not $error ) {
    print "Ownership for OA files changed to www-data:www-data\n\n";
}


# Now create the new database and populate it.

$error =  system("mysql -p$mysqlroot -u root -e \"create database $tempinstalldir character set utf8\"");
if ( not $error ) {
    print "TEMP Database Created\n\n. Now adding tables. Please wait.\n";
}

$error =  system("mysql -p$mysqlroot -u root $tempinstalldir < ../sql/$dbfile");
if ( not $error ) {
    print "TEMP Database Tables/Data Added\n\n";
}


#--------------------------
# Now compare the new version database and the old version database, and write out sql update file.
#--------------------------

my $user = 'root';
my $database = 'information_schema';
my $dsn = "DBI:mysql:$database";
my $dbh = DBI->connect($dsn,$user,$mysqlroot ); # mysqlroot is root password for dbase.

my (%master, %db1, %db2);

my $sth = $dbh->prepare("select table_name, column_name, column_type from columns where table_schema = ?");

my $db1 = $tempinstalldir;
my $db2 = $schooldir;

# DB 1 - source table ( New Version )
$sth->execute( $db1 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db1{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}

# DB 2 - destination table ( Old Version )
$sth->execute( $db2 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db2{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}


# Open SQL file
open(my $fh, ">", $sqlfile ) or die "Can't open $sqlfile: $!\n";

my $sth1 = $dbh->prepare("select column_name, column_type from columns 
   where table_name = ? and table_schema = ?");

# Get Primary Key
my $sth2 = $dbh->prepare("select column_name from key_column_usage
   where table_name = ? and table_schema = ?");



# Do the table analysis and then remove/add tables and update %master, etc. hashes
foreach my $tbl ( keys %master ) {
    if ( $db1{$tbl} and not $db2{$tbl} ) {
	# we have to add the entire table for the db2 database
	
	# Write the table start
	print $fh qq{CREATE TABLE $tbl (\n};
	
	$sth1->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
#	print "Table:$tbl DB:$db1<br>\n";
	
	while  ( my ( $cname, $ctype ) = $sth1->fetchrow ) {
#	    print qq{CNAME:$cname $ctype($clength),\n};
	    print $fh qq{  $cname $ctype,\n};
	}

	# Get the key
	$sth2->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	my $keyfield = $sth2->fetchrow;
	print $fh qq{PRIMARY KEY ($keyfield)\n};

	# Close DB with engine, charset
	print $fh qq{) ENGINE=MyISAM DEFAULT CHARSET=utf8;\n\n};

	delete $db1{$tbl};
	delete $master{$tbl};
	
			      
    } elsif ( $db2{$tbl} and not $db1{$tbl} ) {
	# We have to drop the table, since no longer in the primary db1 database.

	print $fh qq{DROP TABLE $tbl\n\n};
	print "Drop TABLE:$tbl<br>\n";

	delete $db2{$tbl};
	delete $master{$tbl};
	
    }

    
}



# Get Field position in table.
my $sth3 = $dbh->prepare("select ordinal_position from columns
   where column_name= ? and table_name = ? and table_schema = ?");

my $sth4 = $dbh->prepare("select column_name from columns
   where ordinal_position = ? and table_name = ? and table_schema = ?");



# Now remove the common fields to leave the differences.
foreach my $tbl ( keys %master ) {
    # Skip studentall since it's a view.
    if ( $tbl eq 'studentall' ) { next; }
    
    foreach my $col ( keys %{ $master{$tbl} } ) {
	my $db1type = $db1{$tbl}{$col};
	my $db2type = $db2{$tbl}{$col};

	if ( $db1type eq $db2type ) { # delete duplicates
	    delete $db1{$tbl}{$col};
	    delete $db2{$tbl}{$col};
	    
	} elsif ( $db1type and not $db2type ) { # add the field into correct position.
	    
	    # get name of field before field to add
	    $sth3->execute( $col, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $ordvalue = $sth3->fetchrow;
	    $ordvalue--; # decrement.

	    $sth4->execute( $ordvalue, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $prevcolname = $sth4->fetchrow;
	    my $coltype = $db1{$tbl}{$col};

#	    print qq{ADD Field:$col - ORD:$ordvalue Prev Field:$prevcolname\n};
	    
	    # Add the line into sql file.
	    print $fh qq{ALTER TABLE $tbl ADD $col $coltype AFTER $prevcolname;\n};


	} elsif ( $db2type and not $db1type ) { # delete the field

#	    print qq{DROP COLUMN $col from $tbl\n};
	    
	    # Add the line into sql file.
	    print $fh qq{ALTER TABLE $tbl DROP COLUMN $col;\n};


	} elsif ( $db1type ne $db2type ) { # update the record.

#	    print qq{MODIFY COLUMN $col $coltype from $tbl\n};

	    my $coltype = $db1{$tbl}{$col};
	    print $fh qq{ALTER TABLE $tbl MODIFY COLUMN $col $coltype;\n};
	    

	} else { # Error
	    print qq{Error:$tbl - $col - DB1 Type:$db1type DB2 Type:$db2type\n};
	    
	}

	
    }
}

# Update studentall View
print $fh qq{\nDROP VIEW IF EXISTS studentall;\n};
print $fh qq{CREATE VIEW studentall AS select * from student union select * from studentwd;\n};


close $fh;




#---------------------------
# End of script here...

exit;

# Turn on Config, Turn on Modules, Restart Apache.
system("$a2ensite $schooldir.conf ");

system("$a2enmod include"); # turn on server side includes for date on index page.
system("$a2enmod cgi"); # turn on cgi scripting module
system("$a2enmod dbd"); # turn on dbd access (for mysql passwords)
system("$a2enmod authn_dbd"); # turn on db authentication

system("$apache2ctl configtest"); # test config

system("$apache2ctl graceful"); # gracefully restart


# Create the authorization file.
# Check for existing directory
if ( not -e '/etc/apache2/auth_users' ) {
    print "Creating '/etc/apache2/auth_users'\n\n";
    mkdir '/etc/apache2/auth_users';
}

print "\nEnter Admin Website User Id: ";
$adminuser = <STDIN>;
chomp $adminuser;
print "\nEnter Admin Website User Password: ";
$adminpassword = <STDIN>;
chomp $adminpassword;
print "\nUser:$adminuser  Password:$adminpassword\n\n";


my $authfile = $schooldir. 'admin';
my $teacherauthfile = $schooldir. 'teacher';

$error = system("$htpasswd -cb $authfile $adminuser $adminpassword");
if ( not $error ) {
    print "Apache Authorization File Created\n";
}
$error = system("mv $authfile /etc/apache2/auth_users/");
if ( not $error ) {
    print "Authorization File Moved into place.\n";
}

#$error = system("cp -f /etc/apache2/auth_users/$authfile /etc/apache2/auth_users/$teacherauthfile ");
#if ( not $error ) {
#    print "Teacher Authorization File Copied.\n";
#} else {
#    print "ERROR: Teacher Authorization File NOT copied.\n";
#}


# Now set the Local RO User Password and User Id in MariaDB.
# Removed the global ro user, since not commonly used.
print "\nEnter New Database Local Read Only User Id: ";
$mysqlrouser = <STDIN>;
chomp $mysqlrouser;
print "\nDatabase Local Read Only User Id: $mysqlrouser\n";


print "\nEnter New Database Local Read Only Password: ";
$mysqlropassword = <STDIN>;
chomp $mysqlropassword;
print "\nDatabase Local Read Only Password: $mysqlropassword\n";

$error =  system("mysql -p$mysqlroot -u root -e \"grant select on $schooldir.* to $mysqlrouser\@localhost identified by '$mysqlropassword'\"");
if ( not $error ) {
    print "Local User and Password Added\n";
}


# Now load the global conf file and reset values (using local ro values)
unless ( open(FH, "<$installDirectory/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (read): $!\n";
	die "Cannot open global.conf (read): $!\n";
}

# slurp in file
my $globalfile;
{ local $/; $globalfile = <FH>; close FH;}
close FH;

$globalfile =~ s/GLOBALUSER/$mysqlrouser/;
$globalfile =~ s/GLOBALPASSWORD/$mysqlropassword/;

$globalfile =~ s/YOURSCHOOLDATABASE/$schooldir/;
$globalfile =~ s/YOURSCHOOLNAME/$schooldir/;

unless ( open(FH, ">$installDirectory/$schooldir/etc/global.conf") ) {
	print "Cannot open global.conf (write): $!\n";
	die "Cannot open global.conf (write): $!\n";
}

print FH $globalfile;
close FH;




# Now write admin.conf.root, rewrite the admin.conf
# then write all of the configuration files into location.
my $etcpath = "$installDirectory/$schooldir/etc";


# set admin.conf.root file values, and then write.
my $roottext = q{$dbase='}. $schooldir. q{';}. "\n". 
 q{$user='}. $schooldir. q{';}. "\n".
 q{$password='}. $schoolmysqlpwd. q{';}. "\n".
 q{$rouser='}. $mysqlrouser. q{';}. "\n".
 q{$ropassword='}. $mysqlropassword. q{';}. "\n".
 q{$sds_userid='SDSUSER';}. "\n". 
 q{$sds_password='SDSPASSWORD';}. "\n\n"; 


unless ( open(FH, ">$etcpath/admin.conf.root") ) {
	print "Cannot open admin.conf.root (write): $!\n";
	die "Cannot open admin.conf.root (write): $!\n";
}
print FH $roottext;
close FH;

$error =  system("cp -f $etcpath/admin.conf.root  $etcpath/admin.conf");
if ( not $error ) {
    print "COPY: admin.conf.root -> admin.conf\n\n";
}


# now open database and write configuration files
my $dsn = "DBI:mysql:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot );
$dbh->{mysql_enable_utf8} = 1;

my $sth = $dbh->prepare("select distinct filename from conf_system 
  where filename != '' and filename is not NULL order by filename");

my $sth1 = $dbh->prepare("select id, datavalue from conf_system 
  where filename = ? order by datavalue");

my $sth2 = $dbh->prepare("update conf_system 
  set datavalue = ? where id = ?");


# loop through all filenames in configuration setup
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $filename = $sth->fetchrow ) {

    if ( $filename eq 'admin' ) {

	unless ( open(FH, ">>$etcpath/admin.conf") ) {
	    print "Cannot open admin.conf (append): $!\n";
	    die "Cannot open admin.conf (append): $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	while ( my ($id, $datavalue) = $sth1->fetchrow ) {

	    if ( $datavalue =~ m/YOURSCHOOL/ ) {
		if ( $subdir ) { 
		    $datavalue =~ s!YOURSCHOOL!$subdir/$schooldir!;
		} else {
		    $datavalue =~ s/YOURSCHOOL/$schooldir/;
		}

		print "MATCH:$datavalue\n";
		$sth2->execute( $datavalue, $id ); # update database
		if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
		print "UPDATE:$id - $datavalue\n";

	    }
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;

    } else { # all other conf files

	unless ( open(FH, ">$etcpath/$filename.conf") ) {
	    print "Cannot open $filename.conf: $!\n";
	    die "Cannot open $filename.conf: $!\n";
	}

	$sth1->execute( $filename );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($id, $datavalue) = $sth1->fetchrow ) {
	    print FH $datavalue, "\n";
	}
	print FH "\n1;\n";
	close FH;
    }

} # end of writing conf file

# Restart Apache
system("$apache2ctl restart"); # gracefully restart
print qq{Apache Webserver Restarted\n};


print "Done!\n";
