#!/usr/bin/perl

# Updated/renamed for 10.0 release. Sept 11, 2018
# Updated for 9.00 release; Aug 11, 2016

# These are specific to the 7.00 release, with system changes
# (conf_system), and this hash lists conf values to alter since they
# are different or are different types, etc.
my %changeval = qw(tchpage 1 doctype 1 chartype 1 charset 1 g_position 1);

# Configuration Values
my $directoryBase = '/opt/openadmin';
my $mysqlDataDir = '/var/lib/mysql';
my $backupDir = '/opt/openadmin/backup';
my $sqldir = '../sql';

my $apacheConfDir = '/etc/apache2/sites-available';
my $apacheTempConfFile = 'apacheTempConfFile.conf';
my $backupextension = 'bak';

my $mysqldumpexec = '/usr/bin/mysqldump';
my $mysqlexec = '/usr/bin/mysql';
my $dbtype = 'mysql';
my $apache2ctl = '/usr/sbin/apache2ctl';

# Files to copy from old install back into new install
my @filesToRestore = qw( etc/studentnumber etc/receiptnumber etc/admin.conf.root 
 etc/schoollogo.jpg etc/global.conf admin/images/logo.gif  admin/images/logotn.gif );
# Note: ignore admin.css and let user change his/her colors using color setter.

# Files from earlier installs (<5.25) to use to prime the conf_system table.
my @oldConfFiles = qw(admin.conf repcard.conf repcardOVR.conf choices.conf fees.conf gbook.conf 
		      image.conf ldap.conf schedule.conf transcript.conf usermanage.conf );


use DBI;
use Cwd;

# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}


# Setup Dates
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
if ( length($month) == 1 ) { $month = '0'. $month; }
my $day = @tim[3];
if ( length($day) == 1 ) { $day = '0'. $day; }
my $currdate = "$year-$month-$day";
my $currfiledate = "$year$month$day";


my ( $schooldir, $noschoolflag,$mysqlroot );

# Get MySql Root password
print "\nEnter MySQL Root Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "MySQL Root Password: $mysqlroot\n\n";

# Get the School Directory / Database Name
while ( not $schooldir ) {

    print "Enter Existing School Name to update(single word only): ";
    $schooldir = <STDIN>;
    chomp $schooldir;

    # strip any spaces
    $schooldir =~ s/\s//g;
    print "Entered School Directory: $schooldir\n";

    if ( not -e "$directoryBase/$schooldir" ) {
	print "$schooldir Directory Not Found\n";
	$noschoolflag = 1;
    }

    # Check for existing database;
    if ( not -e "$mysqlDataDir/$schooldir" ) {
	print "$schooldir Database Not Found\n";
	$noschoolflag = 1;
    }

    if ( $noschoolflag ) {
	$schooldir = '';
    }
}



# Create Database Backup
# Check for existing backup directory
if ( not -e $backupDir ) {
    print "Creating $backupDir\n\n";

    use File::Path;
    mkpath( $backupDir );
}

# Check for existing backup file.
my ($counter, $backupfile, $backupError );
do {
    $counter++;
    if ( $counter > 20 ) { $backupError = 1; }
    $backupfile = "$schooldir-$currfiledate-$counter.sql"
} until not -e "$backupDir/$backupfile" or $backupError;
if ( $backuperror ) {
    print "Backup File not created.\n";
    exit;
}
print "Backup file check complete\n";

my $error = system("$mysqldumpexec -p$mysqlroot -u root $schooldir > $backupDir/$backupfile");
if ( not $error ) {
    print "MySQL Database Backup Created\n";
} else {
    print "Backup Error: $error\n";
    exit;
}



# Get Directories of utility/sql
opendir (DH,"$sqldir") || die "Cannot open $sqldir directory!\n";
my @files = grep !/^\./, readdir DH;
close DH;

my %sqlupdates;
foreach my $file ( sort @files ) {
    if ( $file =~ m/\d+to\d+/) {
	my ($fr, $to) = split('to', $file);
	$sqlupdates{$fr} =  $file;
    }
}


do { # repeat until we have a valid version

    print "\nDatabase Versions Supported\n";
    for my $dir ( sort keys %sqlupdates ) {
	print "$dir ";
    }
    print "\n";

    # Get Current Version
    print "\nEnter Your Current Version to Update: ";
    $currversion = <STDIN>;
    chomp $currversion;

    if ( not $sqlupdates{$currversion} ) {
	$currversion = '';
    }

} until $currversion;  # need a good match
 

# This section will now update the database sequentially through all
# update folders.


my @dirToUse = sort keys %sqlupdates; # directories containing SQL update files.
while ( @dirToUse ) {
    my $dir = shift @dirToUse;
    if ( $dir eq $currversion ) {
	unshift @dirToUse, $dir;
	last;
    }
}
# we should now have all directories to process in @dirToUse

use File::Find;
use Cwd;
my $currdir = getcwd();

foreach my $dir ( @dirToUse ) {

    my $realdir =  $sqlupdates{$dir};
    # print "Dir:$dir RealDir: $realdir<br>\n";
    print "FullDir: $currdir/../sql/$realdir\n";

    find(\&parsefile, "$currdir/../sql/$realdir" );

    sub parsefile {
	print "File: $File::Find::name\n";
	if ( $File::Find::name =~ m/.+\.sql/ ) {
	    my $error = system("$mysqlexec -p$mysqlroot -u root $schooldir < $File::Find::name");
	    if ( not $error ) {
		print "MySQL Update: $File::Find::name\n";
	    } else {
		print "MySQL Update Error: $error: $File::Find::name\n";
		exit;
	    }
	}
    } # end of sub parsefile

}



# Update Directory in /opt/openadmin.

# Empty download folders.
use File::Find;
find(\&deletefile, "$directoryBase/$schooldir/admin/download" );
find(\&deletefile, "$directoryBase/$schooldir/tadmin/download" );

sub deletefile {
    # print "File:$File::Find::name\n";
    unlink $File::Find::name;
}


# Move current schooldir into backup.
# Create new destination directory to put old install.
my ($counter, $destdir, $backupError );
do {
    $counter++;
    if ( $counter > 20 ) { $backupError = 1; }
    $destdir = "$backupDir/$schooldir-$currfiledate-$counter";
} until not -e $destdir or $backupError;
if ( $backuperror ) {
    print "OA Backup Directory not created.\n";
    exit;
}

# Move existing installation
$error = system("mv $directoryBase/$schooldir $destdir");
if ( not $error ) {
    print "Current OA installation moved into backup.\n";
} else {
    print "Error: Current Installation NOT moved into Backup: $error\n";
    exit;
}


# Put in New Installation.
my $error = system("cp -r ../../school  $directoryBase/$schooldir");
if ( not $error ) {
    print "Open Admin copied to $directoryBase/$schooldir\n";
} else {
    print "Open Admin NOT copied into place. Error: $error\n";
    exit;
}


# Move older files back into New Install 
foreach my $rfile ( @filesToRestore ) {
    $error = system("cp -f $destdir/$rfile $directoryBase/$schooldir/$rfile");
    if ( not $error ) {
	print "$rfile copied.\n";
    } else {
	print "$rfile NOT copied. Error: $error\n";
    }
}


# Change Ownership
my $error = system("chown -R www-data:www-data $directoryBase/$schooldir");
if ( not $error ) {
    print "Ownership for OA files changed to www-data:www-data\n\n";
} else {
    print "Ownership for OA files NOT changed. Error: $error\n";
}


# Copy any student pictures back into place.
$error = system("cp -fr $destdir/admin/pic-big $directoryBase/$schooldir/admin");
if ( not $error ) {
    print "Large student pictures copied.\n";
} else {
    print "Large student pictures NOT copied. Error: $error\n";
}

$error = system("cp -fr $destdir/admin/pic-sm $directoryBase/$schooldir/admin");
if ( not $error ) {
    print "Small student pictures copied.\n";
} else {
    print "Small student pictures NOT copied. Error: $error\n";
}



# Update Configuration Files from conf_system;

# Setup configuration.
my $dsn = "DBI:$dbtype:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot);

#   Add the temp_conf_system table from sql directory
my $error = system("$mysqlexec -p$mysqlroot -u root $schooldir < $sqldir/tempconfsystem.sql");
if ( not $error ) {
    print "temp_conf_system table added.\n";
} else {
    print "temp_conf_system NOT added. Error: $error\n";
    exit;
}


=head  # No longer supporting this VERY OLD stuff
if ( $currversion < 525 ) {

    use Data::Dumper;
    $Data::Dumper::Purity = 1;
    $Data::Dumper::Indent = 0;


    # Since no values in conf_system table with this version, add in values from temp_conf_system;
    my $sth = $dbh->prepare("select * from temp_conf_system order by filename, sectionname, dataname"); 
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    my $sth1 = $dbh->prepare("insert into conf_system ( filename, sectionname, sequenceval, dataname, datatype, datavalue, hashvar, version, description) 
       values(?,?,?,?,?,?,?,?,?)"); 

    while ( my @rec = $sth->fetchrow ) {
	shift @rec; # remove the record id.
	$sth1->execute( @rec ); # insert record.,
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }

    
    my $sth1 = $dbh->prepare("select id, dataname, datatype, datavalue from conf_system 
     where filename = ? order by dataname"); 

    my $sth2 = $dbh->prepare("update conf_system set datavalue = ? where id = ?");


    # pull in all configuration files, and update conf_system from that.
    foreach my $file ( @oldConfFiles ) {

	$error = system("cp -f $destdir/etc/$file $directoryBase/$schooldir/etc/$file");
	if ( not $error ) {
	    print "$file copied.\n";
	} else {
	    print "$file NOT copied. Error: $error\n";
	}


	eval require "$directoryBase/$schooldir/etc/$file";
	if ( $@ ) {
	    print $lex{Error}. ": $@<br>\n";
	    die $lex{Error}. ": $@\n";
	}

	# check for and create admin.conf.root
	if ( $file eq 'admin.conf' ) {
	    my $rootfile = "$directoryBase/$schooldir/etc/admin.conf.root";
	    if ( not -e $rootfile ) {
		# create admin.conf.root
		open(RT,">$rootfile") or die "Cannot open file $rootfile: $!\n";

		print "admin.conf.root: User:$user  Dbase:$dbase  Password: $password\n";

		print RT q{$dbase='}. $dbase. q{';}. "\n";
		print RT q{$user='}. $user. q{';}. "\n";
		print RT q{$password='}. $password. q{';}. "\n";
		print RT q{$rouser='ROUSER';}. "\n";
		print RT q{$ropassword='ROPASSWORD';}. "\n";
		print RT q{$sds_userid='}. $sds_userid. q{';}. "\n";
		print RT q{$sds_password='}. $sds_password. q{';}. "\n\n";
		close RT;
	    }
	}


	my ($filebase,$ext) = split(/\./, $file );
	$sth1->execute( $filebase );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	while ( my ( $id, $dataname, $datatype, $datavalue ) = $sth1->fetchrow ) {

	    print "Name:$dataname Type:$datatype Value:$datavalue<br>\n"; 

	    my $value_ref = [ ];
	    my $name_ref = [ ];

	    # skip any undefined values
	    if ( not defined *$dataname  ) {
		print "Undef: $dataname\n";
		next; 
	    }

	    # Scalar
	    if ( $datatype eq 'scalar' or $datatype eq 'scalaronoff' ) {

		push @$name_ref, $dataname;
		push @$value_ref, $$dataname;
	
		my $d = Data::Dumper->new( $value_ref, $name_ref );
		my $dv = $d->Dump;

#		if ( $dv eq $datavalue ) { next; } # skip this variable.

		print "SCALAR:\nNew:$dv\nOrg:$datavalue<br>\n";
		$sth2->execute( $dv, $id );

	    } elsif ( $datatype eq 'array' ) {

		$dataname = '*'. $dataname;
		push @$name_ref, $dataname;
		push @$value_ref, \@$dataname;

		my $d = Data::Dumper->new( $value_ref, $name_ref );
		my $dv = $d->Dump;

#		if ( $dv eq $datavalue ) { next; } # skip this variable.

		print "ARRAY:\nNew:$dv\nOrg:$datavalue<br>\n";
		$sth2->execute( $datavalue, $id );

	    } elsif ( ( $datatype eq 'hash' ) or ($datatype eq 'hashofarray')  ) {

		$newdataname = '*'. $dataname;
		push @$name_ref, $newdataname;
		push @$value_ref, \%$dataname;

		my $d = Data::Dumper->new( $value_ref, $name_ref );
		my $dv = $d->Dump;

#		if ( $dv eq $datavalue ) { next; } # skip this variable.

		print "HASH:\nNew:$dv\nOrg:$datavalue<br>\n";
		$sth2->execute( $datavalue, $id );

	    }
	} # end of data loop

    }
}  # End: Version < 525
=cut


# Update the conf_system table to latest version
# Fields to update in the existing conf_system table, no value changes
my @confFields = qw( sectionname sequenceval version description );


# Load both tables into hashes.
my ($ref, $tempref);
$sth = $dbh->prepare("select * from conf_system"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$ref = $sth->fetchall_hashref( 'dataname' );

$sth = $dbh->prepare("select * from temp_conf_system"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$tempref = $sth->fetchall_hashref( 'dataname' );


# Update any Record Fields
foreach my $key ( keys %$tempref ) {

    if ( not $ref->{$key} ) { # skip if no matching field in original
	next; 
    } 

    # records are in $tempref->{$key} and $ref->{$key}
    my $count;

=head
    # arr{attrib} dummy means no updates anyway.
    foreach my $fld ( @confFields ) {

	$count++;
	# print "$count. K:$key  F:$fld  Val:$tempref->{$key}->{$fld}<br><b>$ref->{$key}->{$fld}</b><br>\n";

	if ( $tempref->{$key}->{$fld} eq $ref->{$key}->{$fld} ) {
	    next; 
	}

	# Update the main record
	$sth = $dbh->prepare("update conf_system set $fld = ? where id = ?");
	if ( $arr{attrib} ) {
	    #print "Update Attribute<br>\n";
	    $sth->execute( $tempref->{$key}->{$fld}, $ref->{$key}->{id} );
	}
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	print "Update $count. $key - $fld - $tempref->{$key}->{$fld}\n";

    }
=cut

    # Update values
    my $sth = $dbh->prepare("update conf_system set datavalue = ? where id = ?");

    if ( $changeval{ $key } ) { # this is a record to change value
	$sth->execute( $tempref->{$key}->{'datavalue'}, $ref->{$key}->{id} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	print "Value Updated. $key - $fld - $tempref->{$key}->{'datavalue'}\n";
    }


    # Now erase the 2 values if identical keys (dataname) (for later record comparisons)
    if ( $tempref->{$key} and $ref->{$key} ) {
	delete $tempref->{$key};
	delete $ref->{$key};
    }

}


# Delete Records (vars) from conf_system table
$sth = $dbh->prepare("delete from conf_system where id = ?");
foreach my $key ( sort keys %$ref ) {
    $sth->execute( $ref->{$key}->{id} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    print "Delete: $key - $ref->{$key}->{datavalue}\n";
}


# Add Records (vars) to conf_system table
foreach my $key ( sort keys %$tempref ) {

    my %temp = %{ $tempref->{$key} };
    delete $temp{id};

    my $keystring = join(',', keys %temp );
    my @vals = values %temp;
    # print "K:$keystring V:@vals<br>\n";

    $sth = $dbh->prepare("insert into conf_system ( $keystring ) values ( ?,?,?,?,?,?,?,?,? )");
    $sth->execute( @vals );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    print "Add: $key - $tempref->{$key}->{datavalue}\n";

}



# Update conf files from the conf_system table.
my @files;
my $sth = $dbh->prepare("select distinct filename from conf_system 
 where filename is not NULL and filename != ''  order by filename");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $filename = $sth->fetchrow ) {
    push @files, $filename;
}

my $etcpath = "$directoryBase/$schooldir/etc";

foreach my $updatefile ( @files ) {

    my $filename = "$etcpath/$updatefile.conf";

    # special case for admin.conf
    if ( $updatefile eq 'admin' ) { # use the admin.conf.root file.
	system("cp -f $etcpath/admin.conf.root $filename");
	# print "Result:", $? >> 8, "<br>\n";

	open(FH,">>$filename") or
	    die "Cannot open file $filename: $!\n"; # open for append
    } else {
	open(FH,">$filename") or
	    die "Cannot open file $filename: $!\n";
    }


    my $sth = $dbh->prepare("select id, datavalue from conf_system 
     where filename = ? order by dataname");
    $sth->execute( $updatefile );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    while ( my ($id, $value) = $sth->fetchrow ) {
	print FH $value, "\n";
    }

    print FH "\n1;\n";
    close FH;

    print "File Updated: $updatefile\n";
}


# Drop temp_conf_system table, since no longer needed.
my $sth = $dbh->prepare("drop table temp_conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }



# Update the SUBJECT table, teacher field: remove any names, if found.

my $sth1 = $dbh->prepare("update subject set teacher = ? where id = ?");

my $sth = $dbh->prepare("select id, teacher, description from subject order by subjsec");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

print "\nUpdate Subject Table - Remove extra teacher names\n";

while ( my ($id, $teacher, $description) = $sth->fetchrow ) {

    if ( $teacher =~ m/\((\w+)\)/ ) { # we have a name value

	my $original = $teacher;
	my $newteacher = $1;

	# Reset the teacher field
	$sth1->execute($newteacher, $id);
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	
	print "$description - $original\n";

    } # update loop
}

print "Subject Table Update Complete\n\n";


# Now do the update on the apache configuration file to add in new
# directory index setting for tindex.pl

print "Updating Apache Configuration for tindex.pl/pindex.pl\n";

my $sourcefile = $apacheConfDir. '/'. $schooldir. '.conf';
my $destfile = $apacheConfDir. '/'. $apacheTempConfFile;
my $backupfile = $apacheConfDir. '/'. $schooldir. '.'. $backupextension;

# Open In Source File
unless ( open(IN, '<', $sourcefile) ) {
	print "Cannot open $sourcefile: $!\n";
	die "Cannot open $sourcefile: $!\n";
}

# Open Out Source File
unless ( open(OUT, '>', $destfile) ) {
	print "Cannot open $destfile: $!\n";
	die "Cannot open $destfile: $!\n";
}

my $teacherarea;
my $parentarea;
my $parentinsert;

while ( <IN> ) {

    if ($_ =~ m/tadmin/ ) {
	$teacherarea = 1;
    }

    if ($_ =~ m/Parent Site/ ) {
	$parentarea = 1;
	$teacherarea = 0;
    }

    if ( $teacherarea ) { # replace values
	$_ =~ s/DirectoryIndex.+$/DirectoryIndex tindex.pl/;
	$_ =~ s/AddHandler.+$/AddHandler cgi-script .pl/;
	$_ =~ s/AddType.+$//; # remove line.
    }

    if ( $parentarea ) { # replace values

	$_ =~ s/^#//; # strip comments

	if ( $parentinsert ) {
	    print OUT qq{\n   DirectoryIndex pindex.pl\n};
	    print OUT qq{   AddHandler cgi-script .pl\n\n};
	    $parentinsert = ''; # only run once.
	}

	if ( $_ =~ m/ServerName/ ) { $parentinsert = 1; }

	if ($_ =~ m/Parent Site/ ) { # insert comment.
	    $_ = '# '. $_;
	}


    }

    print OUT $_; # print out this line

}


close OUT;
close IN;

# Rename files.
rename( $sourcefile, $backupfile);
rename( $destfile, $sourcefile);

# Burp Apache
system("$apache2ctl graceful"); # gracefully restart


print "Done!\n";



# Metadata update
#   Add the temp_meta table from sql directory
my $error = system("$mysqlexec -p$mysqlroot -u root $schooldir < $sqldir/tempmeta.sql");
if ( not $error ) {
    print "temp_meta table added.\n";
} else {
    print "temp_meta NOT added. Error: $error\n";
    exit;
}


# Load both tables into hashes.
my %meta = ();
my %tempmeta = () ;

my ($ref, $tempref);
$sth = $dbh->prepare("select * from meta"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $meta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
}

#use Data::Dumper;
#print Dumper %meta;

$sth = $dbh->prepare("select * from tempmeta"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $tempmeta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
}


# Update any Record Fields
foreach my $tableid ( keys %tempmeta ) {
    foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	if ( not $meta{$tableid}{$fieldid} ) { # skip if no matching field in original
	    next; 
	} 

	# Update values
	if ( $tableid eq 'student_inac' or $tableid eq 'staff' ) { # this is a record to change value

	    my %temprec = %{ $tempmeta{$tableid}{$fieldid} };
	    my $id = $meta{$tableid}{$fieldid}->{id};

	    foreach my $field ( keys %temprec ) { 
		if ( $field eq 'id' or $field eq 'tableid' or 
		     $field eq 'fieldid' or $field eq 'dbaseid' ) {
		    next; 
		}
		my $sth = $dbh->prepare("update meta set $field = ? where id = ?");
		$sth->execute( $temprec{$field}, $id );
		print "Update: Field:$field Value:$temprec{$field}\n"; 
	    }

	}

	# Now erase the 2 values if identical keys (dataname) (for later record comparisons)
	if ( $tempmeta{$tableid}{$fieldid} and $meta{$tableid}{$fieldid} ) {
	    delete $tempmeta{$tableid}{$fieldid};
	    delete $meta{$tableid}{$fieldid};
	}
    }
}


# Delete Records (vars) from meta table
$sth = $dbh->prepare("delete from meta where id = ?");
foreach my $tableid ( keys %meta ) {
    foreach my $fieldid ( keys %{ $meta{$tableid} } ) {
	# $sth->execute( $ref->{$key}->{id} );
	$sth->execute( $meta{$tableid}{$fieldid}->{id} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	print "Delete: $tableid - $fieldid\n";
    }
}

# Add Records (vars) to meta table
#foreach my $key ( sort keys %$tempref ) {
foreach my $tableid ( keys %tempmeta ) {
    foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	my %temp = %{ $tempmeta{$tableid}{$fieldid} };
	delete $temp{id};

	my $keystring = join(',', keys %temp );
	my @vals = values %temp;
	# print "ADD: K:$keystring V:@vals<br>\n";

	$sth = $dbh->prepare("insert into meta ( $keystring ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )"); 
	# 12 fields n/c id.
	$sth->execute( @vals );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	print "Add: $tableid - $fieldid\n";
    }
}


# Drop temp_meta table, since no longer needed.
my $sth = $dbh->prepare("drop table temp_meta");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

print "Done the meta table update\n";
