#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  Compare variables in the conf_system within single database, where
#  one is called 'temp_conf_system' and other is normal conf_system
#  table. The temp_conf_system table will be authoritative for
#  structure. The other table (conf_system) contains the correct
#  values, etc. for configuration

use DBI;

#my ($password, $db ) = @ARGV;
#if ( not $password ) {
#    print "Compare a single database with a temp_conf_system table and a normal conf_system table\n";
#    print "Usage: ./update2ConfSystem.pl password dbase\n";
#    exit;
#}

my $directoryBase = '/opt/openadmin';
my $mysqlDataDir = '/var/lib/mysql';

my $user = 'root';
my $dbtype = 'mysql';

my $sqlfile = 'updateconfsystem.sql';

# Get MySql Root password
print "\nEnter MySQL Root Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "MySQL Root Password: $mysqlroot\n\n";


# Get the School Directory / Database Name
while ( not $schooldir ) {

    print "Enter Existing School Name to update(single word only): ";
    $schooldir = <STDIN>;
    chomp $schooldir;

    # strip any spaces
    $schooldir =~ s/\s//g;
    print "Entered School Directory: $schooldir\n";

    if ( not -e "$directoryBase/$schooldir" ) {
	print "$schooldir Directory Not Found\n";
	$noschoolflag = 1;
    }

    # Check for existing database;
    if ( not -e "$mysqlDataDir/$schooldir" ) {
	print "$schooldir Database Not Found\n";
	$noschoolflag = 1;
    }

    if ( $noschoolflag ) {
	$schooldir = '';
    }
}

my $db = $schooldir;
my $password = $mysqlroot;


my $dsn = "DBI:$dbtype:dbname=$db";
my $dbh = DBI->connect($dsn,$user,$password);


# Get  conf_system data - normal conf system table
my %conf;
my $sth = $dbh->prepare("select * from conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;
    $conf{$r{filename}}{$r{dataname}} = $ref;
    $master{$r{filename}}{$r{dataname}} = 1;
    
}


# Get  temp_conf_system data
my %temp;
my $sth = $dbh->prepare("select * from temp_conf_system");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;
    $temp{$r{filename}}{$r{dataname}} = $ref;
    $master{$r{filename}}{$r{dataname}} = 1;
}


# Open SQL file
open(my $fh, ">", $sqlfile ) or die "Can't open $sqlfile: $!\n";


# Add or Delete Datavalues
foreach my $filename ( sort keys %master ) {
    foreach my $dataname ( sort keys %{ $master{$filename}} ) {
	
	my %t = %{ $temp{$filename}{$dataname} }; # temp_conf_system
	my %c = %{ $conf{$filename}{$dataname} }; # conf_system

	if ( not %c ) { # ADD dataname

	    delete $t{id}; # remove record id.
	    my @fields = sort keys %t;
	    my (@values, @qst);
	    foreach my $field ( @fields ) {
		push @values, $dbh->quote( $t{$field} );
		push @qst, '?';
	    }

	    my $fields = join(',',@fields);
	    my $qst = join(',',@qst);
	    my $values = join(',', @values);

	    print $fh qq{INSERT INTO conf_system ($fields) values($values);\n\n};
	    
#	    my $sth = $dbh->prepare("insert into conf_system ( $fields ) values( $qst )");
#	    $sth->execute( @values );
#	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    

	} elsif ( not %t ) { # DELETE dataname

	    print $fh qq{delete from conf_system where id = $c{id}; # $filename - $dataname $\n\n};

	}
    }
}



# Update individual records
# Loop over all hash values
foreach my $filename ( sort keys %master ) {
    foreach my $dataname ( sort keys %{ $master{$filename}} ) {
	
	my %t = %{ $temp{$filename}{$dataname} }; # temp_conf_system
	my %c = %{ $conf{$filename}{$dataname} }; # conf_system

	# Compare sectionname, sequenceval, datatype
	if ( $c{sectionname} ne $t{sectionname} and $t{sectionname} and $c{id} ) {
	    print $fh qq{UPDATE conf_system set sectionname = '$t{sectionname}' where id = $c{id}; # $dataname - $c{sectionname}\n\n};
	    
	}
	
	if ( $c{sequenceval} ne $t{sequenceval} and $t{sequenceval} and $c{id} ) {
	    print $fh qq{UPDATE conf_system set sequenceval = '$t{sequenceval}' where id = $c{id}; # $dataname - $c{sequenceval}\n\n};
	    
	}
	
	if ( $c{datatype} ne $t{datatype} and $t{datatype} and $c{id} ) {
	    print $fh qq{UPDATE conf_system set datatype = '$t{datatype}' where id = $c{id}; # $dataname - $c{datatype}\n\n};
	}

	if ( $c{description} ne $t{description} and $t{description} and $c{id} ) {
	    $t{description} =~ s/'/\\'/g;
	    $t{description} =~ s/\r|\n//g;
	    
	    print $fh qq{UPDATE conf_system set description = '$t{description}' where id = $c{id}; # $dataname - $c{description}\n\n};
	}
	
    }
}


close $fh;

print qq{\nCreated: updateconfsystem.sql file to update your configuration system (conf_system table)\n};
print qq{\nDone!\n};
