#!/usr/bin/perl

# This script is only used to help with configuration updates for new
# releases. Not required to be used for installations or installation
# updates.


# Configuration Values
my $directoryBase = '/opt/openadmin';
my $mysqlDataDir = '/var/lib/mysql';
my $backupDir = '/opt/openadmin/backup';
my $sqldir = '../sql';

my $apacheConfDir = '/etc/apache2/sites-available';
my $apacheTempConfFile = 'apacheTempConfFile.conf';
my $backupextension = 'bak';

my $mysqldumpexec = '/usr/bin/mysqldump';
my $mysqlexec = '/usr/bin/mysql';
my $dbtype = 'mysql';
my $apache2ctl = '/usr/sbin/apache2ctl';


use DBI;
use Cwd;


# Check working directory
if ( getcwd() !~ m/install-debian/ ) {
    print "Script must run from install-debian directory!\n";
    print "Please change your working directory. \n";
    exit;
}

my ( $schooldir, $noschoolflag,$mysqlroot );

# Get MySql Root password
print "\nEnter MySQL Root Password: ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "MySQL Root Password: $mysqlroot\n\n";

# Get the School Directory / Database Name
while ( not $schooldir ) {

    print "Enter Existing School Name to update(single word only): ";
    $schooldir = <STDIN>;
    chomp $schooldir;

    # strip any spaces
    $schooldir =~ s/\s//g;
    print "Entered School Directory: $schooldir\n";

    if ( not -e "$directoryBase/$schooldir" ) {
	print "$schooldir Directory Not Found\n";
	$noschoolflag = 1;
    }

    # Check for existing database;
    if ( not -e "$mysqlDataDir/$schooldir" ) {
	print "$schooldir Database Not Found\n";
	$noschoolflag = 1;
    }

    if ( $noschoolflag ) {
	$schooldir = '';
    }
}


# Needs: $schooldir (which is database)
# Setup configuration.
my $dsn = "DBI:$dbtype:dbname=$schooldir";
my $dbh = DBI->connect($dsn,'root',$mysqlroot);

# Update: this is now done by the update1 script.
#   Add the temp_meta table from sql directory
# my $error = system("$mysqlexec -p$mysqlroot -u root $schooldir < $sqldir/tempmeta.sql");
# if ( not $error ) {
#    print "temp_meta table added.\n";
#} else {
#    print "temp_meta NOT added. Error: $error\n";
#    exit;
#}


# Load both tables into hashes.
my %meta;
my %tempmeta;

my ($ref, $tempref);
$sth = $dbh->prepare("select * from meta"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $meta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
}

#use Data::Dumper;
#print Dumper %meta;

$sth = $dbh->prepare("select * from temp_meta"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {
    $tempmeta{ $ref->{tableid} }{ $ref->{fieldid} } = $ref;
}


# Update any Record Fields
foreach my $tableid ( keys %tempmeta ) {
    foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	if ( not $meta{$tableid}{$fieldid} ) { # skip if no matching field in original
	    next; 
	} 

	# Update values
	if ( $tableid eq 'student_inac' or $tableid eq 'staff' ) { # this is a record to change value

	    my %temprec = %{ $tempmeta{$tableid}{$fieldid} };
	    my $id = $meta{$tableid}{$fieldid}->{id};
	    
	    foreach my $field ( sort keys %temprec ) {
		if ( $field eq 'id' or $field eq 'tableid' or 
		     $field eq 'fieldid' or $field eq 'dbaseid' ) {
		    next; 
		}
		my $sth = $dbh->prepare("update meta set $field = ? where id = ?");
		$sth->execute( $temprec{$field}, $id );
		print "Update: Field:$field Value:$temprec{$field} \n"; 
	    }
	}


	# Now erase the 2 values if identical keys (dataname) (for later record comparisons)
	if ( $tempmeta{$tableid}{$fieldid} and $meta{$tableid}{$fieldid} ) {
	    delete $tempmeta{$tableid}{$fieldid};
	    delete $meta{$tableid}{$fieldid};
	}
    }
}



# Delete Records (vars) from meta table
$sth = $dbh->prepare("delete from meta where id = ?");
foreach my $tableid ( keys %meta ) {
    foreach my $fieldid ( keys %{ $meta{$tableid} } ) {
	# $sth->execute( $ref->{$key}->{id} );
	$sth->execute( $meta{$tableid}{$fieldid}->{id} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	print "Delete: $tableid - $fieldid\n";
    }
}

# Add Records (vars) to meta table
#foreach my $key ( sort keys %$tempref ) {
foreach my $tableid ( keys %tempmeta ) {
    foreach my $fieldid ( keys %{ $tempmeta{$tableid} } ) {

	my %temp = %{ $tempmeta{$tableid}{$fieldid} };
	delete $temp{id};

	my $keystring = join(',', keys %temp );
	my @vals = values %temp;
	# print "ADD: K:$keystring V:@vals<br>\n";

	$sth = $dbh->prepare("insert into meta ( $keystring ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )");
	# 12 fields n/c id.
	$sth->execute( @vals );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	print "Add: $tableid - $fieldid\n";
    }
}


# Drop temp table, since no longer needed.
my $sth = $dbh->prepare("drop table temp_meta");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
print qq{The temp_meta table is now dropped.\n};

print qq{Done!\n};
