#!/usr/bin/perl

# Update Version to the latest. This will ask for current school location (directory,dbase).


# Now create the new database and populate it.

#--------------------------
# Now compare the new version database and the old version database, and write out sql update file.
#--------------------------

use DBI;


$mysqlroot = 'sezme';
$sqlfile = 'fixdatabase.sql';

print qq{Creating an sql file to be used to update your current database to the latest OA version\n};

my $user = 'root';
my $database = 'information_schema';
my $dsn = "DBI:mysql:$database";
my $dbh = DBI->connect($dsn,$user,$mysqlroot ); # mysqlroot is root password for dbase.

my (%master, %db1, %db2);

my $sth = $dbh->prepare("select table_name, column_name, column_type from columns where table_schema = ?");

my $db1 = 'temp';
my $db2 = 'thunderchild';

# DB 1 - source table ( New Version )
$sth->execute( $db1 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db1{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}

# DB 2 - destination table ( Old Version )
$sth->execute( $db2 );
while ( my  ($tname, $cname, $ctype ) = $sth->fetchrow ) {
    $db2{$tname}{$cname} = $ctype;
    $master{$tname}{$cname} = 1;
}


# Open SQL file
open(my $fh, ">", $sqlfile ) or die "Can't open $sqlfile: $!\n";

my $sth1 = $dbh->prepare("select column_name, column_type from columns 
   where table_name = ? and table_schema = ?");

# Get Primary Key
my $sth2 = $dbh->prepare("select column_name from key_column_usage
   where table_name = ? and table_schema = ?");



# Do the table analysis and then remove/add tables and update %master, etc. hashes
foreach my $tbl ( keys %master ) {
    if ( $db1{$tbl} and not $db2{$tbl} ) {
	# we have to add the entire table for the db2 database
	
	# Write the table start
	print $fh qq{CREATE TABLE $tbl (\n};
	
	$sth1->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
#	print "Table:$tbl DB:$db1<br>\n";
	
	while  ( my ( $cname, $ctype ) = $sth1->fetchrow ) {
#	    print qq{CNAME:$cname $ctype($clength),\n};
	    print $fh qq{  $cname $ctype,\n};
	}

	# Get the key
	$sth2->execute( $tbl, $db1 );
	if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	my $keyfield = $sth2->fetchrow;
	print $fh qq{PRIMARY KEY ($keyfield)\n};

	# Close DB with engine, charset
	print $fh qq{) ENGINE=MyISAM DEFAULT CHARSET=utf8;\n\n};

	delete $db1{$tbl};
	delete $master{$tbl};
	
			      
    } elsif ( $db2{$tbl} and not $db1{$tbl} ) {
	# We have to drop the table, since no longer in the primary db1 database.

	print $fh qq{DROP TABLE $tbl;\n\n};
	print "Writing Drop TABLE:$tbl to the sql update file.\n";

	delete $db2{$tbl};
	delete $master{$tbl};
	
    }
    
}



# Get Field position in table.
my $sth3 = $dbh->prepare("select ordinal_position from columns
   where column_name= ? and table_name = ? and table_schema = ?");

my $sth4 = $dbh->prepare("select column_name from columns
   where ordinal_position = ? and table_name = ? and table_schema = ?");


# Now remove the common fields to leave the differences.
foreach my $tbl ( keys %master ) {
    # Skip studentall since it's a view.
    if ( $tbl eq 'studentall' ) { next; }
    
    foreach my $col ( keys %{ $master{$tbl} } ) {
	my $db1type = $db1{$tbl}{$col};
	my $db2type = $db2{$tbl}{$col};

	if ( $db1type eq $db2type ) { # delete duplicates
	    delete $db1{$tbl}{$col};
	    delete $db2{$tbl}{$col};
	    
	} elsif ( $db1type and not $db2type ) { # add the field into correct position.
	    
	    # get name of field before field to add
	    $sth3->execute( $col, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $ordvalue = $sth3->fetchrow;
	    $ordvalue--; # decrement.

	    $sth4->execute( $ordvalue, $tbl, $db1 );
	    if ( $DBI::errstr ) { print qq{DBI Error:$DBI::errstr; die $DBI::errstr; } }
	    my $prevcolname = $sth4->fetchrow;
	    my $coltype = $db1{$tbl}{$col};

#	    print qq{ADD Field:$col - ORD:$ordvalue Prev Field:$prevcolname\n};
	    
	    # Add the line into sql file.
	    print $fh qq{ALTER TABLE $tbl ADD $col $coltype AFTER $prevcolname;\n};


	} elsif ( $db2type and not $db1type ) { # delete the field

#	    print qq{DROP COLUMN $col from $tbl\n};
	    
	    # Add the line into sql file.
	    print $fh qq{ALTER TABLE $tbl DROP COLUMN $col;\n};


	} elsif ( $db1type ne $db2type ) { # update the record.

#	    print qq{MODIFY COLUMN $col $coltype from $tbl\n};

	    my $coltype = $db1{$tbl}{$col};
	    print $fh qq{ALTER TABLE $tbl MODIFY COLUMN $col $coltype;\n};
	    

	} else { # Error
	    print qq{Error:$tbl - $col - DB1 Type:$db1type DB2 Type:$db2type\n};
	    
	}

	
    }
}

# Update studentall View
print $fh qq{\nDROP VIEW IF EXISTS studentall;\n};
print $fh qq{CREATE VIEW studentall AS select * from student union select * from studentwd;\n};

print qq{Created databasediff.sql file. If you have any additional tables, fields, etc, \n};
print qq{ please edit this file, before running the next script (update2.pl).\n};

close $fh;

# drop the new version database, since the 2 temp tables are updated
# from the sql directory files.
=head
$error =  system("mysql -p$mysqlroot -u root -e \"drop database $tempinstalldir\"");
if ( not $error ) {
    print "New TEMP Database dropped. - $tempinstalldir\n\n";
}


# Update the 2 temp tables. (they should drop existing table, if extant).
$error =  system("mysql -p$mysqlroot -u root $schooldir < ../sql/tempconfsystem.sql");
if ( not $error ) {
    print "Temp Conf System table updated.\n";
} else {
    print "ERROR: updating Temp Conf System table failure.\n";
}

$error =  system("mysql -p$mysqlroot -u root $schooldir < ../sql/tempmeta.sql");
if ( not $error ) {
    print "Temp Meta table updated.\n\n";
} else {
    print "ERROR: updating Temp Meta table failure.\n\n";
}
=cut

print "Done!\n\n";
