#!/usr/bin/perl

# Configuration Values
my $directoryBase = '/opt/openadmin';
my $apacheConfDir = '/etc/apache2/sites-available';
my $ieppwd = 'ieppwd'; # teacher password file
my $ieppwdadmin = 'ieppwdadmin'; # admin password file.

my $a2dissite = '/usr/sbin/a2dissite';
my $apache2ctl = '/usr/sbin/apache2ctl';


print "\nBase Directory: $directoryBase\n";

print "\nEnter Directory/Site Identifier (single word only): ";
$workdir = <STDIN>;
chomp $workdir;

# Remove the site in /opt/openadmin
my $error = system("rm -r $directoryBase/$workdir");
if ( not $error ) {
    print "Directory Removed from $directoryBase/$workdir\n\n";

} else {
    print "Directory NOT Removed from $directoryBase/$workdir\n\n";
    print "Error:$error\n";
    exit;
}


# Remove Apache 2 configuration
# First Unlink File
system("$a2dissite $workdir.conf ");

# Remove the Conf File.
my $error = system("rm -rf $apacheConfDir/$workdir.conf");
if ( not $error ) {
    print "Apache Configuration File Removed - $apacheConfDir/$workdir.conf\n\n";
} else {
    print "Apache Configuration File NOT Removed - $apacheConfDir/$workdir.conf\n\n";
    print "Error:$error\n";
    exit;
}

# Restart Apache
system("$apache2ctl graceful"); # gracefully restart


# Remove authorization files, if found
my $adminpwdfile = $workdir. 'admin';
my $teacherpwdfile = $workdir. 'teacher';

# remove admin password file
my $error = system("rm -rf /etc/apache2/auth_users/$adminpwdfile");
if ( not $error ) {
    print "Admin Password File Removed - /etc/apache2/auth_users/$adminpwdfile\n";
} else {
    print "Admin Password File Removed - /etc/apache2/auth_users/$adminpwdfile\n";
    print "Error:$error\n";
    exit;
}

# remove teacher password file
my $error = system("rm -rf /etc/apache2/auth_users/$teacherpwdfile");
if ( not $error ) {
    print "Teacher Password File Removed - /etc/apache2/auth_users/$teacherpwdfile\n";
} else {
    print "Teacher Password File NOT Removed - /etc/apache2/auth_users/$teacherpwdfile\n";
    print "Error:$error\n";
    # exit;
}



# Now drop the database;
# Get MySql Root password
print "\nEnter MySQL Root Password (to drop database): ";
$mysqlroot = <STDIN>;
chomp $mysqlroot;
print "MySQL Root Password: $mysqlroot\n";


$error = system("mysqladmin -p$mysqlroot -u root drop $workdir");
if ( not $error ) {
    print "MySQL Database Dropped\n";
}

print "Done!\n\n";
