#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Edit' => 'Edit',
	   'Delete' => 'Delete',
	   'Assessment Items' => 'Assessment Items',
	   'GB&nbsp;Main' => 'GB&nbsp;Main',
	   'Main' => 'Main',
	   'Date' => 'Date',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Group' => 'Group',
	   'No Subject Found' => 'No Subject Found',
	   'Error' => 'Error',
	   'Please Log In' => 'Please Log In',
	   'Scrub' => 'Scrub',
	   'Gradebook' => 'Gradebook',
	   'Scores' => 'Scores',

	   );

use DBI;
use CGI;
use CGI::Session;

my $self = 'scrubgbook.pl';

my $q = new CGI;
my %arr = $q->Vars;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;

=head
# Get Session Information...
my $session = new CGI::Session("driver:mysql;serializer:FreezeThaw",
 undef,{Handle => $dbh}) or die CGI::Session->errstr;

my $logged_in = $session->param(logged_in);
if ( not $logged_in ) {
    print $q->header( -charset, $charset );
    print "<h3>$lex{'Please Log In'}</h3>\n";
    exit;
}

my $subjsec = $session->param('subjsec');
print $q->header( -charset, $charset ); 
=cut
print $q->header;

my $title = "$lex{Scrub} $lex{Gradebook} $lex{Scores}";
print "$doctype\n<html><head><title>$title</title>\n";
print "<link rel=\"stylesheet\" href=\"$tchcss\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$tchpage\">$lex{Main}</a> |\n";
print "<a href=\"gbmain.pl\">$lex{'GB&nbsp;Main'}</a> ]\n";
print "<h1>$title</h1>\n";





# Remove any gbscores for students not enrolled in the subject.
# Get Subjects
my @subjects = ();
my $sth = $dbh->prepare("select distinct subjsec from gbtest 
  where subjsec is not NULL and subjsec != ''");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr:$!\n";}
while ( my $subjsec = $sth->fetchrow ) {
    push @subjects, $subjsec;
}


$sth = $dbh->prepare("select id, description from gbtest where subjsec = ?");
my $sth1 = $dbh->prepare("select description from subject where subjsec = ?");

my $sth2 = $dbh->prepare("select count(*) from eval where subjcode = ? and studnum = ?");
my $sth3 = $dbh->prepare("select id, studnum from gbscore where testid = ?");
my $sth4 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
my $sth5 = $dbh->prepare("delete from gbscore where id = ?");


print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\">\n";


foreach my $subjsec ( @subjects ) {

    # Get the Subject Name
    $sth1->execute( $subjsec );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $subjectname = $sth1->fetchrow;

    $sth->execute( $subjsec );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my ($testid, $description ) = $sth->fetchrow ) {

	# Now look for withdrawn students in gbscore
	$sth3->execute( $testid );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	while ( my ($scoreid, $studnum ) = $sth3->fetchrow ) {
	    
	    # Check if this student is not enrolled now...
	    $sth2->execute( $subjsec, $studnum );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my $count = $sth2->fetchrow;
	    if ( not $count ) { # not enrolled.

		# Get Student Name
		$sth4->execute( $studnum );
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
		my ( $lastname, $firstname ) = $sth4->fetchrow;

		# Delete Record - Name, Subject, Test
#		$sth5->execute( $scoreid );
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
		# print "$studnum - $description ";
		print "<tr><td>$firstname $lastname</td><td>$subjectname ($subjsec)</td><td>$description</tr>\n";
	    }
	} # Score Loop
    } # Test Loop
} # Subject Loop



# Now Look for any Gradebook Score Orphans, to remove.
print "<h1>Score Orphans</h1>\n";

$sth = $dbh->prepare("select id, testid, studnum from gbscore");
$sth1 = $dbh->prepare("select count(*) from gbtest where id = ?");

my $first = 1;

$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
while ( my ($id, $testid, $studnum ) = $sth->fetchrow ) {
    
    $sth1->execute( $testid );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth1->fetchrow;
    if ( not $count ) { # no test found
	print "<div>Score Orphan: Student:$studnum - TestId:$testid - ScoreId:$id</div>\n";
	$first = 0;
    }
}

if ( $first ) {
    print "<h3>No Score Orphans Found</h3>\n";
}



# Now Look for any Gradebook Test Orphans, to remove.
print "<h1>Test Orphans</h1>\n";

$sth = $dbh->prepare("select * from gbtest");
$sth1 = $dbh->prepare("select count(*) from subject where subjsec = ?");

$sth2 = $dbh->prepare("delete from gbscore where testid = ?");
$sth3 = $dbh->prepare("delete from gbtest where id = ?");


my $first = 1;

$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
while ( my $ref = $sth->fetchrow_hashref ) {

    my $subjsec = $ref->{subjsec};

    $sth1->execute( $subjsec );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth1->fetchrow;
    if ( not $count ) { # No Subject for this test.

	my $testid = $ref->{id};
	# print "Test Id: $testid<br>\n";
#	$sth2->execute( $testid );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
#	$sth3->execute( $testid );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

	print "<div>Test Orphan: Subjsec:$subjsec - TestId:$ref->{id} - $ref->{name}</div>\n";
	$first = 0;
    }
}

if ( $first ) {
    print "<h3>No Test Orphans Found</h3>\n";
}


print "</body></html>\n";
