#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Google User Management' => 'Google User Management',

	   );

my $self = 'gdocview.pl';


use REST::Google::Apps::Provisioning;
use DBI;
use CGI;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/usermanage.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


# Get Google Docs 
my $gd = REST::Google::Apps::Provisioning->new(domain => $google_domain );
$gd->authenticate( username => $google_username,
		   password => $google_password ) ||
    die "Authentication Failure!\n";


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

# Setup Database
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'Google User Management'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";
#print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";
print "<h1 style=\"text-align:center;\">". $lex{'Google User Management'}. "</h1>\n";

print "<table cellspacing=\"0\" cellpadding=\"3\" border=\"1\">\n";

# Now get all GDoc Users
my %googleusers = ();
my $users = $gd->getAllUsers();
#use Data::Dumper;

my $sth = $dbh->prepare("select lastname, firstname, grade from student where studnum = ?");
my $sth1 = $dbh->prepare("select count(*) from studentwd where studnum = ?");
my %hasaccount;
my $count = 1;

foreach my $userref ( sort keys %{$users} ) {
    my $student;
    my ($studnum, $lastname, $firstname, $grade);
    my $remove;

    if ( $userref =~ m/s[0-9]+/ ) {
	$student = '<span style="color:red;">S</span>';
    }

    my $ref = $$users{ $userref };
    print "<tr><td>$count: $student $remove $userref</td>";
    print "<td>$$ref{givenName}  $$ref{familyName}</td>\n";
    # agreedToTerms  suspended
    print "<td>$studnum $firstname $lastname $grade</td></tr>\n";

    $count++;
}


print "</table></body></html>\n";
