#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# View all Google Users in this domain.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'View Google Users' => 'View Google Users',

	   );

my $self = 'googleview.pl';


use REST::Google::Apps::Provisioning;
use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/usermanage.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


# Get Google Docs 
my $gd = REST::Google::Apps::Provisioning->new(domain => $google_domain );
$gd->authenticate( username => $google_username,
		   password => $google_password ) ||
    die "Authentication Failure!\n";


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'View Google Users'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";
#print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";
print "<h1 style=\"text-align:center;\">". $lex{'View Google Users'}. "</h1>\n";

print "<table cellspacing=\"0\" cellpadding=\"3\" border=\"1\">\n";

# Now get all GDoc Users
my %googleusers = ();
my $users = $gd->getAllUsers();
#use Data::Dumper;
my $count = 1;

foreach my $user ( sort keys %$users ) {

    my $ref = $$users{ $user };
    print "<tr><td>$count: $$ref{givenName}  $$ref{familyName} ($user)</td></tr>\n";

    $count++;

}

print "</table></body></html>\n";
