#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Update External Users - (on other servers)
#  Copy a command file to another server.


my %lex = ('Main' => 'Main',
	   'Combine failed on input' => 'Combine failed on input',
	   'Error' => 'Error',
	   'Reset External Users' => 'Reset External Users',
	   'File Copy Complete' => 'File Copy Complete',
	   'User' => 'User',
	   'Reset Password' => 'Reset Password',
	   'Unlock User' => 'Unlock User',
	   'Lock User' => 'Lock User',
	   'Continue' => 'Continue',
	   
	   );

# now pulled from usermanage.conf
#my $remoteuser = 'openadmin'; # account on remote server
#my $remotepassword = 'REMOTEPASSWORD'; # password on remote server
#my $remoteip = '10.192.x.x'; # IP Address of remote server


use DBI;
use CGI;
use Text::CSV_XS;
use Net::SCP::Expect;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/usermanage.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = CGI->new;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


# Write HTML Header
print "$doctype\n<html><head><title>". $lex{'Reset External Users'}. "</title>\n";
print "<link rel=\"stylesheet\" type=\"text/css\" href=\"$css\">\n";
print "<style type=\"text/css\"> .cn { text-align:center;} .la {text-align:left;}</style>\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";
#print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";

print "<center><h1>". $lex{'Reset External Users'}. "</h1>\n";

# Open Database
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;


if ( not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
    processUsers();
}



#---------------
sub processUsers {
#---------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Setup Select
    $sth = $dbh->prepare("select password from studentall where studnum = ? ");
    $sth->execute;

    my $csv = Text::CSV_XS->new( {binary => 1} );

    # Open output file
    my $filename = "resetstudent$$.csv";
    open (EX,">$filename") || die "Can't open Export file $fileName";

    # write to the file
    foreach my $key ( sort keys %arr ) {

	my ( $studnum, $action ) = split /:/, $key;
	$sth->execute( $studnum );
	if ($DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $password = $sth->fetchrow;

	my @arr = ( $studnum, $action, $password );

	if ( $csv->combine(@arr) ) {
	    my $record = $csv->string;
	    print EX $record, "\r\n";
	} else {
	    my $err = $csv->error_input;
	    print $lex{'Combine failed on input'}. ": $err\n\n";
	}
    }

    close EX;

    # Now copy to external server.
    my $scpe = Net::SCP::Expect->new( auto_yes => 1 );
    $scpe->login( $remoteuser, $remotepassword );
    $scpe->scp( $filename, $remoteip. ':studentreset.csv' );

    system("rm -f $filename");

    print "<div style=\"font-size:130%;font-weight:bold;\">". $lex{'File Copy Complete'}. "</div>\n";
    print "</body></html>\n";

    exit;

}



#----------------
sub showStartPage {
#----------------

    # Select student fields
    $sth = $dbh->prepare("select lastname, firstname, studnum from student 
      order by lastname,firstname");
    $sth->execute;

    # Start Form
    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    # Print Table heading
    print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"1\">\n";

    print "<tr><td colspan=\"4\" style=\"text-align:center;\"><input type=\"submit\" value=\"";
    print $lex{Continue}. "\"></td></tr>\n";

    print "<tr><th>". $lex{User}. "</th><th>". $lex{'Reset Password'}. "</th>\n<th>";
    print $lex{'Lock User'}. "</th><th>". $lex{'Unlock User'}. "</th></tr>\n";

    my $count = 1;

    # print student rows.
    while ( my ( $lastname, $firstname, $studnum ) = $sth->fetchrow ) {
	print "<tr><td class=\"la\"><b>$lastname</b>, $firstname</td>\n";
	print "<td class=\"cn\"><input type=\"checkbox\" name=\"$studnum:reset\" value=\"1\"></td>\n";
	print "<td class=\"cn\"><input type=\"checkbox\" name=\"$studnum:lock\" value=\"1\"></td>\n";
	print "<td class=\"cn\"><input type=\"checkbox\" name=\"$studnum:unlock\" value=\"1\"></td></tr>\n";
	
	if ( $count % 15 == 0 ) {
	    print "<tr><th>". $lex{User}. "</th><th>". $lex{'Reset Password'}. "</th>\n<th>";
	    print $lex{'Lock User'}. "</th><th>". $lex{'Unlock User'}. "</th></tr>\n";
	}
	$count++;


    }

    print "<tr><td colspan=\"4\" style=\"text-align:center;\"><input type=\"submit\" value=\"";
    print $lex{Continue}. "\"></td></tr>\n";

    print "</table></form></body></html>\n";

    exit;

}
