#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Import Students' => 'Import Students',
	   'Export' => 'Export',
	   'Upload Exports.zip Data file' => 'Upload Exports.zip Data file',
	   'Error Reading Record' => 'Error Reading Record',
	   'The file must be a .zip file!' => 'The file must be a .zip file!',
	   'Maximum File Upload size exceeded!' => 'Maximum File Upload size exceeded!',
	   'Cannot open file' => 'Cannot open file',
	   'Continue' => 'Continue',
	   'Skip' => 'Skip',
	   'Add' => 'Add',


	   );

my $self = 'importstudentdbf.pl';

my $maxbufcount = 1500; # 500k max; change as required
my $maxrecorddisplay = 5;

use DBI;
use CGI;
use Xbase;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);
$dbh->{mysql_enable_utf8} = 1;

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'Import Students'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$exppage\">". $lex{Export}. "</a> ]\n";
print "<center><h1>". $lex{'Import Students'}. "</h1></center>\n";

if ( not $arr{page} ) {
    showStartPage();
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    uploadFile();
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    importStudents();
}


#---------------
sub uploadFile {
#---------------

    my $file = $q->param("filename");
    my $name; my $ext; 
    my $filename = $file;  # fileName is output filename, file is input.

    if ( $file ) {

	$filename =~ s!^.*(\\|\/)!!; 
	$filename = lc($filename);
	@name = split /\./, $filename; # split on dots.
	$ext = $name[$#name];  # last element is the extension.
	unless ( $ext eq 'zip' ){
	    print "<b>". $lex{'The file must be a .zip file!'}. "</b>";
	    print "</body></html>\n";
	    die;
	}

	pop(@name); # pull off extension.
	foreach $n (@name){ $name .= "$n.";} # assemble name 
	chop; # remove trailing dot

	open ( OUTFILE, ">$filename") || 
	    die $lex{'Cannot open file'}. " $filename"; 
	my $bufcount = 0;
	while ( my $bytesread = read( $file, my $buffer, 1024) ) { 
	    print OUTFILE $buffer;
	    $bufcount++;
	    if ( $bufcount > $maxbufcount ) {
		print "<h1>". $lex{'Maximum File Upload size exceeded!'};
		print " ($maxbufcount K)</h1>\n";
		print "</body></html>\n";
		die $lex{'Maximum File Upload size exceeded!'};
	    }
	}

	close OUTFILE;

    } else {
	print $lex{'Cannot open file'};
	print "</body></html>\n";
    }

    # We should now have the file in place.


    # Now create the form for field name selection.
    print "<center><form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"filename\" value=\"$filename\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";

    print "<input type=\"submit\" value=\"". $lex{Continue}. "\">\n";

    print "</center></body></html>\n";

    exit;
}


#----------------
sub showStartPage {
#----------------

    print "<center><table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n";

    print "<form action=\"$self\" method=\"post\"  enctype=\"multipart/form-data\">\n";
    print "<input type=\"file\" name=\"filename\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";

    print "<tr><td colspan=\"2\" align=\"center\">";
    print "<input type=\"submit\" value=\"". $lex{'Upload Exports.zip Data file'}. "\">\n";
    print "</td></tr></form></table></body></html>\n";

    exit;

}


#-----------------
sub importStudents {
#-----------------

    my $zipfile = $arr{filename};
    delete $arr{filename};

    # We should create a temporary folder and unzip the file there and
    # then import dbf records from there.

    my $tempdir = "tempdir$$";
    my $res = system("mkdir $tempdir");

    system("unzip $zipfile -d $tempdir > /dev/null");

    # now get the student file
    my $db = new Xbase;
    $db->open_dbf( "$tempdir/_Studs.DBF");
    
    #print $db->dbf_type;
    #$db->dbf_stat;
    #die;

    while ( not $db->eof ) {

	my @fields = $db->get_record;
	my @values = ();
	my @fieldnames = ();

#	$fldcount = 0;
#	foreach my $fld ( @fields ) {
#	    print "$fldcount: $fld\n";
#	    $fldcount++;
#	}


	my ($studnum, $firstname, $lastname ) = @fields[0..2];

	# Check for existing student...
	my $sth = $dbh->prepare("select count(*) from student where studnum = ?");
	$sth->execute( $studnum );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my $studcount = $sth->fetchrow;
	if ( $studcount ) {
	    print $lex{Skip}. " $firstname $lastname ($studnum)<br>\n";
	    $db->go_next;
	    next;

	}

	push @values, $studnum;
	push @fieldnames, 'studnum';
	push @values, $firstname;
	push @fieldnames, 'firstname';
	push @values, $lastname;
	push @fieldnames, 'lastname';


	my ($gender, $grade, $bdate ) = @fields[6..8];
	my ( $year, $month, $day ) = unpack("A4,A2,A2", $bdate);
	my $birthdate = "$year-$month-$day";

	push @values, $birthdate;
	push @fieldnames, 'birthdate';
	push @values, $gender;
	push @fieldnames, 'sex';
	push @values, $grade;
	push @fieldnames, 'grade';



	my ($provnum, $hsn) = @fields[12..13];
	push @values, $provnum ; push @fieldnames, 'provnum';
	push @values, $hsn ; push @fieldnames, 'healthid';

	my ($streetno, $street, $city, $prov,$country, $phone, $dud1, $dud2,$pcode ) = @fields[23..31];
	my $address = $streetno. q{ }. $street;
	push @values, $address ; push @fieldnames, 'address1';
	push @values, $city ; push @fieldnames, 'city1';
	push @values, $prov ; push @fieldnames, 'prov1';
	push @values, $phone ; push @fieldnames, 'hphone1';
	push @values, $pcode ; push @fieldnames, 'pcode1';

	# push @values, $ ; push @fieldnames, '';

	# print "$firstname $lastname ($studnum) Gender:$gender  Grade:$grade Bdate:$birthdate\n";
	# print "PN:$provnum | HSN:$hsn\n";
	# print "$streetno | $street | $city | $prov | $country | $pcode | $phone \n\n"; 

	my $fields = join(',', @fieldnames );
	foreach my $val ( @values ) {
	    $val = $dbh->quote( $val );
	}
	my $values = join(',', @values );

	# print "Insert Fields: $fields  Values: $values<br>\n";
	$sth = $dbh->prepare("insert into student ( $fields ) values( $values )");
	$sth->execute;
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }	
	print "<div><b>". $lex{Add}. "</b> $firstname $lastname<div>\n";

	$db->go_next;

    }
    
    $db->close_dbf;


    # Clean up temporary folder, etc.
    system("rm -f $zipfile");
    system("rm -rf $tempdir");

    exit;

}
