#!/usr/bin/perl

# This file is part of Open Administration for Schools
# Copyright Leslie Richardson 2001-2010
# Licensed under the GNU GPL version 3

my %lex = ( 'Cannot open file' => 'Cannot open file',


	    );


my $studentfilelocation = '/home/openadmin';
my $studentaddfile = 'useradd.csv';
my $studentresetfile = 'studentreset.csv';

my $addfilename = "$studentfilelocation/$studentaddfile";
my $resetfilename = "$studentfilelocation/$studentresetfile";

my $useraddex = '/usr/sbin/useradd';
my $passwdex = '/usr/bin/passwd';
my $homedirsbase = '/home';
my $defshell = '/bin/bash';

my $defgroup = 'students'; # must already be defined.

my $response1 = 'New UNIX password: ';
my $response2 = "Retype new UNIX password: ";
my $response3 = "updated successfully.";


# check for existence of student add file.
if ( not -e $addfilename and not -e $resetfilename ) {
    exit;
}

use Text::CSV_XS;
my $csv = Text::CSV_XS->new( {binary => 1} );

if ( -e $addfilename ) { # add students

    # Open csv file for reading
    unless ( open ( FH,"<$addfilename" ) ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }


    # Create %exists hash of existing accounts
    my %exists = ();
    while ( my ($studacct, $password, $uid, $gid, $quota, $comment, $gcos,
		$duration, $shell, $expire ) = getpwent() ) {
   
	#print "Name: $studacct $uid - $gcos - $shell - $expire\n";
	$exists{ $studacct } = $gcos. q{ - }. $uid;
    }


    my @records = ();
    my %fullname = ();
    my %password = ();

    my $count = 1;

    while ( my $line = <FH> ) {

	#print "LINE: $line<br>\n";

	if ( $csv->parse($line) ) {
	    my ( $fullname, $studnum, $password, $school ) = $csv->fields;
 	    my $studacct;
            if ( $studnum =~ /\d/ ) {
	       $studacct = 's'. $studnum; # prepend an 's' to the account.
            } else {
		$studacct = $studnum; # a staff member account
	    }	

	    if ( not $exists{ $studacct } ) {

		print "$count: $fullname - $studacct\n";
		
		insertUser( $studacct, $fullname, $password );

		$count++;

		#if ( $count > 1 ) { die; } # for testing...

	    }

	} else { # Failure to parse
	    print 'Error Reading Record'. ":<br>$line<br>\n";
	    die;
	}
    }

    close FH;

    if ( $count == 1) { # no students added
	print "Student Users are up to date\n";
    }

    system("rm -f $addfilename"); # remove OA uploaded file

} # end of addstudentfile.


# Now do the resets: lock, unlock, password
if ( -e $resetfilename ) {
    print "Reset File Open \n";

    # Open csv file for reading
    unless ( open ( FH,"<$resetfilename" ) ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }


    while ( my $line = <FH> ) {
	
	#print "LINE: $line<br>\n";

	my $studacct;
	my ( $studnum, $action, $password );
	if ( $csv->parse($line) ) {
	    ( $studnum, $action, $password ) = $csv->fields;
	    $studacct = 's'. $studnum; # prepend an 's' to the account.
	} else { # Failure to parse
	    print 'Error Reading Record'. ":<br>$line<br>\n";
	    die;
	}

	print "Stud: $studacct ($studnum) Action: $action Password: $password\n";

	if ( $action eq 'lock') {
	    system("$passwdex -l $studacct");
	    print "Did Lock\n";
	} elsif ( $action eq 'unlock' ) {
	    system("$passwdex -u $studacct");
	    print "Did Unlock\n";
	} elsif ( $action eq 'reset' ) {
	    # change password
	    changePassword( $studacct, $password );
	    print "Did password update\n";
	}
    }

    system("rm -f $resetfilename"); # remove file

}




#-------------
sub insertUser {  # insert a new user
#-------------

    # Create a user account, passed a value.
    my $username = shift;
    my $realname = shift;
    my $password = shift;

    # print "User: $username Real:$realname  Password:$password\n";


    # We only need to set group, homedir, shell, and comment. 

    $homedir = $homedirsbase. '/'. $username;

    my @command = ();
    push @command, $useraddex;
    push @command, " -g $defgroup ";
    push @command, " -d '$homedir' ";
    #push @command, " -s $defshell ";
    push @command, " -c '$realname' ";
    push @command, " $username ";

    # print @command;

    system(" @command ");

    print "\nDone!\n";

    # Now Change password
    use Expect;

    my $pobj = Expect->spawn( $passwdex, $username );
    if ( not defined $pobj ) {
	die "Cannot create pwd object\n";
    }

    # $pobj->log_studout(0);

    $pobj->expect(10, $response1 );
    sleep 1;
    print $pobj "$password\n";

    $pobj->expect(10, $response2 );
    sleep 1;
    print $pobj "$password\n";

    my $result = ( defined ( $pobj->expect(10, $response3 )) ?
		   "" : "password change failed");

    $pobj->soft_close();

} # end of insertUser.



#-----------------
sub changePassword {
#-----------------

    my ( $username, $password ) = @_;

    # Now Change password
    use Expect;

    my $pobj = Expect->spawn( $passwdex, $username );
    if ( not defined $pobj ) {
	die "Cannot create pwd object\n";
    }

    # $pobj->log_studout(0);

    $pobj->expect(10, $response1 );
    sleep 1;
    print $pobj "$password\n";

    $pobj->expect(10, $response2 );
    sleep 1;
    print $pobj "$password\n";

    my $result = ( defined ( $pobj->expect(10, $response3 )) ?
		   "" : "password change failed");

    $pobj->soft_close();


}
