#!/usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Extract phrase values from html templates, scripts, and meta data
# and used to populate the xlat_phrase table.

my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Find Perl Modules' => 'Find Perl Modules',
	   'Continue' => 'Continue',
	   'Cannot open file' => 'Cannot open file',
	   'Done' => 'Done',

	   );

my $self = 'findPerlModules.pl';

use CGI;
use File::Find;

my %modules = ();


extractModule();

 
 

#---------------
sub extractModule {
#---------------

    my $cgipath = 'cgi';
    my $tcgipath = 'tcgi';

    find(\&parseFile, $cgipath );


    find(\&parseFile, $tcgipath );


    foreach my $module ( sort keys %modules ) {

	my $statement = 'use '. $module. ';';
	print "Test: $statement\n";
	eval $statement;
	if ( $@ ) {
	    print "Error: $@\n";
	}
    }

    return;

} # end of extractModule



#------------
sub parseFile {  # extract version
#------------

    my $cgifile = $_;

    if ( $cgifile eq '.' or $cgifile eq '..' ) { return }
    if ( not $cgifile =~ m/.*\.pl/ ) { return }

    # Open File
    unless ( open (FH,"<$cgifile") ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";

    }

#    print " $cgifile "; 

    while ( my $line = <FH> ) {
	if ( $line =~ m/^\s*use (.+)/ ){
	    my $temp = $1;
	    $temp =~ s/;//;
	    $temp =~ s/qw.+//;
	    $temp =~ s/\s+$//;
	    $modules{ $temp } = 1;
	}
    }

    return;

} # end of parseFile
