#!/usr/bin/perl

# Add Staff...
use DBI;

# Add course enrollments for elementary grades;


my ($password, $dbase) = @ARGV;

if ( not $password ) {
    print "Usage: ./addCourseEnrol password dbase\n";
    exit;
}

my $user = 'root';

my @grades = qw(K 1 2 3 4 5 6 7 8 9);
my @hsgrades = qw(10 11 12);

my $dsn = "DBI:MariaDB:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get the homerooms for all teacher;
my %homeroom;
my $sth = $dbh->prepare("select userid, field_value from staff_multi where field_name = 'homeroom'");
$sth->execute;
if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
while ( my ($userid, $hr ) = $sth->fetchrow ) {
    $homeroom{$userid} = $hr;  # only 1 teacher for 1 homeroom.
}
    

my $sth1 = $dbh->prepare("insert into eval ( subjcode, studnum, term )  values( ?, ?, ?)");
my $sth2 = $dbh->prepare("select subjsec, teacher from subject where grade = ?");
my $sth3 = $dbh->prepare("select studnum from student where homeroom = ?");


foreach my $grade ( @grades ) { # do grades 1 to 9

    # Get the courses for this grade, and ident the teacher, get his/her homeroom, 
    #and enrol the kids in all his/her courses;
    $sth2->execute( $grade );
    if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

    # Loop through courses for this grade
    while ( my ($subjsec, $userid ) = $sth2->fetchrow ) {
	
	my $hr = $homeroom{$userid};

	print "Grade:$grade Subjsec:$subjsec User:$userid\n";
	
	# Get students in this homeroom
	$sth3->execute( $hr );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
	while ( my $studnum = $sth3->fetchrow ) {
	    for my $term (1..3) {
		$sth1->execute( $subjsec, $studnum, $term );
	    }
	}
    } # end of course loop

} # end of grade loop

# high school
my $sth2 = $dbh->prepare("select subjsec, teacher, startrptperiod, endrptperiod
  from subject where grade = ?");
my $sth3 = $dbh->prepare("select studnum from student where grade = ?");

foreach my $grade ( @hsgrades ) { # do grades 10 to 12

    # Get the courses for this grade, and ident the teacher, get his/her homeroom, 
    #and enrol the kids in all his/her courses;
    $sth2->execute( $grade );
    if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

    # Loop through courses for this grade
    while ( my ($subjsec, $userid, $startterm, $endterm ) = $sth2->fetchrow ) {

	print "Grade:$grade Subjsec:$subjsec Terms:$startterm - $endterm\n";
	
	# Get students in this grade
	$sth3->execute( $grade );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }
	while ( my $studnum = $sth3->fetchrow ) {
	    for my $term ($startterm..$endterm) {
		$sth1->execute( $subjsec, $studnum, $term );
	    }
	}
    } # end of HS course loop

} # end of grade loop

	
print "Done!\n";
