#!/usr/bin/perl

use DBI;
use Crypt::GeneratePassword qw(:all); # password generation.
use Time::JulianDay;


my ($password, $dbase) = @ARGV;

if ( not $password ) {
    print "Usage: ./addstudent.pl password database\n";
    exit;
}

my $user = 'root';

my $studnum = 100;
my @grades = qw(K 1 2 3 4 5 6 7 8 9 10 11 12);
my $classSize = 18;
my $currentyear = 2021;


# Password configuration
$g_studentpwd_caps = 1;
$g_studentpwd_genlen = 6;
$g_studentpwd_maxlen = 6;
$g_studentpwd_minlen = 4;
$g_studentpwd_signs = 0;
$g_studentpwd_minfreq = .001;
$g_studentpwd_avgfreq = .001;
$g_studentpwd_lang = 'en'; # only en or de available.


my $dsn = "DBI:MariaDB:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Load the names
my @firstname;
my @lastname;

open(FH, "<firstname.txt");
while (<FH>) {
    chomp $_;
    push @firstname, $_;
}

open(FH, "<lastname.txt");
while (<FH>) {
    chomp $_;
    push @lastname, $_;
}

my $studcount = $classSize * ( $#grades + 1 );

print "Studcount:$studcount\n";


# Create an array of student names
my %names;
for my $counter ( 1 .. $studcount ) {

    my $newname;
    do {
	my $fnum = int( rand( $#firstname ));
	my $fname = $firstname[$fnum];

	my $lnum = int( rand( $#lastname ));
	my $lname = $lastname[$lnum];

	$newname = "$lname:$fname";

    } until ( not $names{$newname} );
    $names{$newname} = 1;

}

my @names = keys %names; # make a new name array out of hash.


my $sth = $dbh->prepare("insert into student 
 ( studnum, firstname, lastname, password, grade, homeroom, birthdate ) 
 values( ?, ?, ?, ?, ?, ?, ?)");


foreach my $grade ( @grades ) {
    
    my $suffix = 'b';
    for my $idx ( 1.. $classSize ) {

	# Pick a birthdate, based on grade;
	my $age;
	if ( $grade eq 'K' ) {
	    $age = 5;
	} else {
	    $age = $grade + 5;
	}

	$birthyear = $currentyear - $age;
	$basedatejd = julian_day( $birthyear, 9, 1); # Sept 1 cutoff date

	my $offset = int( rand( 364));
	my $bdayjd = $basedatejd + $offset;
	my ($yr, $mo, $da) = inverse_julian_day( $bdayjd );
	my $birthdate = "$yr-$mo-$da";

	# Set Homeroom
	if ( $suffix eq 'b' ) {
	    $suffix = 'a';
	} else {
	    $suffix = 'b';
	}
	my $homeroom = $grade. $suffix;
	

	# Get Name
	my $n = pop @names;
	my ($lastname, $firstname ) = split(/:/, $n);


	# Get Password
	my $password = word( $g_studentpwd_minlen, $g_studentpwd_maxlen,
			     $g_studentpwd_lang, $g_studentpwd_signs,
			     $g_studentpwd_caps, $g_studentpwd_minfreq,
			     $g_studentpwd_avgfreq );


	print "Name:$firstname $lastname ($grade) $password - $birthdate\n";
	$sth->execute($studnum, $firstname, $lastname, $password, $grade, $homeroom, $birthdate );
	if ($DBI::errstr){ print "$lex{Error}: $DBI::errstr; $!\n"; die $DBI::errstr; }

	$studnum++;


    } # end of class loop
} # end of grade loop


print "Done!\n";
